/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import io.vlingo.actors.Actor;
import io.vlingo.actors.Definition;
import io.vlingo.actors.World;
import io.vlingo.common.Completes;
import io.vlingo.common.Failure;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.EntryAdapterProvider;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapterProvider;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.dispatch.DispatcherControl;
import io.vlingo.symbio.store.state.StateStore;
import io.vlingo.symbio.store.state.StateStoreEntryReader;
import io.vlingo.symbio.store.state.StateTypeStateStoreMap;
import io.vlingo.symbio.store.state.dynamodb.DynamoDBDispatcherControlActor;
import io.vlingo.symbio.store.state.dynamodb.DynamoDBStateStoreEntryReaderActor;
import io.vlingo.symbio.store.state.dynamodb.adapters.RecordAdapter;
import io.vlingo.symbio.store.state.dynamodb.handlers.BatchWriteItemAsyncHandler;
import io.vlingo.symbio.store.state.dynamodb.handlers.GetEntityAsyncHandler;
import io.vlingo.symbio.store.state.dynamodb.interests.CreateTableInterest;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynamoDBStateActor<RS extends State<?>>
extends Actor
implements StateStore {
    public static final String DISPATCHABLE_TABLE_NAME = "vlingo_dispatchables";
    private final Dispatcher<Dispatchable<Entry<?>, RS>> dispatcher;
    private final DispatcherControl dispatcherControl;
    private final AmazonDynamoDBAsync dynamodb;
    private final CreateTableInterest createTableInterest;
    private final Map<String, StateStoreEntryReader<?>> entryReaders;
    private final EntryAdapterProvider entryAdapterProvider;
    private final StateAdapterProvider stateAdapterProvider;
    private final RecordAdapter<RS> recordAdapter;

    public DynamoDBStateActor(Dispatcher<Dispatchable<Entry<?>, RS>> dispatcher, DispatcherControl dispatcherControl, AmazonDynamoDBAsync dynamodb, CreateTableInterest createTableInterest, RecordAdapter<RS> recordAdapter) {
        this.dispatcher = dispatcher;
        this.dynamodb = dynamodb;
        this.createTableInterest = createTableInterest;
        this.recordAdapter = recordAdapter;
        this.dispatcherControl = dispatcherControl;
        this.entryAdapterProvider = EntryAdapterProvider.instance((World)this.stage().world());
        this.stateAdapterProvider = StateAdapterProvider.instance((World)this.stage().world());
        this.entryReaders = new HashMap();
        createTableInterest.createDispatchableTable(dynamodb, DISPATCHABLE_TABLE_NAME);
        dispatcher.controlWith(dispatcherControl);
    }

    public DynamoDBStateActor(Dispatcher<Dispatchable<Entry<?>, RS>> dispatcher, AmazonDynamoDBAsync dynamodb, CreateTableInterest createTableInterest, RecordAdapter<RS> recordAdapter) {
        this.dispatcher = dispatcher;
        this.dynamodb = dynamodb;
        this.createTableInterest = createTableInterest;
        this.recordAdapter = recordAdapter;
        this.entryAdapterProvider = EntryAdapterProvider.instance((World)this.stage().world());
        this.stateAdapterProvider = StateAdapterProvider.instance((World)this.stage().world());
        this.entryReaders = new HashMap();
        createTableInterest.createDispatchableTable(dynamodb, DISPATCHABLE_TABLE_NAME);
        this.dispatcherControl = (DispatcherControl)this.stage().actorFor(DispatcherControl.class, Definition.has(DynamoDBDispatcherControlActor.class, (List)Definition.parameters((Object[])new Object[]{dispatcher, dynamodb, recordAdapter, 1000L, 1000L})));
        dispatcher.controlWith(this.dispatcherControl);
    }

    public void read(String id, Class<?> type, StateStore.ReadResultInterest interest, Object object) {
        this.doGenericRead(id, type, interest, object);
    }

    public <S, C> void write(String id, S state, int stateVersion, List<Source<C>> sources, Metadata metadata, StateStore.WriteResultInterest interest, Object object) {
        this.doGenericWrite(id, state, stateVersion, sources, metadata, interest, object);
    }

    public <ET extends Entry<?>> Completes<StateStoreEntryReader<ET>> entryReader(String name) {
        StateStoreEntryReader reader = this.entryReaders.get(name);
        if (reader == null) {
            reader = (StateStoreEntryReader)this.childActorFor(StateStoreEntryReader.class, Definition.has(DynamoDBStateStoreEntryReaderActor.class, (List)Definition.parameters((Object[])new Object[]{name})));
            this.entryReaders.put(name, reader);
        }
        return this.completes().with(reader);
    }

    protected final String tableFor(Class<?> type) {
        String tableName = "vlingo_" + type.getCanonicalName().replace(".", "_");
        StateTypeStateStoreMap.stateTypeToStoreName(type, (String)tableName);
        return tableName;
    }

    private final void doGenericRead(String id, Class<?> type, StateStore.ReadResultInterest interest, Object object) {
        this.dynamodb.getItemAsync(this.readRequestFor(id, type), new GetEntityAsyncHandler(id, interest, object, this.recordAdapter::unmarshallState, this.stateAdapterProvider));
    }

    private final <S, C> void doGenericWrite(String id, S state, int stateVersion, List<Source<C>> sources, Metadata metadata, StateStore.WriteResultInterest interest, Object object) {
        State raw;
        block5: {
            String tableName = this.tableFor(state.getClass());
            this.createTableInterest.createEntityTable(this.dynamodb, tableName);
            raw = metadata == null ? this.stateAdapterProvider.asRaw(id, state, stateVersion) : this.stateAdapterProvider.asRaw(id, state, stateVersion, metadata);
            try {
                Map foundItem = this.dynamodb.getItem(this.readRequestFor(id, state.getClass())).getItem();
                if (foundItem == null) break block5;
                try {
                    RS savedState = this.recordAdapter.unmarshallState(foundItem);
                    if (((State)savedState).dataVersion > raw.dataVersion) {
                        interest.writeResultedIn(Failure.of((Throwable)new StorageException(Result.ConcurrencyViolation, "Concurrent modification of: " + id)), id, state, stateVersion, sources, object);
                        return;
                    }
                }
                catch (Exception e) {
                    interest.writeResultedIn(Failure.of((Throwable)new StorageException(Result.Failure, e.getMessage(), (Throwable)e)), id, state, stateVersion, sources, object);
                    return;
                }
            }
            catch (Exception foundItem) {
                // empty catch block
            }
        }
        List entries = this.entryAdapterProvider.asEntries(sources, metadata);
        Dispatchable dispatchable = new Dispatchable(state.getClass().getName() + ":" + id, LocalDateTime.now(), raw, entries);
        Map<String, List<WriteRequest>> transaction = this.writeRequestFor(raw, dispatchable);
        BatchWriteItemRequest request = new BatchWriteItemRequest(transaction);
        this.dynamodb.batchWriteItemAsync(request, new BatchWriteItemAsyncHandler<S, RS, C>(id, state, stateVersion, sources, interest, object, dispatchable, this.dispatcher, this::doDispatch));
    }

    private GetItemRequest readRequestFor(String id, Class<?> type) {
        String table = this.tableFor(type);
        Map<String, AttributeValue> stateItem = this.recordAdapter.marshallForQuery(id);
        return new GetItemRequest(table, stateItem, Boolean.valueOf(true));
    }

    private Map<String, List<WriteRequest>> writeRequestFor(RS raw, Dispatchable<Entry<?>, RS> dispatchable) {
        HashMap<String, List<WriteRequest>> requests = new HashMap<String, List<WriteRequest>>(2);
        requests.put(this.tableFor(raw.typed()), Collections.singletonList(new WriteRequest(new PutRequest(this.recordAdapter.marshallState(raw)))));
        requests.put(DISPATCHABLE_TABLE_NAME, Collections.singletonList(new WriteRequest(new PutRequest(this.recordAdapter.marshallDispatchable(dispatchable)))));
        return requests;
    }

    private Void doDispatch(Dispatchable<Entry<?>, RS> dispatchable) {
        this.dispatcher.dispatch(dispatchable);
        return null;
    }
}

