/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.dynamodb.adapters;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import io.vlingo.common.serialization.JsonSerialization;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.state.dynamodb.adapters.RecordAdapter;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class BinaryStateRecordAdapter
implements RecordAdapter<State.BinaryState> {
    private static final String ID_FIELD = "Id";
    private static final String CREATED_AT_FIELD = "CreatedAt";
    private static final String STATE_FIELD = "State";
    private static final String DATA_FIELD = "Data";
    private static final String TYPE_FIELD = "Type";
    private static final String METADATA_FIELD = "Metadata";
    private static final String TYPE_VERSION_FIELD = "TypeVersion";
    private static final String DATA_VERSION_FIELD = "DataVersion";

    @Override
    public Map<String, AttributeValue> marshallState(State.BinaryState state) {
        String metadataAsJson = JsonSerialization.serialized((Object)state.metadata);
        HashMap<String, AttributeValue> stateItem = new HashMap<String, AttributeValue>();
        stateItem.put(ID_FIELD, new AttributeValue().withS(state.id));
        stateItem.put(DATA_FIELD, new AttributeValue().withB(ByteBuffer.wrap((byte[])state.data)));
        stateItem.put(TYPE_FIELD, new AttributeValue().withS(state.type));
        stateItem.put(METADATA_FIELD, new AttributeValue().withS(metadataAsJson));
        stateItem.put(TYPE_VERSION_FIELD, new AttributeValue().withN(String.valueOf(state.typeVersion)));
        stateItem.put(DATA_VERSION_FIELD, new AttributeValue().withN(String.valueOf(state.dataVersion)));
        return stateItem;
    }

    @Override
    public Map<String, AttributeValue> marshallDispatchable(Dispatchable<Entry<?>, State.BinaryState> dispatchable) {
        HashMap<String, AttributeValue> stateItem = new HashMap<String, AttributeValue>();
        stateItem.put(ID_FIELD, new AttributeValue().withS(dispatchable.id()));
        stateItem.put(CREATED_AT_FIELD, new AttributeValue().withS(dispatchable.createdOn().toString()));
        if (dispatchable.state().isPresent()) {
            stateItem.put(STATE_FIELD, new AttributeValue().withS(JsonSerialization.serialized(dispatchable.state().get())));
        }
        return stateItem;
    }

    @Override
    public Map<String, AttributeValue> marshallForQuery(String id) {
        HashMap<String, AttributeValue> stateItem = new HashMap<String, AttributeValue>();
        stateItem.put(ID_FIELD, new AttributeValue().withS(id));
        return stateItem;
    }

    @Override
    public State.BinaryState unmarshallState(Map<String, AttributeValue> record) {
        try {
            return new State.BinaryState(record.get(ID_FIELD).getS(), Class.forName(record.get(TYPE_FIELD).getS()), Integer.valueOf(record.get(TYPE_VERSION_FIELD).getN()).intValue(), record.get(DATA_FIELD).getB().array(), Integer.valueOf(record.get(DATA_VERSION_FIELD).getN()).intValue(), (Metadata)JsonSerialization.deserialized((String)record.get(METADATA_FIELD).getS(), Metadata.class));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Dispatchable<Entry<?>, State.BinaryState> unmarshallDispatchable(Map<String, AttributeValue> item) {
        String id = item.get(ID_FIELD).getS();
        LocalDateTime createdAt = LocalDateTime.parse(item.get(CREATED_AT_FIELD).getS());
        String json = item.get(STATE_FIELD).getS();
        return new Dispatchable(id, createdAt, (State)JsonSerialization.deserialized((String)json, State.BinaryState.class), Collections.emptyList());
    }
}

