/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.dynamodb.handlers;

import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import io.vlingo.common.Failure;
import io.vlingo.common.Success;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.state.StateStore;
import java.util.List;
import java.util.function.Function;

public class BatchWriteItemAsyncHandler<S, RS extends State<?>, C>
implements AsyncHandler<BatchWriteItemRequest, BatchWriteItemResult> {
    private final String id;
    private final S state;
    private final int stateVersion;
    private final StateStore.WriteResultInterest interest;
    private final Dispatchable<Entry<?>, RS> dispatchable;
    private final Object object;
    private final Function<Dispatchable<Entry<?>, RS>, Void> dispatchState;
    private final List<Source<C>> sources;

    public BatchWriteItemAsyncHandler(String id, S state, int stateVersion, List<Source<C>> sources, StateStore.WriteResultInterest interest, Object object, Dispatchable<Entry<?>, RS> dispatchable, Dispatcher<Dispatchable<Entry<?>, RS>> dispatcher, Function<Dispatchable<Entry<?>, RS>, Void> dispatchState) {
        this.id = id;
        this.state = state;
        this.stateVersion = stateVersion;
        this.sources = sources;
        this.interest = interest;
        this.object = object;
        this.dispatchable = dispatchable;
        this.dispatchState = dispatchState;
    }

    public void onError(Exception e) {
        this.interest.writeResultedIn(Failure.of((Throwable)new StorageException(Result.NoTypeStore, e.getMessage(), (Throwable)e)), this.id, this.state, this.stateVersion, Source.none(), this.object);
    }

    public void onSuccess(BatchWriteItemRequest request, BatchWriteItemResult batchWriteItemResult) {
        this.interest.writeResultedIn(Success.of((Object)Result.Success), this.id, this.state, this.stateVersion, this.sources, this.object);
        this.dispatchState.apply(this.dispatchable);
    }
}

