/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.dynamodb.handlers;

import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DispatchAsyncHandler<RS extends State<?>>
implements AsyncHandler<ScanRequest, ScanResult> {
    private final Function<Map<String, AttributeValue>, Dispatchable<Entry<?>, RS>> unmarshaller;
    private final Function<Dispatchable<Entry<?>, RS>, Void> dispatchState;

    public DispatchAsyncHandler(Function<Map<String, AttributeValue>, Dispatchable<Entry<?>, RS>> unmarshaller, Function<Dispatchable<Entry<?>, RS>, Void> dispatchState) {
        this.unmarshaller = unmarshaller;
        this.dispatchState = dispatchState;
    }

    public void onError(Exception e) {
    }

    public void onSuccess(ScanRequest request, ScanResult scanResult) {
        List items = scanResult.getItems();
        for (Map item : items) {
            Dispatchable<Entry<?>, RS> dispatchable = this.unmarshaller.apply(item);
            this.dispatchState.apply(dispatchable);
        }
    }
}

