/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.dynamodb.handlers;

import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import io.vlingo.common.Failure;
import io.vlingo.common.Success;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapterProvider;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.state.StateStore;
import java.util.Map;
import java.util.function.Function;

public class GetEntityAsyncHandler<S, RS extends State<?>>
implements AsyncHandler<GetItemRequest, GetItemResult> {
    private final String id;
    private final StateStore.ReadResultInterest interest;
    private final Object object;
    final StateAdapterProvider stateAdapterProvider;
    private final Function<Map<String, AttributeValue>, RS> unmarshaller;

    public GetEntityAsyncHandler(String id, StateStore.ReadResultInterest interest, Object object, Function<Map<String, AttributeValue>, RS> unmarshaller, StateAdapterProvider stateAdapterProvider) {
        this.id = id;
        this.interest = interest;
        this.object = object;
        this.unmarshaller = unmarshaller;
        this.stateAdapterProvider = stateAdapterProvider;
    }

    public void onError(Exception e) {
        this.interest.readResultedIn(Failure.of((Throwable)new StorageException(Result.NoTypeStore, e.getMessage(), (Throwable)e)), this.id, null, -1, null, this.object);
    }

    public void onSuccess(GetItemRequest request, GetItemResult getItemResult) {
        Map item = getItemResult.getItem();
        if (item == null) {
            this.interest.readResultedIn(Failure.of((Throwable)new StorageException(Result.NotFound, "Iteam not found for: " + this.id)), this.id, null, -1, null, this.object);
            return;
        }
        try {
            State raw = (State)this.unmarshaller.apply(item);
            Object state = this.stateAdapterProvider.fromRaw(raw);
            this.interest.readResultedIn(Success.of((Object)Result.Success), this.id, state, raw.dataVersion, raw.metadata, this.object);
        }
        catch (Exception e) {
            this.interest.readResultedIn(Failure.of((Throwable)new StorageException(Result.Failure, e.getMessage(), (Throwable)e)), this.id, null, -1, null, this.object);
        }
    }
}

