/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.common.jdbc;

import io.vlingo.symbio.store.DataFormat;
import io.vlingo.symbio.store.common.jdbc.ConnectionProvider;
import io.vlingo.symbio.store.common.jdbc.DatabaseType;
import io.vlingo.symbio.store.common.jdbc.hsqldb.HSQLDBConfigurationProvider;
import io.vlingo.symbio.store.common.jdbc.mysql.MySQLConfigurationProvider;
import io.vlingo.symbio.store.common.jdbc.postgres.PostgresConfigurationProvider;
import io.vlingo.symbio.store.common.jdbc.yugabyte.YugaByteConfigurationProvider;
import java.sql.Connection;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;

public class Configuration {
    public static final long DefaultTransactionTimeout = 300000L;
    public final String actualDatabaseName;
    public final Connection connection;
    public final ConnectionProvider connectionProvider;
    public final DatabaseType databaseType;
    public final DataFormat format;
    public final String originatorId;
    public final boolean createTables;
    public final long transactionTimeoutMillis;
    protected final ConfigurationInterest interest;

    public static Configuration cloneOf(Configuration other) {
        try {
            return new Configuration(other.databaseType, other.interest, other.connectionProvider.driverClassname, other.format, other.connectionProvider.url, other.actualDatabaseName, other.connectionProvider.username, other.connectionProvider.password, other.connectionProvider.useSSL, other.originatorId, other.createTables, other.transactionTimeoutMillis, true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot clone the configuration for " + other.connectionProvider.url + " because: " + e.getMessage(), e);
        }
    }

    public static ConfigurationInterest interestOf(DatabaseType databaseType) {
        switch (databaseType) {
            case HSQLDB: {
                return HSQLDBConfigurationProvider.interest;
            }
            case MySQL: 
            case MariaDB: {
                return MySQLConfigurationProvider.interest;
            }
            case SQLServer: {
                break;
            }
            case Vitess: {
                break;
            }
            case Oracle: {
                break;
            }
            case Postgres: {
                return PostgresConfigurationProvider.interest;
            }
            case YugaByte: {
                return YugaByteConfigurationProvider.interest;
            }
        }
        throw new IllegalArgumentException("Database currently not supported: " + databaseType.name());
    }

    public Configuration(DatabaseType databaseType, ConfigurationInterest interest, String driverClassname, DataFormat format, String url, String databaseName, String username, String password, boolean useSSL, String originatorId, boolean createTables) throws Exception {
        this(databaseType, interest, driverClassname, format, url, databaseName, username, password, useSSL, originatorId, createTables, 300000L);
    }

    public Configuration(DatabaseType databaseType, ConfigurationInterest interest, String driverClassname, DataFormat format, String url, String databaseName, String username, String password, boolean useSSL, String originatorId, boolean createTables, long transactionTimeoutMillis) throws Exception {
        this(databaseType, interest, driverClassname, format, url, databaseName, username, password, useSSL, originatorId, createTables, 300000L, false);
    }

    private Configuration(DatabaseType databaseType, ConfigurationInterest interest, String driverClassname, DataFormat format, String url, String databaseName, String username, String password, boolean useSSL, String originatorId, boolean createTables, long transactionTimeoutMillis, boolean reuseDatabaseName) throws Exception {
        this.databaseType = databaseType;
        this.interest = interest;
        this.format = format;
        this.connectionProvider = new ConnectionProvider(driverClassname, url, databaseName, username, password, useSSL);
        this.actualDatabaseName = reuseDatabaseName ? databaseName : this.actualDatabaseName(databaseName);
        this.originatorId = originatorId;
        this.createTables = createTables;
        this.transactionTimeoutMillis = transactionTimeoutMillis;
        this.beforeConnect();
        this.connection = this.connect();
        this.afterConnect();
    }

    protected String actualDatabaseName(String databaseName) {
        return this.connectionProvider.databaseName;
    }

    protected void afterConnect() throws Exception {
        this.interest.afterConnect(this.connection);
    }

    protected void beforeConnect() throws Exception {
        this.interest.beforeConnect(this);
    }

    protected Connection connect() {
        return this.connectionProvider.connection();
    }

    public static class TestConfiguration
    extends Configuration {
        private static final AtomicInteger uniqueNumber = new AtomicInteger(0);

        public TestConfiguration(DatabaseType databaseType, ConfigurationInterest interest, String driverClassname, DataFormat format, String url, String databaseName, String username, String password, boolean useSSL, String originatorId, boolean createTables) throws Exception {
            super(databaseType, interest, driverClassname, format, url, databaseName, username, password, useSSL, originatorId, createTables);
        }

        public void cleanUp() {
            try (Connection ownerConnection = this.swapConnections();){
                try (Statement statement = ownerConnection.createStatement();){
                    ownerConnection.setAutoCommit(true);
                    this.interest.dropDatabase(ownerConnection, this.actualDatabaseName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        protected String actualDatabaseName(String databaseName) {
            return databaseName + "_" + uniqueNumber.incrementAndGet() + (this.format.isBinary() ? "b" : "t");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Connection connect() {
            Connection connection = super.connect();
            try (Statement statement = connection.createStatement();){
                this.interest.createDatabase(connection, this.actualDatabaseName);
                connection.close();
                ConnectionProvider copy = this.connectionProvider.copyReplacing(this.actualDatabaseName);
                Connection connection2 = copy.connection();
                return connection2;
            }
            catch (Exception e) {
                throw new IllegalStateException(this.getClass().getSimpleName() + ": Cannot connect because the server or database unavilable, or wrong credentials.", e);
            }
        }

        private Connection swapConnections() {
            try {
                this.connection.close();
                return this.connectionProvider.connection();
            }
            catch (Exception e) {
                throw new IllegalStateException(this.getClass().getSimpleName() + ": Cannot swap database to owner's because: " + e.getMessage(), e);
            }
        }
    }

    public static interface ConfigurationInterest {
        public void afterConnect(Connection var1) throws Exception;

        public void beforeConnect(Configuration var1) throws Exception;

        public void createDatabase(Connection var1, String var2) throws Exception;

        public void dropDatabase(Connection var1, String var2) throws Exception;
    }
}

