/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.common.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;

public class ConnectionProvider {
    public final String databaseName;
    public final String driverClassname;
    public final String url;
    public final String username;
    public final boolean useSSL;
    final String password;

    public ConnectionProvider(String driverClassname, String url, String databaseName, String username, String password, boolean useSSL) {
        this.driverClassname = driverClassname;
        this.url = url;
        this.databaseName = databaseName;
        this.username = username;
        this.password = password;
        this.useSSL = useSSL;
    }

    public Connection connection() {
        try {
            Class.forName(this.driverClassname);
            Properties properties = new Properties();
            properties.setProperty("user", this.username);
            properties.setProperty("password", this.password);
            properties.setProperty("ssl", Boolean.toString(this.useSSL));
            Connection connection = DriverManager.getConnection(this.url + this.databaseName, properties);
            connection.setAutoCommit(false);
            return connection;
        }
        catch (Exception e) {
            throw new IllegalStateException(this.getClass().getSimpleName() + ": Cannot connect because database unavailable or wrong credentials.");
        }
    }

    public ConnectionProvider copyReplacing(String databaseName) {
        return new ConnectionProvider(this.driverClassname, this.url, databaseName, this.username, this.password, this.useSSL);
    }
}

