/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.common.jdbc;

import java.sql.Connection;

public enum DatabaseType {
    HSQLDB,
    MySQL,
    MariaDB,
    Oracle,
    Postgres,
    SQLServer,
    Vitess,
    YugaByte;


    public static DatabaseType databaseType(Connection connection) {
        String url = "uninitialized-database-url";
        try {
            url = connection.getMetaData().getURL().toLowerCase();
            return DatabaseType.databaseType(url);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unknown database type for: " + url);
        }
    }

    public static DatabaseType databaseType(String url) {
        try {
            for (DatabaseType type : DatabaseType.values()) {
                if (!url.contains(type.name().toLowerCase())) continue;
                return type;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalStateException("Unknown database type for: " + url);
    }
}

