/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.common.jdbc.hsqldb;

import io.vlingo.symbio.store.DataFormat;
import io.vlingo.symbio.store.common.jdbc.Configuration;
import io.vlingo.symbio.store.common.jdbc.DatabaseType;
import java.sql.Connection;
import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.server.Server;

public class HSQLDBConfigurationProvider {
    public static final Configuration.ConfigurationInterest interest = new Configuration.ConfigurationInterest(){
        private Server databaseSever;
        private AtomicInteger databaseCount = new AtomicInteger(0);

        @Override
        public void afterConnect(Connection connection) {
        }

        @Override
        public void createDatabase(Connection connection, String databaseName) {
            this.databaseCount.incrementAndGet();
        }

        @Override
        public void dropDatabase(Connection connection, String databaseName) {
            boolean isDone;
            boolean bl = isDone = this.databaseCount.decrementAndGet() == 0;
            if (isDone) {
                this.databaseSever.shutdown();
                this.databaseSever = null;
            }
        }

        @Override
        public void beforeConnect(Configuration configuration) {
            if (this.databaseSever != null) {
                return;
            }
            this.databaseSever = new Server();
            this.databaseSever.start();
        }
    };

    public static Configuration configuration(DataFormat format, String url, String databaseName, String username, String password, String originatorId, boolean createTables) throws Exception {
        return new Configuration(DatabaseType.HSQLDB, interest, "org.hsqldb.jdbc.JDBCDriver", format, url, databaseName, username, password, false, originatorId, createTables);
    }

    public static Configuration.TestConfiguration testConfiguration(DataFormat format) throws Exception {
        return HSQLDBConfigurationProvider.testConfiguration(format, "testdb");
    }

    public static Configuration.TestConfiguration testConfiguration(DataFormat format, String databaseName) throws Exception {
        return new Configuration.TestConfiguration(DatabaseType.HSQLDB, interest, "org.hsqldb.jdbc.JDBCDriver", format, "jdbc:hsqldb:mem:", databaseName, "SA", "", false, "TEST", true);
    }
}

