/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.common.jdbc.yugabyte;

import io.vlingo.symbio.store.DataFormat;
import io.vlingo.symbio.store.common.jdbc.Configuration;
import io.vlingo.symbio.store.common.jdbc.DatabaseType;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;

public class YugaByteConfigurationProvider {
    public static final Configuration.ConfigurationInterest interest = new Configuration.ConfigurationInterest(){
        private Configuration configuration;

        @Override
        public void afterConnect(Connection connection) {
        }

        @Override
        public void beforeConnect(Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        public void createDatabase(Connection connection, String databaseName) throws Exception {
            try (Statement statement = connection.createStatement();){
                connection.setAutoCommit(true);
                statement.executeUpdate("CREATE DATABASE " + databaseName + " WITH OWNER = " + this.configuration.connectionProvider.username);
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                List<String> message = Arrays.asList(e.getMessage().split(" "));
                if (message.contains("database") && message.contains("already") && message.contains("exists")) {
                    return;
                }
                System.out.println("YugaByte database " + databaseName + " could not be created because: " + e.getMessage());
                throw e;
            }
        }

        @Override
        public void dropDatabase(Connection connection, String databaseName) throws Exception {
            try (Statement statement = connection.createStatement();){
                connection.setAutoCommit(true);
                statement.executeUpdate("DROP DATABASE " + databaseName);
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                System.out.println("YugaByte database " + databaseName + " could not be dropped because: " + e.getMessage());
            }
        }
    };

    public static Configuration configuration(DataFormat format, String url, String databaseName, String username, String password, String originatorId, boolean createTables) throws Exception {
        return new Configuration(DatabaseType.Postgres, interest, "org.postgresql.Driver", format, url, databaseName, username, password, false, originatorId, createTables);
    }

    public static Configuration.TestConfiguration testConfiguration(DataFormat format) throws Exception {
        return new Configuration.TestConfiguration(DatabaseType.Postgres, interest, "org.postgresql.Driver", format, "jdbc:postgresql://localhost:5433/", "vlingo_test", "postgres", "postgres", false, "TEST", true);
    }
}

