/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.journal.jdbc;

import io.vlingo.actors.Logger;
import io.vlingo.common.serialization.JsonSerialization;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.common.jdbc.Configuration;
import io.vlingo.symbio.store.common.jdbc.DatabaseType;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.DispatcherControl;
import io.vlingo.symbio.store.journal.jdbc.JDBCQueries;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;

public class JDBCDispatcherControlDelegate
implements DispatcherControl.DispatcherControlDelegate<Entry<String>, State.TextState> {
    static final String DISPATCHEABLE_ENTRIES_DELIMITER = "|";
    private final Connection connection;
    private final DatabaseType databaseType;
    private final Logger logger;
    private final PreparedStatement selectDispatchables;
    private final JDBCQueries queries;

    public JDBCDispatcherControlDelegate(Configuration configuration, Logger logger) throws SQLException {
        this.connection = configuration.connection;
        this.databaseType = configuration.databaseType;
        this.logger = logger;
        this.queries = JDBCQueries.queriesFor(configuration.connection);
        this.queries.createTables();
        this.selectDispatchables = this.queries.prepareSelectDispatchablesQuery(configuration.originatorId);
    }

    public Collection<Dispatchable<Entry<String>, State.TextState>> allUnconfirmedDispatchableStates() throws Exception {
        ArrayList<Dispatchable<Entry<String>, State.TextState>> dispatchables = new ArrayList<Dispatchable<Entry<String>, State.TextState>>();
        try (ResultSet result = this.selectDispatchables.executeQuery();){
            while (result.next()) {
                dispatchables.add(this.dispatchableFrom(result));
            }
        }
        return dispatchables;
    }

    public void confirmDispatched(String dispatchId) {
        try {
            this.queries.prepareDeleteDispatchableQuery(dispatchId).executeUpdate();
            this.doCommit();
        }
        catch (Exception e) {
            this.logger.error("vlingo/symbio-jdbc-" + (Object)((Object)this.databaseType) + ": Failed to confirm dispatch with id" + dispatchId, (Throwable)e);
            this.fail();
        }
    }

    public void stop() {
        try {
            this.queries.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void doCommit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            this.logger.error("vlingo/symbio-jdbc-" + (Object)((Object)this.databaseType) + ": Could not complete transaction", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private void fail() {
        try {
            this.connection.rollback();
        }
        catch (Exception e) {
            this.logger.error(this.getClass().getSimpleName() + ": Rollback failed because: " + e.getMessage(), (Throwable)e);
        }
    }

    private Dispatchable<Entry<String>, State.TextState> dispatchableFrom(ResultSet resultSet) throws SQLException, ClassNotFoundException {
        State.TextState state;
        String dispatchId = resultSet.getString(1);
        LocalDateTime createdOn = LocalDateTime.ofInstant(Instant.ofEpochMilli(resultSet.getLong(2)), ZoneId.systemDefault());
        String stateId = resultSet.getString(3);
        if (stateId != null && !stateId.isEmpty()) {
            String data = resultSet.getString(4);
            int dataVersion = resultSet.getInt(5);
            Class<?> type = Class.forName(resultSet.getString(6));
            int typeVersion = resultSet.getInt(7);
            String metadataValue = resultSet.getString(8);
            Metadata metadata = (Metadata)JsonSerialization.deserialized((String)metadataValue, Metadata.class);
            state = new State.TextState(stateId, type, typeVersion, data, dataVersion, metadata);
        } else {
            state = null;
        }
        String entriesIds = resultSet.getString(9);
        ArrayList<Entry<String>> entries = new ArrayList<Entry<String>>();
        if (entriesIds != null && !entriesIds.isEmpty()) {
            String[] ids;
            for (String entryId : ids = entriesIds.split("\\|")) {
                try (ResultSet result = this.queries.prepareSelectEntryQuery(Long.parseLong(entryId)).executeQuery();){
                    if (!result.next()) continue;
                    entries.add(this.entryFrom(result));
                }
            }
        }
        return new Dispatchable(dispatchId, createdOn, state, entries);
    }

    private Entry<String> entryFrom(ResultSet resultSet) throws SQLException, ClassNotFoundException {
        String id = resultSet.getString(1);
        String entryData = resultSet.getString(2);
        String entryType = resultSet.getString(3);
        int eventTypeVersion = resultSet.getInt(4);
        String entryMetadata = resultSet.getString(5);
        Class<?> classOfEvent = Class.forName(entryType);
        Metadata metadata = (Metadata)JsonSerialization.deserialized((String)entryMetadata, Metadata.class);
        return new BaseEntry.TextEntry(id, classOfEvent, eventTypeVersion, entryData, metadata);
    }
}

