/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.journal.jdbc;

import com.google.gson.Gson;
import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Address;
import io.vlingo.actors.Definition;
import io.vlingo.actors.World;
import io.vlingo.common.Completes;
import io.vlingo.common.Failure;
import io.vlingo.common.Success;
import io.vlingo.common.Tuple2;
import io.vlingo.common.identity.IdentityGenerator;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.EntryAdapterProvider;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapterProvider;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.common.jdbc.Configuration;
import io.vlingo.symbio.store.common.jdbc.DatabaseType;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.dispatch.DispatcherControl;
import io.vlingo.symbio.store.dispatch.control.DispatcherControlActor;
import io.vlingo.symbio.store.journal.Journal;
import io.vlingo.symbio.store.journal.JournalReader;
import io.vlingo.symbio.store.journal.StreamReader;
import io.vlingo.symbio.store.journal.jdbc.JDBCDispatcherControlDelegate;
import io.vlingo.symbio.store.journal.jdbc.JDBCJournalReaderActor;
import io.vlingo.symbio.store.journal.jdbc.JDBCQueries;
import io.vlingo.symbio.store.journal.jdbc.JDBCStreamReaderActor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class JDBCJournalActor
extends Actor
implements Journal<String> {
    private final EntryAdapterProvider entryAdapterProvider;
    private final StateAdapterProvider stateAdapterProvider;
    private final Configuration configuration;
    private final Connection connection;
    private final DatabaseType databaseType;
    private final Gson gson;
    private final Map<String, JournalReader<BaseEntry.TextEntry>> journalReaders;
    private final Map<String, StreamReader<String>> streamReaders;
    private final IdentityGenerator dispatchablesIdentityGenerator;
    private final Dispatcher<Dispatchable<Entry<String>, State.TextState>> dispatcher;
    private final DispatcherControl dispatcherControl;
    private final JDBCQueries queries;

    public JDBCJournalActor(Configuration configuration) throws Exception {
        this(null, configuration, 0L, 0L);
    }

    public JDBCJournalActor(Dispatcher<Dispatchable<Entry<String>, State.TextState>> dispatcher, Configuration configuration) throws Exception {
        this(dispatcher, configuration, 1000L, 1000L);
    }

    public JDBCJournalActor(Dispatcher<Dispatchable<Entry<String>, State.TextState>> dispatcher, Configuration configuration, long checkConfirmationExpirationInterval, long confirmationExpiration) throws Exception {
        this.configuration = configuration;
        this.connection = configuration.connection;
        this.databaseType = configuration.databaseType;
        this.connection.setAutoCommit(false);
        this.queries = JDBCQueries.queriesFor(configuration.connection);
        this.queries.createTables();
        this.gson = new Gson();
        this.entryAdapterProvider = EntryAdapterProvider.instance((World)this.stage().world());
        this.stateAdapterProvider = StateAdapterProvider.instance((World)this.stage().world());
        this.journalReaders = new HashMap<String, JournalReader<BaseEntry.TextEntry>>();
        this.streamReaders = new HashMap<String, StreamReader<String>>();
        this.dispatchablesIdentityGenerator = new IdentityGenerator.RandomIdentityGenerator();
        if (dispatcher != null) {
            this.dispatcher = dispatcher;
            JDBCDispatcherControlDelegate dispatcherControlDelegate = new JDBCDispatcherControlDelegate(Configuration.cloneOf(configuration), this.stage().world().defaultLogger());
            this.dispatcherControl = (DispatcherControl)this.stage().actorFor(DispatcherControl.class, Definition.has(DispatcherControlActor.class, (ActorInstantiator)new DispatcherControl.DispatcherControlInstantiator(dispatcher, (DispatcherControl.DispatcherControlDelegate)dispatcherControlDelegate, checkConfirmationExpirationInterval, confirmationExpiration)));
        } else {
            this.dispatcher = null;
            this.dispatcherControl = null;
        }
    }

    public void stop() {
        if (this.dispatcherControl != null) {
            this.dispatcherControl.stop();
        }
        try {
            this.queries.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.stop();
    }

    public <S, ST> void append(String streamName, int streamVersion, Source<S> source, Metadata metadata, Journal.AppendResultInterest interest, Object object) {
        Consumer<Exception> whenFailed = e -> this.appendResultedInFailure(streamName, streamVersion, source, null, interest, object, (Exception)e);
        Entry<String> entry = this.asEntry(source, metadata, whenFailed);
        this.insertEntry(streamName, streamVersion, entry, whenFailed);
        Dispatchable<Entry<String>, State.TextState> dispatchable = this.buildDispatchable(streamName, streamVersion, Collections.singletonList(entry), null);
        this.insertDispatchable(dispatchable, whenFailed);
        this.doCommit(whenFailed);
        this.dispatch(dispatchable);
        interest.appendResultedIn(Success.of((Object)Result.Success), streamName, streamVersion, source, Optional.empty(), object);
    }

    public <S, ST> void appendWith(String streamName, int streamVersion, Source<S> source, Metadata metadata, ST snapshot, Journal.AppendResultInterest interest, Object object) {
        Consumer<Exception> whenFailed = e -> this.appendResultedInFailure(streamName, streamVersion, source, snapshot, interest, object, (Exception)e);
        Entry<String> entry = this.asEntry(source, metadata, whenFailed);
        this.insertEntry(streamName, streamVersion, entry, whenFailed);
        Tuple2<Optional<ST>, Optional<State.TextState>> snapshotState = this.toState(streamName, snapshot, streamVersion);
        ((Optional)snapshotState._2).ifPresent(state -> this.insertSnapshot(streamName, streamVersion, (State.TextState)state, whenFailed));
        Dispatchable<Entry<String>, State.TextState> dispatchable = this.buildDispatchable(streamName, streamVersion, Collections.singletonList(entry), ((Optional)snapshotState._2).orElse(null));
        this.insertDispatchable(dispatchable, whenFailed);
        this.doCommit(whenFailed);
        this.dispatch(dispatchable);
        interest.appendResultedIn(Success.of((Object)Result.Success), streamName, streamVersion, source, (Optional)snapshotState._1, object);
    }

    public <S, ST> void appendAll(String streamName, int fromStreamVersion, List<Source<S>> sources, Metadata metadata, Journal.AppendResultInterest interest, Object object) {
        Consumer<Exception> whenFailed = e -> this.appendAllResultedInFailure(streamName, fromStreamVersion, sources, null, interest, object, (Exception)e);
        List<Entry<String>> entries = this.asEntries(sources, metadata, whenFailed);
        int version = fromStreamVersion;
        for (Entry<String> entry : entries) {
            this.insertEntry(streamName, version++, entry, whenFailed);
        }
        Dispatchable<Entry<String>, State.TextState> dispatchable = this.buildDispatchable(streamName, fromStreamVersion, entries, null);
        this.insertDispatchable(dispatchable, whenFailed);
        this.doCommit(whenFailed);
        this.dispatch(dispatchable);
        interest.appendAllResultedIn(Success.of((Object)Result.Success), streamName, fromStreamVersion, sources, Optional.empty(), object);
    }

    public <S, ST> void appendAllWith(String streamName, int fromStreamVersion, List<Source<S>> sources, Metadata metadata, ST snapshot, Journal.AppendResultInterest interest, Object object) {
        Consumer<Exception> whenFailed = e -> this.appendAllResultedInFailure(streamName, fromStreamVersion, sources, snapshot, interest, object, (Exception)e);
        List<Entry<String>> entries = this.asEntries(sources, metadata, whenFailed);
        int version = fromStreamVersion;
        for (Entry<String> entry : entries) {
            this.insertEntry(streamName, version++, entry, whenFailed);
        }
        Tuple2<Optional<ST>, Optional<State.TextState>> snapshotState = this.toState(streamName, snapshot, fromStreamVersion);
        ((Optional)snapshotState._2).ifPresent(state -> this.insertSnapshot(streamName, fromStreamVersion, (State.TextState)state, whenFailed));
        Dispatchable<Entry<String>, State.TextState> dispatchable = this.buildDispatchable(streamName, fromStreamVersion, entries, ((Optional)snapshotState._2).orElse(null));
        this.insertDispatchable(dispatchable, whenFailed);
        this.doCommit(whenFailed);
        this.dispatch(dispatchable);
        interest.appendAllResultedIn(Success.of((Object)Result.Success), streamName, fromStreamVersion, sources, (Optional)snapshotState._1, object);
    }

    public Completes<JournalReader<? extends Entry<?>>> journalReader(String name) {
        JournalReader reader = this.journalReaders.computeIfAbsent(name, key -> {
            Address address = this.stage().world().addressFactory().uniquePrefixedWith("eventJournalReader-" + name);
            return (JournalReader)this.stage().actorFor(JournalReader.class, Definition.has(JDBCJournalReaderActor.class, (ActorInstantiator)new JDBCJournalReaderActor.JDBCJournalReaderInstantiator(this.configuration, name)), address);
        });
        return this.completes().with((Object)reader);
    }

    public Completes<StreamReader<String>> streamReader(String name) {
        StreamReader reader = this.streamReaders.computeIfAbsent(name, key -> {
            Address address = this.stage().world().addressFactory().uniquePrefixedWith("eventStreamReader-" + key);
            return (StreamReader)this.stage().actorFor(StreamReader.class, Definition.has(JDBCStreamReaderActor.class, (ActorInstantiator)new JDBCStreamReaderActor.JDBCStreamReaderInstantiator(this.configuration)), address);
        });
        return this.completes().with((Object)reader);
    }

    protected final void insertEntry(String streamName, int streamVersion, Entry<String> entry, Consumer<Exception> whenFailed) {
        try {
            Tuple2<PreparedStatement, Optional<String>> insertEntry = this.queries.prepareInsertEntryQuery(streamName, streamVersion, (String)entry.entryData(), entry.typeName(), entry.typeVersion(), this.gson.toJson((Object)entry.metadata()));
            if (((PreparedStatement)insertEntry._1).executeUpdate() != 1) {
                this.logger().error("vlingo-symbio-jdbc:journal-" + (Object)((Object)this.databaseType) + ": Could not insert event " + entry.toString());
                throw new IllegalStateException("vlingo-symbio-jdbc:journal-" + (Object)((Object)this.databaseType) + ": Could not insert event");
            }
            if (((Optional)insertEntry._2).isPresent()) {
                ((BaseEntry)entry).__internal__setId(String.valueOf(((Optional)insertEntry._2).get()));
            } else {
                long id = this.queries.generatedKeyFrom((PreparedStatement)insertEntry._1);
                if (id > 0L) {
                    ((BaseEntry)entry).__internal__setId(String.valueOf(id));
                }
            }
        }
        catch (SQLException e) {
            whenFailed.accept(e);
            this.logger().error("vlingo-symbio-jdbc:journal-" + (Object)((Object)this.databaseType) + ": Could not insert event " + entry.toString(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    protected final void insertSnapshot(String streamName, int streamVersion, State.TextState snapshotState, Consumer<Exception> whenFailed) {
        try {
            Tuple2<PreparedStatement, Optional<String>> insertSnapshot = this.queries.prepareInsertSnapshotQuery(streamName, streamVersion, (String)snapshotState.data, snapshotState.dataVersion, snapshotState.type, snapshotState.typeVersion, this.gson.toJson((Object)snapshotState.metadata));
            if (((PreparedStatement)insertSnapshot._1).executeUpdate() != 1) {
                this.logger().error("vlingo-symbio-jdbc:journal-" + (Object)((Object)this.databaseType) + ": Could not insert snapshot with id " + snapshotState.id);
                throw new IllegalStateException("vlingo-symbio-jdbc:journal-" + (Object)((Object)this.databaseType) + ": Could not insert snapshot");
            }
        }
        catch (SQLException e) {
            whenFailed.accept(e);
            this.logger().error("vlingo-symbio-jdbc:journal-" + (Object)((Object)this.databaseType) + ": Could not insert event with id " + snapshotState.id, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    protected final void insertDispatchable(Dispatchable<Entry<String>, State.TextState> dispatchable, Consumer<Exception> whenFailed) {
        String dbType = this.configuration.databaseType.toString();
        try {
            Tuple2<PreparedStatement, Optional<String>> insertDispatchable;
            String entries = dispatchable.hasEntries() ? dispatchable.entries().stream().map(Entry::id).collect(Collectors.joining("|")) : "";
            String dispatchableId = dispatchable.id();
            if (dispatchable.state().isPresent()) {
                State state = dispatchable.typedState();
                insertDispatchable = this.queries.prepareInsertDispatchableQuery(dispatchableId, this.configuration.originatorId, state.id, (String)state.data, state.dataVersion, state.type, state.typeVersion, this.gson.toJson((Object)state.metadata), entries);
            } else {
                insertDispatchable = this.queries.prepareInsertDispatchableQuery(dispatchableId, this.configuration.originatorId, null, null, 0, null, 0, null, entries);
            }
            if (((PreparedStatement)insertDispatchable._1).executeUpdate() != 1) {
                this.logger().error("vlingo-symbio-jdbc:journal-" + dbType + ": Could not insert dispatchable with id " + dispatchable.id());
                throw new IllegalStateException("vlingo-symbio-jdbc:journal-" + dbType + ": Could not insert snapshot");
            }
        }
        catch (SQLException e) {
            whenFailed.accept(e);
            this.logger().error("vlingo-symbio-jdbc:journal-" + dbType + ": Could not insert dispatchable with id " + dispatchable.id(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private <S, ST> void appendResultedInFailure(String streamName, int streamVersion, Source<S> source, ST snapshot, Journal.AppendResultInterest interest, Object object, Exception e) {
        interest.appendResultedIn(Failure.of((Throwable)new StorageException(Result.Failure, e.getMessage(), (Throwable)e)), streamName, streamVersion, source, snapshot == null ? Optional.empty() : Optional.of(snapshot), object);
    }

    private <S, ST> void appendAllResultedInFailure(String streamName, int streamVersion, List<Source<S>> sources, ST snapshot, Journal.AppendResultInterest interest, Object object, Exception e) {
        interest.appendAllResultedIn(Failure.of((Throwable)new StorageException(Result.Failure, e.getMessage(), (Throwable)e)), streamName, streamVersion, sources, snapshot == null ? Optional.empty() : Optional.of(snapshot), object);
    }

    private void doCommit(Consumer<Exception> whenFailed) {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            whenFailed.accept(e);
            this.logger().error("vlingo-symbio-jdbc:journal-" + (Object)((Object)this.databaseType) + ": Could not complete transaction", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private <S> List<Entry<String>> asEntries(List<Source<S>> sources, Metadata metadata, Consumer<Exception> whenFailed) {
        ArrayList<Entry<String>> entries = new ArrayList<Entry<String>>(sources.size());
        for (Source<S> source : sources) {
            entries.add(this.asEntry(source, metadata, whenFailed));
        }
        return entries;
    }

    private <S> Entry<String> asEntry(Source<S> source, Metadata metadata, Consumer<Exception> whenFailed) {
        try {
            return this.entryAdapterProvider.asEntry(source, metadata);
        }
        catch (Exception e) {
            whenFailed.accept(e);
            this.logger().error("vlingo-symbio-jdbc:journal-" + (Object)((Object)this.databaseType) + ": Cannot adapt source to entry because: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    private <ST> Tuple2<Optional<ST>, Optional<State.TextState>> toState(String streamName, ST snapshot, int streamVersion) {
        if (snapshot != null) {
            return Tuple2.from(Optional.of(snapshot), Optional.of(this.stateAdapterProvider.asRaw(streamName, snapshot, streamVersion)));
        }
        return Tuple2.from(Optional.empty(), Optional.empty());
    }

    private void dispatch(Dispatchable<Entry<String>, State.TextState> dispatchable) {
        if (this.dispatcher != null) {
            this.dispatcher.dispatch(dispatchable);
        }
    }

    private Dispatchable<Entry<String>, State.TextState> buildDispatchable(String streamName, int streamVersion, List<Entry<String>> entries, State.TextState snapshot) {
        String id = this.getDispatchId(streamName, streamVersion);
        return new Dispatchable(id, LocalDateTime.now(), (State)snapshot, entries);
    }

    private String getDispatchId(String streamName, int streamVersion) {
        return streamName + ":" + streamVersion + ":" + this.dispatchablesIdentityGenerator.generate().toString();
    }
}

