/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.journal.jdbc;

import com.google.gson.Gson;
import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.common.Completes;
import io.vlingo.common.Tuple2;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.store.common.jdbc.Configuration;
import io.vlingo.symbio.store.common.jdbc.DatabaseType;
import io.vlingo.symbio.store.journal.JournalReader;
import io.vlingo.symbio.store.journal.jdbc.JDBCQueries;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class JDBCJournalReaderActor
extends Actor
implements JournalReader<BaseEntry.TextEntry> {
    private final Connection connection;
    private final DatabaseType databaseType;
    private final Gson gson;
    private final String name;
    private final JDBCQueries queries;
    private long offset;

    public JDBCJournalReaderActor(Configuration configuration, String name) throws SQLException {
        this.connection = configuration.connection;
        this.databaseType = configuration.databaseType;
        this.name = name;
        this.queries = JDBCQueries.queriesFor(this.connection);
        this.gson = new Gson();
        this.retrieveCurrentOffset();
    }

    public void close() {
        try {
            this.queries.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Completes<String> name() {
        return this.completes().with((Object)this.name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Completes<BaseEntry.TextEntry> readNext() {
        try (ResultSet resultSet = this.queries.prepareSelectEntryQuery(this.offset).executeQuery();){
            if (!resultSet.next()) return this.completes().with(null);
            Tuple2<BaseEntry.TextEntry, Long> entry = this.entryFromResultSet(resultSet);
            this.offset = (Long)entry._2 + 1L;
            this.updateCurrentOffset();
            Completes completes = this.completes().with(entry._1);
            return completes;
        }
        catch (Exception e) {
            this.logger().error("vlingo-symbio-jdbc:journal-reader-" + (Object)((Object)this.databaseType) + ": " + e.getMessage(), (Throwable)e);
        }
        return this.completes().with(null);
    }

    public Completes<BaseEntry.TextEntry> readNext(String fromId) {
        this.seekTo(fromId);
        return this.readNext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Completes<List<BaseEntry.TextEntry>> readNext(int maximumEvents) {
        ArrayList<Object> events = new ArrayList<Object>(maximumEvents);
        try (ResultSet resultSet = this.queries.prepareSelectEntryBatchQuery(this.offset, maximumEvents).executeQuery();){
            while (resultSet.next()) {
                Tuple2<BaseEntry.TextEntry, Long> entry = this.entryFromResultSet(resultSet);
                this.offset = (Long)entry._2 + 1L;
                events.add(entry._1);
            }
            this.updateCurrentOffset();
            Completes completes = this.completes().with(events);
            return completes;
        }
        catch (Exception e) {
            this.logger().error("vlingo-symbio-jdbc:journal-reader-" + (Object)((Object)this.databaseType) + ": " + e.getMessage(), (Throwable)e);
            return this.completes().with(null);
        }
    }

    public Completes<List<BaseEntry.TextEntry>> readNext(String fromId, int maximumEntries) {
        this.seekTo(fromId);
        return this.readNext(maximumEntries);
    }

    public void rewind() {
        this.offset = 1L;
        this.updateCurrentOffset();
    }

    public Completes<String> seekTo(String id) {
        switch (id) {
            case "<": {
                this.offset = 1L;
                this.updateCurrentOffset();
                break;
            }
            case ">": {
                this.offset = this.retrieveLastOffset() + 1L;
                this.updateCurrentOffset();
                break;
            }
            case "=": {
                break;
            }
            default: {
                this.offset = Integer.parseInt(id);
                this.updateCurrentOffset();
            }
        }
        return this.completes().with((Object)String.valueOf(this.offset));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Completes<Long> size() {
        try (ResultSet resultSet = this.queries.prepareSelectJournalCount().executeQuery();){
            if (!resultSet.next()) return this.completes().with((Object)-1L);
            long count = resultSet.getLong(1);
            this.connection.commit();
            Completes completes = this.completes().with((Object)count);
            return completes;
        }
        catch (Exception e) {
            this.logger().error("vlingo-symbio-jdbc:journal-reader-" + (Object)((Object)this.databaseType) + ": " + e.getMessage(), (Throwable)e);
            this.logger().error("vlingo-symbio-jdbc:journal-reader-" + (Object)((Object)this.databaseType) + ": Rewinding the offset");
        }
        return this.completes().with((Object)-1L);
    }

    private Tuple2<BaseEntry.TextEntry, Long> entryFromResultSet(ResultSet resultSet) throws SQLException, ClassNotFoundException {
        long id = resultSet.getLong(1);
        String entryData = resultSet.getString(2);
        String entryType = resultSet.getString(3);
        int eventTypeVersion = resultSet.getInt(4);
        String entryMetadata = resultSet.getString(5);
        Class<?> classOfEvent = Class.forName(entryType);
        Metadata eventMetadataDeserialized = (Metadata)this.gson.fromJson(entryMetadata, Metadata.class);
        return Tuple2.from((Object)new BaseEntry.TextEntry(String.valueOf(id), classOfEvent, eventTypeVersion, entryData, eventMetadataDeserialized), (Object)id);
    }

    private void retrieveCurrentOffset() {
        this.offset = 1L;
        try (ResultSet resultSet = this.queries.prepareSelectCurrentOffsetQuery(this.name).executeQuery();){
            if (resultSet.next()) {
                this.offset = resultSet.getLong(1);
                this.connection.commit();
            }
        }
        catch (Exception e) {
            this.logger().error("vlingo-symbio-jdbc:journal-reader-" + (Object)((Object)this.databaseType) + ": " + e.getMessage(), (Throwable)e);
            this.logger().error("vlingo-symbio-jdbc:journal-reader-" + (Object)((Object)this.databaseType) + ": Rewinding the offset");
        }
    }

    private void updateCurrentOffset() {
        try {
            this.queries.prepareUpsertOffsetQuery(this.name, this.offset).executeUpdate();
            this.connection.commit();
        }
        catch (Exception e) {
            this.logger().error("vlingo-symbio-jdbc:journal-reader-" + (Object)((Object)this.databaseType) + ": Could not persist the offset. Will retry on next read.");
            this.logger().error("vlingo-symbio-jdbc:journal-reader-" + (Object)((Object)this.databaseType) + ": " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long retrieveLastOffset() {
        try (ResultSet resultSet = this.queries.prepareSelectLastOffsetQuery().executeQuery();){
            if (!resultSet.next()) return this.offset;
            long lastOffset = resultSet.getLong(1);
            this.connection.commit();
            long l = lastOffset;
            return l;
        }
        catch (Exception e) {
            this.logger().error("vlingo-symbio-jdbc:journal-reader-" + (Object)((Object)this.databaseType) + ": Could not retrieve latest offset, using current.");
        }
        return this.offset;
    }

    public static class JDBCJournalReaderInstantiator
    implements ActorInstantiator<JDBCJournalReaderActor> {
        private final Configuration configuration;
        private final String name;

        public JDBCJournalReaderInstantiator(Configuration configuration, String name) {
            this.configuration = configuration;
            this.name = name;
        }

        public JDBCJournalReaderActor instantiate() {
            try {
                return new JDBCJournalReaderActor(this.configuration, this.name);
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("Failed instantiator of " + this.getClass() + " because: " + e.getMessage(), e);
            }
        }

        public Class<JDBCJournalReaderActor> type() {
            return JDBCJournalReaderActor.class;
        }
    }
}

