/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.journal.jdbc;

import io.vlingo.common.Tuple2;
import io.vlingo.symbio.store.common.jdbc.DatabaseType;
import io.vlingo.symbio.store.journal.jdbc.mysql.MySQLQueries;
import io.vlingo.symbio.store.journal.jdbc.postgres.PostgresQueries;
import io.vlingo.symbio.store.journal.jdbc.postgres.yugabyte.YugaByteQueries;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;

public abstract class JDBCQueries {
    protected final Connection connection;
    protected final PreparedStatement deleteDispatchable;
    protected final PreparedStatement insertEntry;
    protected final PreparedStatement insertOffset;
    protected final PreparedStatement insertSnapshot;
    protected final PreparedStatement insertDispatchable;
    protected final PreparedStatement selectCurrentOffset;
    protected final PreparedStatement selectDispatchables;
    protected final PreparedStatement selectLastOffset;
    protected final PreparedStatement selectJournalCount;
    protected final PreparedStatement selectEntry;
    protected final PreparedStatement selectEntryBatch;
    protected final PreparedStatement selectSnapshot;
    protected final PreparedStatement selectStream;
    protected final PreparedStatement updateOffset;
    protected final PreparedStatement upsertOffset;

    public JDBCQueries(Connection connection) throws SQLException {
        this.connection = connection;
        this.deleteDispatchable = connection.prepareStatement(this.deleteDispatchableQuery());
        this.insertEntry = connection.prepareStatement(this.insertEntryQuery(), this.generatedKeysIndicator());
        this.insertOffset = connection.prepareStatement(this.insertOffsetQuery());
        this.insertSnapshot = connection.prepareStatement(this.insertSnapshotQuery());
        this.insertDispatchable = connection.prepareStatement(this.insertDispatchableQuery());
        this.selectCurrentOffset = connection.prepareStatement(this.selectCurrentOffset());
        this.selectDispatchables = connection.prepareStatement(this.selectDispatchablesQuery());
        this.selectEntry = connection.prepareStatement(this.selectEntryQuery());
        this.selectEntryBatch = connection.prepareStatement(this.selectEntryBatchQuery());
        this.selectLastOffset = connection.prepareStatement(this.selectLastOffsetQuery());
        this.selectJournalCount = connection.prepareStatement(this.selectJournalCountQuery());
        this.selectSnapshot = connection.prepareStatement(this.selectSnapshotQuery());
        this.selectStream = connection.prepareStatement(this.selectStreamQuery());
        this.updateOffset = connection.prepareStatement(this.updateOffsetQuery());
        this.upsertOffset = connection.prepareStatement(this.upsertOffsetQuery());
    }

    public static JDBCQueries queriesFor(Connection connection) throws SQLException {
        DatabaseType databaseType = DatabaseType.databaseType(connection);
        switch (databaseType) {
            case Postgres: {
                return new PostgresQueries(connection);
            }
            case YugaByte: {
                return new YugaByteQueries(connection);
            }
            case MySQL: {
                return new MySQLQueries(connection);
            }
        }
        throw new IllegalArgumentException("Database type not supported: " + (Object)((Object)databaseType));
    }

    public void close() throws SQLException {
        this.close(this.deleteDispatchable);
        this.close(this.insertEntry);
        this.close(this.insertOffset);
        this.close(this.insertSnapshot);
        this.close(this.insertDispatchable);
        this.close(this.selectCurrentOffset);
        this.close(this.selectDispatchables);
        this.close(this.selectEntry);
        this.close(this.selectEntryBatch);
        this.close(this.selectLastOffset);
        this.close(this.selectJournalCount);
        this.close(this.selectSnapshot);
        this.close(this.selectStream);
        this.close(this.updateOffset);
        this.close(this.upsertOffset);
        this.connection.close();
    }

    public void createTables() throws SQLException {
        this.connection.createStatement().execute(this.createJournalTableQuery());
        this.connection.commit();
        this.connection.createStatement().execute(this.createOffsetsTable());
        this.connection.commit();
        this.connection.createStatement().execute(this.createSnapshotsTableQuery());
        this.connection.commit();
        this.connection.createStatement().execute(this.createDispatchableTable());
        this.connection.commit();
    }

    public void dropTables() throws SQLException {
        this.connection.prepareStatement(this.dropDispatchablesTableQuery()).execute();
        this.connection.commit();
        this.connection.prepareStatement(this.dropSnapshotsTableQuery()).execute();
        this.connection.commit();
        this.connection.prepareStatement(this.dropOffsetsTable()).execute();
        this.connection.commit();
        this.connection.prepareStatement(this.dropJournalTable()).execute();
        this.connection.commit();
    }

    public PreparedStatement prepareDeleteDispatchableQuery(String dispatchableId) throws SQLException {
        this.deleteDispatchable.clearParameters();
        this.deleteDispatchable.setString(1, dispatchableId);
        return this.deleteDispatchable;
    }

    public long generatedKeyFrom(PreparedStatement insertStatement) throws SQLException {
        try (ResultSet result = insertStatement.getGeneratedKeys();){
            if (result.next()) {
                long l = result.getLong(1);
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    public Tuple2<PreparedStatement, Optional<String>> prepareInsertDispatchableQuery(String d_dispatch_id, String d_originator_id, String d_state_id, String d_state_data, int d_state_data_version, String d_state_type, int d_state_type_version, String d_state_metadata, String d_entries) throws SQLException {
        this.insertDispatchable.clearParameters();
        this.insertDispatchable.setString(1, d_dispatch_id);
        this.insertDispatchable.setString(2, d_originator_id);
        this.insertDispatchable.setLong(3, System.nanoTime());
        this.insertDispatchable.setString(4, d_state_id);
        this.insertDispatchable.setString(5, d_state_data);
        this.insertDispatchable.setInt(6, d_state_data_version);
        this.insertDispatchable.setString(7, d_state_type);
        this.insertDispatchable.setInt(8, d_state_type_version);
        this.insertDispatchable.setString(9, d_state_metadata);
        this.insertDispatchable.setString(10, d_entries);
        return Tuple2.from((Object)this.insertDispatchable, Optional.empty());
    }

    public Tuple2<PreparedStatement, Optional<String>> prepareInsertEntryQuery(String stream_name, int stream_version, String entry_data, String entry_type, int entry_type_version, String entry_metadata) throws SQLException {
        this.insertEntry.clearParameters();
        this.insertEntry.setString(1, stream_name);
        this.insertEntry.setInt(2, stream_version);
        this.insertEntry.setString(3, entry_data);
        this.insertEntry.setString(4, entry_type);
        this.insertEntry.setInt(5, entry_type_version);
        this.insertEntry.setString(6, entry_metadata);
        return Tuple2.from((Object)this.insertEntry, Optional.empty());
    }

    public PreparedStatement prepareInsertOffsetQuery(String readerName, long readerOffset) throws SQLException {
        this.insertOffset.clearParameters();
        this.insertOffset.setString(1, readerName);
        this.insertOffset.setLong(2, readerOffset);
        return this.insertOffset;
    }

    public Tuple2<PreparedStatement, Optional<String>> prepareInsertSnapshotQuery(String stream_name, int stream_version, String e_snapshot_data, int e_snapshot_data_version, String e_snapshot_type, int e_snapshot_type_version, String e_snapshot_metadata) throws SQLException {
        this.insertSnapshot.clearParameters();
        this.insertSnapshot.setString(1, stream_name);
        this.insertSnapshot.setInt(2, stream_version);
        this.insertSnapshot.setString(3, e_snapshot_data);
        this.insertSnapshot.setInt(4, e_snapshot_data_version);
        this.insertSnapshot.setString(5, e_snapshot_type);
        this.insertSnapshot.setInt(6, e_snapshot_type_version);
        this.insertSnapshot.setString(7, e_snapshot_metadata);
        return Tuple2.from((Object)this.insertSnapshot, Optional.empty());
    }

    public PreparedStatement prepareSelectCurrentOffsetQuery(String readerName) throws SQLException {
        this.selectCurrentOffset.clearParameters();
        this.selectCurrentOffset.setString(1, readerName);
        return this.selectCurrentOffset;
    }

    public PreparedStatement prepareSelectDispatchablesQuery(String oringinatorId) throws SQLException {
        this.selectDispatchables.clearParameters();
        this.selectDispatchables.setString(1, oringinatorId);
        return this.selectDispatchables;
    }

    public PreparedStatement prepareSelectEntryQuery(long entryId) throws SQLException {
        this.selectEntry.clearParameters();
        this.selectEntry.setLong(1, entryId);
        return this.selectEntry;
    }

    public PreparedStatement prepareSelectEntryBatchQuery(long entryId, int count) throws SQLException {
        this.selectEntryBatch.clearParameters();
        this.selectEntryBatch.setLong(1, entryId);
        this.selectEntryBatch.setLong(2, entryId + (long)count - 1L);
        return this.selectEntryBatch;
    }

    public PreparedStatement prepareSelectLastOffsetQuery() {
        return this.selectLastOffset;
    }

    public PreparedStatement prepareSelectJournalCount() {
        return this.selectJournalCount;
    }

    public PreparedStatement prepareSelectSnapshotQuery(String streamName) throws SQLException {
        this.selectSnapshot.clearParameters();
        this.selectSnapshot.setString(1, streamName);
        return this.selectSnapshot;
    }

    public PreparedStatement prepareSelectStreamQuery(String streamName, int streamVersion) throws SQLException {
        this.selectStream.clearParameters();
        this.selectStream.setString(1, streamName);
        this.selectStream.setInt(2, streamVersion);
        return this.selectStream;
    }

    public PreparedStatement prepareUpdateOffsetQuery(String readerName, long readerOffset) throws SQLException {
        this.updateOffset.clearParameters();
        this.updateOffset.setLong(1, readerOffset);
        this.updateOffset.setString(2, readerName);
        return this.updateOffset;
    }

    public PreparedStatement prepareUpsertOffsetQuery(String readerName, long readerOffset) throws SQLException {
        this.upsertOffset.clearParameters();
        this.upsertOffset.setString(1, readerName);
        this.upsertOffset.setLong(2, readerOffset);
        this.upsertOffset.setLong(3, readerOffset);
        return this.upsertOffset;
    }

    private void close(PreparedStatement statement) {
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract String createDispatchableTable();

    protected abstract String createJournalTableQuery();

    protected abstract String createOffsetsTable();

    protected abstract String createSnapshotsTableQuery();

    protected abstract String deleteDispatchableQuery();

    protected abstract String dropDispatchablesTableQuery();

    protected abstract String dropJournalTable();

    protected abstract String dropOffsetsTable();

    protected abstract String dropSnapshotsTableQuery();

    protected abstract int generatedKeysIndicator();

    protected abstract String insertDispatchableQuery();

    protected abstract String insertEntryQuery();

    protected abstract String insertOffsetQuery();

    protected abstract String insertSnapshotQuery();

    protected abstract String selectCurrentOffset();

    protected abstract String selectDispatchablesQuery();

    protected abstract String selectEntryQuery();

    protected abstract String selectEntryBatchQuery();

    protected abstract String selectLastOffsetQuery();

    protected abstract String selectJournalCountQuery();

    protected abstract String selectSnapshotQuery();

    protected abstract String selectStreamQuery();

    protected abstract String updateOffsetQuery();

    protected abstract String upsertOffsetQuery();
}

