/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.journal.jdbc;

import com.google.gson.Gson;
import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.common.Completes;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.common.jdbc.Configuration;
import io.vlingo.symbio.store.journal.Stream;
import io.vlingo.symbio.store.journal.StreamReader;
import io.vlingo.symbio.store.journal.jdbc.JDBCQueries;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;

public class JDBCStreamReaderActor
extends Actor
implements StreamReader<String> {
    private final Connection connection;
    private final Gson gson;
    private final JDBCQueries queries;

    public JDBCStreamReaderActor(Configuration configuration) throws SQLException {
        this.connection = configuration.connection;
        this.queries = JDBCQueries.queriesFor(this.connection);
        this.gson = new Gson();
    }

    public Completes<Stream<String>> streamFor(String streamName) {
        return this.streamFor(streamName, 1);
    }

    public Completes<Stream<String>> streamFor(String streamName, int fromStreamVersion) {
        try {
            Stream<String> steamStream = this.eventsFromOffset(streamName, fromStreamVersion);
            this.connection.commit();
            return this.completes().with(steamStream);
        }
        catch (Exception e) {
            this.logger().error("vlingo-symbio-jdbc:journal-stream-reader-postrgres: " + e.getMessage(), (Throwable)e);
            return this.completes().with((Object)new Stream(streamName, 1, Collections.emptyList(), (State)State.TextState.Null));
        }
    }

    public void stop() {
        try {
            this.queries.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.stop();
    }

    private Stream<String> eventsFromOffset(String streamName, int offset) throws Exception {
        State<String> snapshot = this.latestSnapshotOf(streamName);
        ArrayList<BaseEntry.TextEntry> events = new ArrayList<BaseEntry.TextEntry>();
        int dataVersion = offset;
        State<String> referenceSnapshot = State.TextState.Null;
        if (snapshot != State.TextState.Null && snapshot.dataVersion > offset) {
            dataVersion = snapshot.dataVersion;
            referenceSnapshot = snapshot;
        }
        int fullStreamVersion = 0;
        try (ResultSet resultSet = this.queries.prepareSelectStreamQuery(streamName, dataVersion).executeQuery();){
            while (resultSet.next()) {
                int streamVersion;
                String id = resultSet.getString(1);
                fullStreamVersion = streamVersion = resultSet.getInt(2);
                String entryData = resultSet.getString(3);
                String entryType = resultSet.getString(4);
                int eventTypeVersion = resultSet.getInt(5);
                String entryMetadata = resultSet.getString(6);
                Class<?> classOfEvent = Class.forName(entryType);
                Metadata eventMetadataDeserialized = (Metadata)this.gson.fromJson(entryMetadata, Metadata.class);
                events.add(new BaseEntry.TextEntry(id, classOfEvent, eventTypeVersion, entryData, eventMetadataDeserialized));
            }
        }
        return new Stream(streamName, fullStreamVersion, events, referenceSnapshot);
    }

    private State<String> latestSnapshotOf(String streamName) throws Exception {
        try (ResultSet resultSet = this.queries.prepareSelectSnapshotQuery(streamName).executeQuery();){
            if (resultSet.next()) {
                String snapshotData = resultSet.getString(1);
                int snapshotDataVersion = resultSet.getInt(2);
                String snapshotDataType = resultSet.getString(3);
                int snapshotDataTypeVersion = resultSet.getInt(4);
                String metadataJson = resultSet.getString(5);
                Class<?> snapshotDataTypeClass = Class.forName(snapshotDataType);
                Metadata eventMetadataDeserialized = (Metadata)this.gson.fromJson(metadataJson, Metadata.class);
                State.TextState textState = new State.TextState(streamName, snapshotDataTypeClass, snapshotDataTypeVersion, snapshotData, snapshotDataVersion, eventMetadataDeserialized);
                return textState;
            }
            State.TextState textState = State.TextState.Null;
            return textState;
        }
    }

    public static class JDBCStreamReaderInstantiator
    implements ActorInstantiator<JDBCStreamReaderActor> {
        private final Configuration configuration;

        public JDBCStreamReaderInstantiator(Configuration configuration) {
            this.configuration = configuration;
        }

        public JDBCStreamReaderActor instantiate() {
            try {
                return new JDBCStreamReaderActor(this.configuration);
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("Failed instantiator of " + this.getClass() + " because: " + e.getMessage(), e);
            }
        }

        public Class<JDBCStreamReaderActor> type() {
            return JDBCStreamReaderActor.class;
        }
    }
}

