/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.journal.jdbc.mysql;

import io.vlingo.symbio.store.journal.jdbc.JDBCQueries;
import java.sql.Connection;
import java.sql.SQLException;

public class MySQLQueries
extends JDBCQueries {
    public static final String TABLE_VLINGO_SYMBIO_JOURNAL_DISPATCHABLES = "vlingo_symbio_journal_dispatchables";
    public static final String TABLE_VLINGO_SYMBIO_JOURNAL = "vlingo_symbio_journal";
    public static final String TABLE_VLINGO_SYMBIO_JOURNAL_OFFSETS = "vlingo_symbio_journal_offsets";
    public static final String TABLE_VLINGO_SYMBIO_JOURNAL_SNAPSHOTS = "vlingo_symbio_journal_snapshots";
    private static final String CREATE_DISPATCHABLE_TABLE = "CREATE TABLE IF NOT EXISTS vlingo_symbio_journal_dispatchables (\n   D_DISPATCH_ID VARCHAR(512) PRIMARY KEY,\n   D_ORIGINATOR_ID VARCHAR(512) NOT NULL,   D_CREATED_ON BIGINT NOT NULL,   D_STATE_ID VARCHAR(512) NULL, \n   D_STATE_DATA TEXT NULL,\n   D_STATE_DATA_VERSION INT NULL,\n   D_STATE_TYPE VARCHAR(512) NULL,\n   D_STATE_TYPE_VERSION INTEGER NULL,\n   D_STATE_METADATA TEXT NULL,\n   D_ENTRIES TEXT NOT NULL\n);";
    private static final String CREATE_JOURNAL_TABLE = "CREATE TABLE IF NOT EXISTS vlingo_symbio_journal (\nE_ID SERIAL PRIMARY KEY, \nE_STREAM_NAME VARCHAR(512) NOT NULL, \nE_STREAM_VERSION INTEGER NOT NULL, \nE_ENTRY_DATA TEXT NOT NULL, \nE_ENTRY_TYPE VARCHAR(512) NOT NULL, \nE_ENTRY_TYPE_VERSION INTEGER NOT NULL, \nE_ENTRY_METADATA TEXT NOT NULL \n)";
    private static final String CREATE_OFFSETS_TABLE = "CREATE TABLE IF NOT EXISTS vlingo_symbio_journal_offsets(O_READER_NAME VARCHAR(128) PRIMARY KEY,O_READER_OFFSET BIGINT NOT NULL)";
    private static final String CREATE_SNAPSHOTS_TABLE = "CREATE TABLE IF NOT EXISTS vlingo_symbio_journal_snapshots (\nS_STREAM_NAME VARCHAR(512) NOT NULL, \nS_STREAM_VERSION INTEGER NOT NULL, \nS_SNAPSHOT_DATA TEXT NOT NULL, \nS_SNAPSHOT_DATA_VERSION INTEGER NOT NULL, \nS_SNAPSHOT_TYPE VARCHAR(512) NOT NULL, \nS_SNAPSHOT_TYPE_VERSION INTEGER NOT NULL, \nS_SNAPSHOT_METADATA TEXT NOT NULL, \n\nPRIMARY KEY (S_STREAM_NAME, S_STREAM_VERSION) \n)";
    private static final String DELETE_DISPATCHABLE = "DELETE FROM vlingo_symbio_journal_dispatchables WHERE D_DISPATCH_ID = ?";
    private static final String DROP_DISPATCHABLES_TABLE = "DROP TABLE IF EXISTS vlingo_symbio_journal_dispatchables";
    private static final String DROP_JOURNAL_TABLE = "DROP TABLE IF EXISTS vlingo_symbio_journal";
    private static final String DROP_OFFSETS_TABLE = "DROP TABLE IF EXISTS vlingo_symbio_journal_offsets";
    private static final String DROP_SNAPSHOTS_TABLE = "DROP TABLE IF EXISTS vlingo_symbio_journal_snapshots";
    private static final String INSERT_DISPATCHABLE = "INSERT INTO vlingo_symbio_journal_dispatchables \n(D_DISPATCH_ID, D_ORIGINATOR_ID, D_CREATED_ON, \n D_STATE_ID, D_STATE_DATA, D_STATE_DATA_VERSION, \n D_STATE_TYPE, D_STATE_TYPE_VERSION, \n D_STATE_METADATA, D_ENTRIES) \nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_ENTRY = "INSERT INTO vlingo_symbio_journal \n(E_STREAM_NAME, E_STREAM_VERSION, E_ENTRY_DATA, \n E_ENTRY_TYPE, E_ENTRY_TYPE_VERSION, E_ENTRY_METADATA) \nVALUES(?, ?, ?, ?, ?, ?)";
    private static final String INSERT_OFFSET = "INSERT INTO vlingo_symbio_journal_offsets (O_READER_NAME, O_READER_OFFSET) VALUES(?, ?)";
    private static final String UPDATE_OFFSET = "UPDATE  vlingo_symbio_journal_offsets SET O_READER_OFFSET = ? WHERE O_READER_NAME = ?";
    private static final String UPSERT_OFFSET = "INSERT INTO vlingo_symbio_journal_offsets(O_READER_NAME, O_READER_OFFSET) VALUES(?, ?) ON DUPLICATE KEY UPDATE O_READER_OFFSET = ?";
    private static final String INSERT_SNAPSHOT = "INSERT INTO vlingo_symbio_journal_snapshots\n(S_STREAM_NAME, S_STREAM_VERSION, \n S_SNAPSHOT_DATA, S_SNAPSHOT_DATA_VERSION, \n S_SNAPSHOT_TYPE, S_SNAPSHOT_TYPE_VERSION, \n S_SNAPSHOT_METADATA) \nVALUES(?, ?, ?, ?, ?, ?, ?)";
    private static final String SELECT_CURRENT_OFFSET = "SELECT O_READER_OFFSET FROM vlingo_symbio_journal_offsets WHERE O_READER_NAME=?";
    private static final String SELECT_DISPATCHABLES = "SELECT D_DISPATCH_ID, D_CREATED_ON, \n D_STATE_ID, D_STATE_DATA, D_STATE_DATA_VERSION, \n D_STATE_TYPE, D_STATE_TYPE_VERSION, \n D_STATE_METADATA, D_ENTRIES \n FROM vlingo_symbio_journal_dispatchables\n WHERE D_ORIGINATOR_ID = ? ORDER BY D_CREATED_ON";
    private static final String SELECT_ENTRY = "SELECT E_ID, E_ENTRY_DATA, E_ENTRY_TYPE, E_ENTRY_TYPE_VERSION, E_ENTRY_METADATA FROM vlingo_symbio_journal WHERE E_ID = ?";
    private static final String SELECT_ENTRY_BATCH = "SELECT E_ID, E_ENTRY_DATA, E_ENTRY_TYPE, E_ENTRY_TYPE_VERSION, E_ENTRY_METADATA FROM vlingo_symbio_journal WHERE E_ID BETWEEN ? AND ? ORDER BY E_ID";
    private static final String SELECT_LAST_OFFSET = "SELECT MAX(E_ID) FROM vlingo_symbio_journal";
    private static final String SELECT_JOURNAL_COUNT = "SELECT COUNT(*) FROM vlingo_symbio_journal";
    private static final String SELECT_SNAPSHOT = "SELECT S_SNAPSHOT_DATA, S_SNAPSHOT_DATA_VERSION, S_SNAPSHOT_TYPE, S_SNAPSHOT_TYPE_VERSION, S_SNAPSHOT_METADATA FROM vlingo_symbio_journal_snapshots WHERE S_STREAM_NAME = ?";
    private static final String SELECT_STREAM = "SELECT E_ID, E_STREAM_VERSION, E_ENTRY_DATA, E_ENTRY_TYPE, E_ENTRY_TYPE_VERSION, E_ENTRY_METADATA FROM vlingo_symbio_journal WHERE E_STREAM_NAME = ? AND E_STREAM_VERSION >= ? ORDER BY E_STREAM_VERSION";

    public MySQLQueries(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    protected String createDispatchableTable() {
        return CREATE_DISPATCHABLE_TABLE;
    }

    @Override
    protected String createJournalTableQuery() {
        return CREATE_JOURNAL_TABLE;
    }

    @Override
    protected String createOffsetsTable() {
        return CREATE_OFFSETS_TABLE;
    }

    @Override
    protected String createSnapshotsTableQuery() {
        return CREATE_SNAPSHOTS_TABLE;
    }

    @Override
    protected String deleteDispatchableQuery() {
        return DELETE_DISPATCHABLE;
    }

    @Override
    protected String dropDispatchablesTableQuery() {
        return DROP_DISPATCHABLES_TABLE;
    }

    @Override
    protected String dropJournalTable() {
        return DROP_JOURNAL_TABLE;
    }

    @Override
    protected String dropOffsetsTable() {
        return DROP_OFFSETS_TABLE;
    }

    @Override
    protected String dropSnapshotsTableQuery() {
        return DROP_SNAPSHOTS_TABLE;
    }

    @Override
    protected int generatedKeysIndicator() {
        return 1;
    }

    @Override
    protected String insertDispatchableQuery() {
        return INSERT_DISPATCHABLE;
    }

    @Override
    protected String insertEntryQuery() {
        return INSERT_ENTRY;
    }

    @Override
    protected String insertOffsetQuery() {
        return INSERT_OFFSET;
    }

    @Override
    protected String insertSnapshotQuery() {
        return INSERT_SNAPSHOT;
    }

    @Override
    protected String selectCurrentOffset() {
        return SELECT_CURRENT_OFFSET;
    }

    @Override
    protected String selectDispatchablesQuery() {
        return SELECT_DISPATCHABLES;
    }

    @Override
    protected String selectEntryQuery() {
        return SELECT_ENTRY;
    }

    @Override
    protected String selectEntryBatchQuery() {
        return SELECT_ENTRY_BATCH;
    }

    @Override
    protected String selectLastOffsetQuery() {
        return SELECT_LAST_OFFSET;
    }

    @Override
    protected String selectJournalCountQuery() {
        return SELECT_JOURNAL_COUNT;
    }

    @Override
    protected String selectSnapshotQuery() {
        return SELECT_SNAPSHOT;
    }

    @Override
    protected String selectStreamQuery() {
        return SELECT_STREAM;
    }

    @Override
    protected String updateOffsetQuery() {
        return UPDATE_OFFSET;
    }

    @Override
    protected String upsertOffsetQuery() {
        return UPSERT_OFFSET;
    }
}

