/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.journal.jdbc.postgres.yugabyte;

import io.vlingo.common.Tuple2;
import io.vlingo.common.identity.IdentityGenerator;
import io.vlingo.symbio.store.journal.jdbc.postgres.PostgresQueries;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;

public class YugaByteQueries
extends PostgresQueries {
    private static final String INSERT_ENTRY = "INSERT INTO vlingo_symbio_journal (e_id, e_timestamp, e_stream_name, e_stream_version, e_entry_data, e_entry_type, e_entry_type_version, e_entry_metadata) VALUES(?, ?, ?, ?, ?, ?, ?, ?)";
    private final IdentityGenerator identityGenerator = new IdentityGenerator.TimeBasedIdentityGenerator();

    public YugaByteQueries(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public Tuple2<PreparedStatement, Optional<String>> prepareInsertEntryQuery(String stream_name, int stream_version, String entry_data, String entry_type, int entry_type_version, String entry_metadata) throws SQLException {
        this.insertEntry.clearParameters();
        UUID e_id = this.identityGenerator.generate();
        long e_timestamp = e_id.timestamp();
        this.insertEntry.setObject(1, e_id);
        this.insertEntry.setLong(2, e_timestamp);
        this.insertEntry.setString(3, stream_name);
        this.insertEntry.setInt(4, stream_version);
        this.insertEntry.setString(5, entry_data);
        this.insertEntry.setString(6, entry_type);
        this.insertEntry.setInt(7, entry_type_version);
        this.insertEntry.setString(8, entry_metadata);
        return Tuple2.from((Object)this.insertEntry, Optional.of(e_id.toString()));
    }

    @Override
    protected int generatedKeysIndicator() {
        return 2;
    }

    @Override
    protected String insertEntryQuery() {
        return INSERT_ENTRY;
    }
}

