/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Address;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Logger;
import io.vlingo.actors.World;
import io.vlingo.common.Completes;
import io.vlingo.common.Failure;
import io.vlingo.common.Scheduled;
import io.vlingo.common.Success;
import io.vlingo.common.identity.IdentityGenerator;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.EntryAdapterProvider;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.EntryReader;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.common.jdbc.Configuration;
import io.vlingo.symbio.store.common.jdbc.DatabaseType;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.dispatch.DispatcherControl;
import io.vlingo.symbio.store.dispatch.control.DispatcherControlActor;
import io.vlingo.symbio.store.object.ObjectStore;
import io.vlingo.symbio.store.object.ObjectStoreEntryReader;
import io.vlingo.symbio.store.object.ObjectStoreReader;
import io.vlingo.symbio.store.object.ObjectStoreWriter;
import io.vlingo.symbio.store.object.QueryExpression;
import io.vlingo.symbio.store.object.StateObject;
import io.vlingo.symbio.store.object.StateSources;
import io.vlingo.symbio.store.object.jdbc.JDBCObjectStoreDelegate;
import io.vlingo.symbio.store.object.jdbc.JDBCObjectStoreEntryReaderActor;
import io.vlingo.symbio.store.object.jdbc.jdbi.JdbiObjectStoreEntryReaderActor;
import io.vlingo.symbio.store.object.jdbc.jdbi.JdbiOnDatabase;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JDBCObjectStoreActor
extends Actor
implements ObjectStore,
Scheduled<Object> {
    private final DispatcherControl dispatcherControl;
    private boolean closed;
    private final JDBCObjectStoreDelegate delegate;
    private final Dispatcher<Dispatchable<Entry<?>, State<?>>> dispatcher;
    private final Map<String, ObjectStoreEntryReader<?>> entryReaders;
    private final Logger logger;
    private final EntryAdapterProvider entryAdapterProvider;
    private final IdentityGenerator identityGenerator;

    public JDBCObjectStoreActor(JDBCObjectStoreDelegate delegate, Dispatcher<Dispatchable<Entry<?>, State<?>>> dispatcher) {
        this(delegate, dispatcher, 1000L, 1000L);
    }

    public JDBCObjectStoreActor(JDBCObjectStoreDelegate delegate, Dispatcher<Dispatchable<Entry<?>, State<?>>> dispatcher, long checkConfirmationExpirationInterval, long confirmationExpiration) {
        this.delegate = delegate;
        this.dispatcher = dispatcher;
        this.closed = false;
        this.logger = this.stage().world().defaultLogger();
        this.entryAdapterProvider = EntryAdapterProvider.instance((World)this.stage().world());
        this.identityGenerator = new IdentityGenerator.RandomIdentityGenerator();
        this.entryReaders = new HashMap();
        long timeout = delegate.configuration.transactionTimeoutMillis;
        this.stage().scheduler().schedule((Scheduled)this.selfAs(Scheduled.class), null, timeout, timeout);
        this.dispatcherControl = (DispatcherControl)this.stage().actorFor(DispatcherControl.class, Definition.has(DispatcherControlActor.class, (ActorInstantiator)new DispatcherControl.DispatcherControlInstantiator(dispatcher, (DispatcherControl.DispatcherControlDelegate)delegate.copy(), checkConfirmationExpirationInterval, confirmationExpiration)));
    }

    public void close() {
        if (!this.closed) {
            this.delegate.close();
            if (this.dispatcherControl != null) {
                this.dispatcherControl.stop();
            }
            this.closed = true;
        }
    }

    public Completes<EntryReader<? extends Entry<?>>> entryReader(String name) {
        ObjectStoreEntryReader entryReader = this.entryReaders.get(name);
        if (entryReader == null) {
            Class actorType;
            Configuration clonedConfiguration = Configuration.cloneOf(this.delegate.configuration);
            Address address = this.stage().world().addressFactory().uniquePrefixedWith("objectStoreEntryReader-" + name);
            Object instantiator = null;
            switch (this.delegate.type()) {
                case Jdbi: {
                    actorType = JdbiObjectStoreEntryReaderActor.class;
                    instantiator = new JdbiObjectStoreEntryReaderActor.JdbiObjectStoreEntryReaderInstantiator(JdbiOnDatabase.openUsing(clonedConfiguration), this.delegate.registeredMappers(), name);
                    break;
                }
                case JDBC: 
                case JPA: {
                    actorType = JDBCObjectStoreEntryReaderActor.class;
                    instantiator = new JDBCObjectStoreEntryReaderActor.JDBCObjectStoreEntryReaderInstantiator(DatabaseType.databaseType(clonedConfiguration.connection), clonedConfiguration.connection, name);
                    break;
                }
                default: {
                    throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + ": Cannot create entry reader '" + name + "' due to unknown type: " + (Object)((Object)this.delegate.type()));
                }
            }
            entryReader = (ObjectStoreEntryReader)this.stage().actorFor(ObjectStoreEntryReader.class, Definition.has(actorType, (ActorInstantiator)instantiator), address);
        }
        return this.completes().with(entryReader);
    }

    public <T extends StateObject, E> void persist(StateSources<T, E> stateSources, Metadata metadata, long updateId, ObjectStoreWriter.PersistResultInterest interest, Object object) {
        List sources = stateSources.sources();
        StateObject persistentObject = stateSources.stateObject();
        try {
            this.delegate.beginTransaction();
            State state = this.delegate.persist(persistentObject, updateId, metadata);
            int entryVersion = (int)stateSources.stateObject().version();
            List entries = this.entryAdapterProvider.asEntries(sources, entryVersion, metadata);
            this.delegate.persistEntries(entries);
            Dispatchable<Entry<?>, State<?>> dispatchable = this.buildDispatchable(state, entries);
            this.delegate.persistDispatchable(dispatchable);
            this.delegate.completeTransaction();
            this.dispatcher.dispatch(dispatchable);
            interest.persistResultedIn(Success.of((Object)Result.Success), (Object)persistentObject, 1, 1, object);
        }
        catch (StorageException e) {
            this.logger.error("Persist of: " + persistentObject + " failed because: " + e.getMessage(), (Throwable)e);
            this.delegate.failTransaction();
            interest.persistResultedIn(Failure.of((Throwable)e), (Object)persistentObject, 1, 0, object);
        }
        catch (Exception e) {
            this.logger.error("Persist of: " + persistentObject + " failed because: " + e.getMessage(), (Throwable)e);
            this.delegate.failTransaction();
            interest.persistResultedIn(Failure.of((Throwable)new StorageException(Result.Failure, e.getMessage(), (Throwable)e)), (Object)persistentObject, 1, 0, object);
        }
    }

    public <T extends StateObject, E> void persistAll(Collection<StateSources<T, E>> allStateSources, Metadata metadata, long updateId, ObjectStoreWriter.PersistResultInterest interest, Object object) {
        ArrayList<StateObject> allPersistentObjects = new ArrayList<StateObject>();
        ArrayList allDispatchables = new ArrayList();
        try {
            this.delegate.beginTransaction();
            for (StateSources<T, E> stateSources : allStateSources) {
                StateObject persistentObject = stateSources.stateObject();
                List sources = stateSources.sources();
                int entryVersion = (int)stateSources.stateObject().version();
                List entries = this.entryAdapterProvider.asEntries(sources, entryVersion, metadata);
                this.delegate.persistEntries(entries);
                State state = this.delegate.persist(persistentObject, updateId, metadata);
                allPersistentObjects.add(persistentObject);
                Dispatchable<Entry<?>, State<?>> dispatchable = this.buildDispatchable(state, entries);
                this.delegate.persistDispatchable(dispatchable);
                allDispatchables.add(dispatchable);
            }
            this.delegate.completeTransaction();
            allDispatchables.forEach(arg_0 -> this.dispatcher.dispatch(arg_0));
            interest.persistResultedIn(Success.of((Object)Result.Success), allPersistentObjects, allPersistentObjects.size(), allPersistentObjects.size(), object);
        }
        catch (StorageException e) {
            this.logger.error("Persist all of: " + allPersistentObjects + " failed because: " + e.getMessage(), (Throwable)e);
            this.delegate.failTransaction();
            interest.persistResultedIn(Failure.of((Throwable)e), allPersistentObjects, allPersistentObjects.size(), 0, object);
        }
        catch (Exception e) {
            this.logger.error("Persist all of: " + allPersistentObjects + " failed because: " + e.getMessage(), (Throwable)e);
            this.delegate.failTransaction();
            interest.persistResultedIn(Failure.of((Throwable)new StorageException(Result.Failure, e.getMessage(), (Throwable)e)), allPersistentObjects, allPersistentObjects.size(), 0, object);
        }
    }

    public void queryAll(QueryExpression expression, ObjectStoreReader.QueryResultInterest interest, Object object) {
        try {
            ObjectStoreReader.QueryMultiResults results = this.delegate.queryAll(expression);
            interest.queryAllResultedIn(Success.of((Object)Result.Success), results, object);
        }
        catch (StorageException e) {
            this.logger.error("Query all failed because: " + e.getMessage(), (Throwable)e);
            interest.queryAllResultedIn(Failure.of((Throwable)e), ObjectStoreReader.QueryMultiResults.of(null), object);
        }
    }

    public void queryObject(QueryExpression expression, ObjectStoreReader.QueryResultInterest interest, Object object) {
        try {
            ObjectStoreReader.QuerySingleResult result = this.delegate.queryObject(expression);
            if (result.stateObject != null) {
                interest.queryObjectResultedIn(Success.of((Object)Result.Success), result, object);
            } else {
                interest.queryObjectResultedIn(Failure.of((Throwable)new StorageException(Result.NotFound, "No object identified by expression: " + expression)), result, object);
            }
        }
        catch (StorageException e) {
            this.logger.error("Query all failed because: " + e.getMessage(), (Throwable)e);
            interest.queryObjectResultedIn(Failure.of((Throwable)e), ObjectStoreReader.QuerySingleResult.of(null), object);
        }
    }

    public void intervalSignal(Scheduled<Object> scheduled, Object data) {
        this.delegate.timeoutCheck();
    }

    public void stop() {
        this.close();
        super.stop();
    }

    private Dispatchable<Entry<?>, State<?>> buildDispatchable(State<?> state, List<Entry<?>> entries) {
        String id = this.identityGenerator.generate().toString();
        return new Dispatchable(id, LocalDateTime.now(), state, entries);
    }
}

