/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc;

import io.vlingo.symbio.store.common.jdbc.DatabaseType;
import io.vlingo.symbio.store.object.jdbc.HSQLDBObjectStoreEntryJournalQueries;
import io.vlingo.symbio.store.object.jdbc.MySQLObjectStoreEntryJournalQueries;
import io.vlingo.symbio.store.object.jdbc.PostgresObjectStoreEntryJournalQueries;
import io.vlingo.symbio.store.object.jdbc.YugaByteObjectStoreEntryJournalQueries;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;

public abstract class JDBCObjectStoreEntryJournalQueries {
    public static final String DispatchablesTableName = "tbl_vlingo_objectstore_dispatchables";
    public static final String EntryJournalTableName = "tbl_vlingo_objectstore_entry_journal";
    public static final String EntryReaderOffsetsTableName = "tbl_vlingo_objectstore_entryreader_offsets";
    public static final String ENTRY_DATATYPE_LONGVARCHAR = "LONGVARCHAR(65535)";
    public static final String ENTRY_DATATYPE_TEXT = "TEXT";
    private static final String QueryLastEntryId = "SELECT MAX(E_ID) FROM ";
    private static final String QuerySize = "SELECT COUNT(*) FROM ";
    private static final int CreatedOn = 0;
    private static final int OriginatorId = 1;
    private static final int Id = 2;
    private static final int StateId = 3;
    private static final int StateType = 4;
    private static final int StateTypeVersion = 5;
    private static final int StateData = 6;
    private static final int StateDataVersion = 7;
    private static final int StateMetadata = 8;
    private static final int Entries = 9;
    private static final int EntryType = 0;
    private static final int EntryTypeVersion = 1;
    private static final int EntryEntryData = 2;
    private static final int EntryMetadataValue = 3;
    private static final int EntryMetadataOperation = 4;
    public final Connection connection;

    public static JDBCObjectStoreEntryJournalQueries using(DatabaseType databaseType, Connection connection) {
        switch (databaseType) {
            case HSQLDB: {
                return new HSQLDBObjectStoreEntryJournalQueries(connection);
            }
            case MySQL: 
            case MariaDB: {
                return new MySQLObjectStoreEntryJournalQueries(connection);
            }
            case SQLServer: {
                break;
            }
            case Vitess: {
                break;
            }
            case Oracle: {
                break;
            }
            case Postgres: {
                return new PostgresObjectStoreEntryJournalQueries(connection);
            }
            case YugaByte: {
                return new YugaByteObjectStoreEntryJournalQueries(connection);
            }
        }
        throw new IllegalArgumentException("Database currently not supported: " + databaseType.name());
    }

    public JDBCObjectStoreEntryJournalQueries(Connection connection) {
        this.connection = connection;
    }

    public String entryQuery() {
        return MessageFormat.format("SELECT E_ID,E_TYPE,E_TYPE_VERSION,E_DATA,E_METADATA_VALUE,E_METADATA_OP FROM {0} WHERE E_ID >= ? ORDER BY E_ID LIMIT 1", EntryJournalTableName);
    }

    public String entryQuery(long id) {
        return MessageFormat.format("SELECT E_ID,E_TYPE,E_TYPE_VERSION,E_DATA,E_METADATA_VALUE,E_METADATA_OP FROM {0} WHERE E_ID >= {1} ORDER BY E_ID LIMIT 1", EntryJournalTableName, id);
    }

    public String entriesQuery(String[] placeholders) {
        return MessageFormat.format("SELECT E_ID,E_TYPE,E_TYPE_VERSION,E_DATA,E_METADATA_VALUE,E_METADATA_OP FROM {0} WHERE E_ID BETWEEN {1} AND {2} ORDER BY E_ID", EntryJournalTableName, placeholders[0], placeholders[1]);
    }

    public String entriesQuery(long id, int count) {
        return MessageFormat.format("SELECT E_ID,E_TYPE,E_TYPE_VERSION,E_DATA,E_METADATA_VALUE,E_METADATA_OP FROM {0} WHERE E_ID BETWEEN {1} AND {2} ORDER BY E_ID", EntryJournalTableName, id, id + (long)count - 1L);
    }

    public String deleteDispatchableQuery(String idPlaceholder) {
        return MessageFormat.format("DELETE FROM {0} WHERE D_DISPATCH_ID = {1}", DispatchablesTableName, idPlaceholder);
    }

    public String insertDispatchableQuery(String[] placeholders) {
        return MessageFormat.format("INSERT INTO tbl_vlingo_objectstore_dispatchables (D_CREATED_AT, D_ORIGINATOR_ID, D_DISPATCH_ID, D_STATE_ID, D_STATE_TYPE,  D_STATE_TYPE_VERSION, D_STATE_DATA, D_STATE_DATA_VERSION, D_STATE_METADATA, D_ENTRIES)  VALUES ( {0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9})", placeholders[0], placeholders[1], placeholders[2], placeholders[3], placeholders[4], placeholders[5], placeholders[6], placeholders[7], placeholders[8], placeholders[9]);
    }

    public String insertEntriesQuery(String[] placeholders) {
        return MessageFormat.format("INSERT INTO tbl_vlingo_objectstore_entry_journal(E_TYPE, E_TYPE_VERSION, E_DATA, E_METADATA_VALUE, E_METADATA_OP) VALUES ({0}, {1}, {2}, {3}, {4})", placeholders[0], placeholders[1], placeholders[2], placeholders[3], placeholders[4]);
    }

    public String lastEntryIdQuery() {
        return "SELECT MAX(E_ID) FROM tbl_vlingo_objectstore_entry_journal";
    }

    public String sizeQuery() {
        return "SELECT COUNT(*) FROM tbl_vlingo_objectstore_entry_journal";
    }

    public String unconfirmedDispatchablesQuery(String originatorId) {
        return MessageFormat.format("SELECT * FROM {0} WHERE D_ORIGINATOR_ID = ''{1}'' ORDER BY D_CREATED_AT ASC", DispatchablesTableName, originatorId);
    }

    public abstract String upsertCurrentEntryOffsetQuery(String[] var1);

    public abstract String wideTextDataType();

    public Connection connection() {
        return this.connection;
    }

    public void createCommonTables() throws SQLException {
        this.createTextEntryJournalTable();
        this.createDispatchableTable();
        this.createTextEntryJournalReaderOffsetsTable();
    }

    public void createDispatchableTable() throws SQLException {
        String wideTextDataType = this.wideTextDataType();
        this.connection.createStatement().execute("CREATE TABLE IF NOT EXISTS tbl_vlingo_objectstore_dispatchables (\n   D_ID BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,   D_CREATED_AT TIMESTAMP NOT NULL,   D_ORIGINATOR_ID VARCHAR(32) NOT NULL,   D_DISPATCH_ID VARCHAR(128) NULL,\n   D_STATE_ID VARCHAR(128) NULL, \n   D_STATE_TYPE VARCHAR(256) NULL,\n   D_STATE_TYPE_VERSION INT NULL,\n   D_STATE_DATA " + wideTextDataType + " NULL,\n   D_STATE_DATA_VERSION INT NULL,\n   D_STATE_METADATA " + wideTextDataType + " NULL,\n   D_ENTRIES " + wideTextDataType + " NULL \n)");
        this.connection.createStatement().execute("CREATE INDEX IF NOT EXISTS IDX_DISPATCHABLES_DISPATCH_ID \nON tbl_vlingo_objectstore_dispatchables (D_DISPATCH_ID);");
        this.connection.createStatement().execute("CREATE INDEX IF NOT EXISTS IDX_DISPATCHABLES_ORIGINATOR_ID \nON tbl_vlingo_objectstore_dispatchables (D_ORIGINATOR_ID);");
    }

    public void createTextEntryJournalTable() throws SQLException {
        this.connection.createStatement().execute("CREATE TABLE IF NOT EXISTS tbl_vlingo_objectstore_entry_journal (E_ID BIGINT GENERATED ALWAYS AS IDENTITY(START WITH 1 INCREMENT BY 1) PRIMARY KEY, E_TYPE VARCHAR(1024), E_TYPE_VERSION INTEGER, E_DATA VARCHAR(8000), E_METADATA_VALUE VARCHAR(8000) NULL, E_METADATA_OP VARCHAR(128) NULL)");
    }

    public void createTextEntryJournalReaderOffsetsTable() throws SQLException {
        this.connection.createStatement().execute("CREATE TABLE IF NOT EXISTS tbl_vlingo_objectstore_entryreader_offsets (O_READER_NAME VARCHAR(1024) PRIMARY KEY, O_READER_OFFSET BIGINT NOT NULL)");
    }

    public PreparedStatement statementForQueryLastEntryId() throws SQLException {
        return this.connection.prepareStatement(this.lastEntryIdQuery());
    }

    public PreparedStatement statementForSizeQuery() throws SQLException {
        return this.connection.prepareStatement(this.sizeQuery());
    }

    public PreparedStatement statementForEntryQuery() throws SQLException {
        return this.connection.prepareStatement(this.entryQuery());
    }

    public PreparedStatement statementForEntryQuery(long id) throws SQLException {
        return this.connection.prepareStatement(this.entryQuery(id));
    }

    public PreparedStatement statementForEntriesQuery(String[] placeholders) throws SQLException {
        return this.connection.prepareStatement(this.entriesQuery(placeholders));
    }

    public PreparedStatement statementForEntriesQuery(long id, int count) throws SQLException {
        return this.connection.prepareStatement(this.entriesQuery(id, count));
    }

    public PreparedStatement statementForUpsertCurrentEntryOffsetQuery(String[] placeholders) throws SQLException {
        return this.connection.prepareStatement(this.upsertCurrentEntryOffsetQuery(placeholders));
    }
}

