/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.common.Completes;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.store.common.jdbc.DatabaseType;
import io.vlingo.symbio.store.object.ObjectStoreEntryReader;
import io.vlingo.symbio.store.object.jdbc.JDBCObjectStoreEntryJournalQueries;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class JDBCObjectStoreEntryReaderActor
extends Actor
implements ObjectStoreEntryReader<Entry<String>> {
    private final Connection connection;
    private final JDBCObjectStoreEntryJournalQueries queries;
    private final String name;
    private final PreparedStatement entryQuery;
    private final PreparedStatement entriesQuery;
    private final PreparedStatement queryLastEntryId;
    private final PreparedStatement querySize;
    private final PreparedStatement upsertCurrentEntryOffset;
    private long offset;

    public JDBCObjectStoreEntryReaderActor(DatabaseType databaseType, Connection connection, String name) throws SQLException {
        this.queries = JDBCObjectStoreEntryJournalQueries.using(databaseType, connection);
        this.name = name;
        this.connection = connection;
        this.offset = 1L;
        this.connection.setAutoCommit(true);
        this.entryQuery = this.queries.statementForEntryQuery();
        this.entriesQuery = this.queries.statementForEntriesQuery(new String[]{"?", "?"});
        this.queryLastEntryId = this.queries.statementForQueryLastEntryId();
        this.querySize = this.queries.statementForSizeQuery();
        this.upsertCurrentEntryOffset = this.queries.statementForUpsertCurrentEntryOffsetQuery(new String[]{"?", "?"});
        this.queries.createTextEntryJournalReaderOffsetsTable();
        this.restoreCurrentOffset();
    }

    public void close() {
        try {
            if (!this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Completes<String> name() {
        return this.completes().with((Object)this.name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Completes<Entry<String>> readNext() {
        try {
            this.entryQuery.clearParameters();
            this.entryQuery.setLong(1, this.offset);
            try (ResultSet result = this.entryQuery.executeQuery();){
                Entry<String> entry = this.mapQueriedEntryFrom(result);
                ++this.offset;
                this.updateCurrentOffset();
                Completes completes = this.completes().with(entry);
                return completes;
            }
        }
        catch (Exception e) {
            this.logger().info("vlingo/symbio-jdbc: " + ((Object)((Object)this)).getClass().getSimpleName() + " Could not read next entry because: " + e.getMessage(), (Throwable)e);
            return this.completes().with(null);
        }
    }

    public Completes<Entry<String>> readNext(String fromId) {
        this.seekTo(fromId);
        return this.readNext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Completes<List<Entry<String>>> readNext(int maximumEntries) {
        try {
            this.entriesQuery.clearParameters();
            this.entriesQuery.setLong(1, this.offset);
            this.entriesQuery.setLong(2, this.offset + (long)maximumEntries - 1L);
            try (ResultSet result = this.entriesQuery.executeQuery();){
                List<Entry<String>> entries = this.mapQueriedEntriesFrom(result);
                this.offset += (long)entries.size();
                this.updateCurrentOffset();
                Completes completes = this.completes().with(entries);
                return completes;
            }
        }
        catch (Exception e) {
            this.logger().info("vlingo/symbio-jdbc: " + ((Object)((Object)this)).getClass().getSimpleName() + " Could not read next entry because: " + e.getMessage(), (Throwable)e);
            return this.completes().with(null);
        }
    }

    public Completes<List<Entry<String>>> readNext(String fromId, int maximumEntries) {
        this.seekTo(fromId);
        return this.readNext(maximumEntries);
    }

    public void rewind() {
        this.offset = 1L;
        this.updateCurrentOffset();
    }

    public Completes<String> seekTo(String id) {
        switch (id) {
            case "<": {
                this.offset = 1L;
                this.updateCurrentOffset();
                break;
            }
            case ">": {
                this.offset = this.retrieveLatestOffset() + 1L;
                this.updateCurrentOffset();
                break;
            }
            case "=": {
                break;
            }
            default: {
                this.offset = Long.parseLong(id);
                this.updateCurrentOffset();
            }
        }
        return this.completes().with((Object)String.valueOf(this.offset));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Completes<Long> size() {
        try (ResultSet result = this.querySize.executeQuery();){
            if (result.next()) {
                long size = result.getLong(1);
                Completes completes = this.completes().with((Object)size);
                return completes;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger().info("vlingo/symbio-jdbc: " + ((Object)((Object)this)).getClass().getSimpleName() + " Could not retrieve size, using -1L.");
        return this.completes().with((Object)-1L);
    }

    private List<Entry<String>> mapQueriedEntriesFrom(ResultSet result) throws SQLException {
        ArrayList<Entry<String>> entries = new ArrayList<Entry<String>>();
        while (result.next()) {
            Entry<String> entry = this.mapEntryRowFrom(result);
            entries.add(entry);
        }
        return entries;
    }

    private Entry<String> mapQueriedEntryFrom(ResultSet result) throws Exception {
        if (result.next()) {
            return this.mapEntryRowFrom(result);
        }
        return null;
    }

    private Entry<String> mapEntryRowFrom(ResultSet result) throws SQLException {
        String id = result.getString(1);
        String entryType = result.getString(2);
        int eventTypeVersion = result.getInt(3);
        String entryData = result.getString(4);
        String entryMetadata = result.getString(5);
        String entryMetadataOp = result.getString(6);
        return new BaseEntry.TextEntry(id, Entry.typed((String)entryType), eventTypeVersion, entryData, Metadata.with((String)entryMetadata, (String)entryMetadataOp));
    }

    private void restoreCurrentOffset() {
        this.offset = this.retrieveLatestOffset();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long retrieveLatestOffset() {
        try (ResultSet result = this.queryLastEntryId.executeQuery();){
            if (result.next()) {
                long latestId = result.getLong(1);
                long l = latestId > 0L ? latestId : 1L;
                return l;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger().info("vlingo/symbio-jdbc: " + ((Object)((Object)this)).getClass().getSimpleName() + " Could not retrieve latest offset, using current.");
        return this.offset;
    }

    private void updateCurrentOffset() {
        try {
            this.upsertCurrentEntryOffset.clearParameters();
            this.upsertCurrentEntryOffset.setString(1, this.name);
            this.upsertCurrentEntryOffset.setLong(2, this.offset);
            this.upsertCurrentEntryOffset.setLong(3, this.offset);
            this.upsertCurrentEntryOffset.executeUpdate();
        }
        catch (SQLException e) {
            this.logger().info("vlingo/symbio-jdbc: " + ((Object)((Object)this)).getClass().getSimpleName() + " Could not upsert current offset because: " + e.getMessage(), (Throwable)e);
        }
    }

    public static class JDBCObjectStoreEntryReaderInstantiator
    implements ActorInstantiator<JDBCObjectStoreEntryReaderActor> {
        private final Connection connection;
        private final DatabaseType databaseType;
        private final String name;

        public JDBCObjectStoreEntryReaderInstantiator(DatabaseType databaseType, Connection connection, String name) {
            this.databaseType = databaseType;
            this.connection = connection;
            this.name = name;
        }

        public JDBCObjectStoreEntryReaderActor instantiate() {
            try {
                return new JDBCObjectStoreEntryReaderActor(this.databaseType, this.connection, this.name);
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("Failed instantiator of " + this.getClass() + " because: " + e.getMessage(), e);
            }
        }

        public Class<JDBCObjectStoreEntryReaderActor> type() {
            return JDBCObjectStoreEntryReaderActor.class;
        }
    }
}

