/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc.jdbi;

import io.vlingo.actors.Logger;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapterProvider;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.common.jdbc.Configuration;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.object.ObjectStoreReader;
import io.vlingo.symbio.store.object.PersistentEntry;
import io.vlingo.symbio.store.object.QueryExpression;
import io.vlingo.symbio.store.object.StateObject;
import io.vlingo.symbio.store.object.StateObjectMapper;
import io.vlingo.symbio.store.object.jdbc.JDBCObjectStoreDelegate;
import io.vlingo.symbio.store.object.jdbc.jdbi.JdbiPersistMapper;
import io.vlingo.symbio.store.object.jdbc.jdbi.PersistentDispatchable;
import io.vlingo.symbio.store.object.jdbc.jdbi.UnitOfWork;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;

public class JdbiObjectStoreDelegate
extends JDBCObjectStoreDelegate {
    private static final String BindListKey = "listArgValues";
    private static final UnitOfWork AlwaysModified = new UnitOfWork.AlwaysModifiedUnitOfWork();
    private final StateAdapterProvider stateAdapterProvider;
    private final Handle handle;
    private final Logger logger;
    private final Map<Class<?>, StateObjectMapper> mappers;
    private final Map<Long, UnitOfWork> unitOfWorkRegistry;
    private long updateId;
    private final QueryExpression unconfirmedDispatchablesExpression;

    public JdbiObjectStoreDelegate(Configuration configuration, StateAdapterProvider stateAdapterProvider, QueryExpression unconfirmedDispatchablesExpression, Collection<StateObjectMapper> mappers, Logger logger) {
        super(configuration);
        this.handle = Jdbi.open((Connection)configuration.connection);
        this.stateAdapterProvider = stateAdapterProvider;
        this.unconfirmedDispatchablesExpression = unconfirmedDispatchablesExpression;
        this.mappers = new HashMap();
        this.unitOfWorkRegistry = new ConcurrentHashMap<Long, UnitOfWork>();
        this.updateId = 0L;
        this.logger = logger;
        this.initialize();
        mappers.forEach(mapper -> {
            this.mappers.put(mapper.type(), (StateObjectMapper)mapper);
            this.handle.registerRowMapper((RowMapper)mapper.queryMapper());
        });
    }

    public void close() {
        try {
            this.handle.close();
        }
        catch (Exception e) {
            this.logger.error("Close failed because: " + e.getMessage(), (Throwable)e);
        }
    }

    public JDBCObjectStoreDelegate copy() {
        try {
            return new JdbiObjectStoreDelegate(Configuration.cloneOf(this.configuration), this.stateAdapterProvider, this.unconfirmedDispatchablesExpression, this.mappers.values(), this.logger);
        }
        catch (Exception e) {
            String message = "Copy of JDBCObjectStoreDelegate failed because: " + e.getMessage();
            this.logger.error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public void beginTransaction() {
        this.handle.begin();
    }

    public void completeTransaction() {
        this.handle.commit();
    }

    public void failTransaction() {
        this.handle.rollback();
    }

    public <T extends StateObject> Collection<State<?>> persistAll(Collection<T> persistentObjects, long updateId, Metadata metadata) throws StorageException {
        boolean create = ObjectStoreReader.isNoId((long)updateId);
        UnitOfWork unitOfWork = this.unitOfWorkRegistry.getOrDefault(updateId, AlwaysModified);
        ArrayList states = new ArrayList();
        for (StateObject each : persistentObjects) {
            State<?> state = this.getRawState(metadata, each);
            this.persistEach(this.handle, unitOfWork, each, create);
            states.add(state);
        }
        this.unitOfWorkRegistry.remove(updateId);
        return states;
    }

    public <T extends StateObject> State<?> persist(T persistentObject, long updateId, Metadata metadata) throws StorageException {
        State<?> state = this.getRawState(metadata, persistentObject);
        boolean createLikely = state.dataVersion <= 1;
        boolean create = createLikely ? ObjectStoreReader.isNoId((long)updateId) : false;
        UnitOfWork unitOfWork = this.unitOfWorkRegistry.getOrDefault(updateId, AlwaysModified);
        this.persistEach(this.handle, unitOfWork, persistentObject, create);
        this.unitOfWorkRegistry.remove(updateId);
        return state;
    }

    private <T extends StateObject> State<?> getRawState(Metadata metadata, T detachedEntity) {
        int stateVersion = (int)detachedEntity.version();
        if (stateVersion < 1) {
            stateVersion = 1;
        }
        return this.stateAdapterProvider.asRaw(String.valueOf(detachedEntity.persistenceId()), detachedEntity, stateVersion, metadata);
    }

    public void persistEntries(Collection<Entry<?>> entries) throws StorageException {
        JdbiPersistMapper mapper = (JdbiPersistMapper)this.mappers.get(Entry.class).persistMapper();
        for (Entry<?> entry : entries) {
            Update statement = this.handle.createUpdate(mapper.insertStatement);
            ResultBearing resultBearing = this.bindAll((Object)new PersistentEntry(entry), mapper, statement).executeAndReturnGeneratedKeys(new String[0]);
            Object id = ((Map)resultBearing.mapToMap().one()).get("e_id");
            ((BaseEntry)entry).__internal__setId(id.toString());
        }
    }

    public void persistDispatchable(Dispatchable<Entry<?>, State<?>> dispatchable) throws StorageException {
        JdbiPersistMapper mapper = (JdbiPersistMapper)this.mappers.get(dispatchable.getClass()).persistMapper();
        Update statement = this.handle.createUpdate(mapper.insertStatement);
        this.bindAll(new PersistentDispatchable(this.configuration.originatorId, dispatchable), mapper, statement).execute();
    }

    public ObjectStoreReader.QueryMultiResults queryAll(QueryExpression expression) throws StorageException {
        List results = expression.isListQueryExpression() ? ((Query)this.handle.createQuery(expression.query).bindList(BindListKey, (Iterable)expression.asListQueryExpression().parameters)).mapTo(expression.type).list() : (expression.isMapQueryExpression() ? ((Query)this.handle.createQuery(expression.query).bindMap(expression.asMapQueryExpression().parameters)).mapTo(expression.type).list() : this.handle.createQuery(expression.query).mapTo(expression.type).list());
        return this.queryMultiResults(results, expression.mode);
    }

    public ObjectStoreReader.QuerySingleResult queryObject(QueryExpression expression) throws StorageException {
        Optional result = expression.isListQueryExpression() ? ((Query)this.handle.createQuery(expression.query).bindList(BindListKey, (Iterable)expression.asListQueryExpression().parameters)).mapTo(expression.type).findFirst() : (expression.isMapQueryExpression() ? ((Query)this.handle.createQuery(expression.query).bindMap(expression.asMapQueryExpression().parameters)).mapTo(expression.type).findFirst() : this.handle.createQuery(expression.query).mapTo(expression.type).findFirst());
        return this.querySingleResult(result.orElse(null), expression.mode);
    }

    public Collection<StateObjectMapper> registeredMappers() {
        return this.mappers.values();
    }

    public void registerMapper(StateObjectMapper mapper) {
    }

    @Override
    public JDBCObjectStoreDelegate.Type type() {
        return JDBCObjectStoreDelegate.Type.Jdbi;
    }

    @Override
    public void timeoutCheck() {
        long timeoutTime = System.currentTimeMillis() - this.configuration.transactionTimeoutMillis;
        ArrayList<UnitOfWork> unitOfWorkList = new ArrayList<UnitOfWork>(this.unitOfWorkRegistry.values());
        for (UnitOfWork unitOfWork : unitOfWorkList) {
            if (!unitOfWork.hasTimedOut(timeoutTime)) continue;
            this.unitOfWorkRegistry.remove(unitOfWork.unitOfWorkId);
        }
    }

    public Collection<Dispatchable<Entry<?>, State<?>>> allUnconfirmedDispatchableStates() {
        return this.handle.createQuery(this.unconfirmedDispatchablesExpression.query).mapTo(new GenericType<Dispatchable<Entry<?>, State<?>>>(){}).list();
    }

    public void confirmDispatched(String dispatchId) {
        JdbiPersistMapper mapper = (JdbiPersistMapper)this.mappers.get(Dispatchable.class).persistMapper();
        ((Update)this.handle.createUpdate(mapper.updateStatement).bind("id", dispatchId)).execute();
    }

    public void stop() {
        this.close();
    }

    private Update bindAll(Object persistentObject, JdbiPersistMapper mapper, Update statement) {
        for (BiFunction<Update, Object, Update> binder : mapper.binders) {
            binder.apply(statement, persistentObject);
        }
        return statement;
    }

    private void initialize() {
        try {
            this.handle.getConnection().setAutoCommit(true);
        }
        catch (Exception e) {
            this.logger.error("The connection could not be set to auto-commit; transactional problems likely.", (Throwable)e);
        }
    }

    private <T extends StateObject> int persistEach(Handle handle, UnitOfWork unitOfWork, T persistentObject, boolean create) {
        StateObject typed = StateObject.from(persistentObject);
        if (unitOfWork.isModified(typed)) {
            Class<?> type = persistentObject.getClass();
            JdbiPersistMapper mapper = (JdbiPersistMapper)this.mappers.get(type).persistMapper();
            try (Update statement = create ? handle.createUpdate(mapper.insertStatement) : handle.createUpdate(mapper.updateStatement);){
                Update update = this.bindAll(persistentObject, mapper, statement);
                ResultBearing result = update.executeAndReturnGeneratedKeys(new String[]{mapper.idColumnName});
                long generatedId = (Long)result.mapTo(Long.class).one();
                persistentObject.__internal__setPersistenceId(generatedId);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 1;
    }

    private ObjectStoreReader.QueryMultiResults queryMultiResults(List<?> presistentObjects, ObjectStoreReader.QueryMode mode) {
        if (mode.isReadUpdate() && !presistentObjects.isEmpty()) {
            return ObjectStoreReader.QueryMultiResults.of(presistentObjects, (long)this.registerUnitOfWork(presistentObjects));
        }
        return ObjectStoreReader.QueryMultiResults.of(presistentObjects);
    }

    private ObjectStoreReader.QuerySingleResult querySingleResult(Object presistentObject, ObjectStoreReader.QueryMode mode) {
        if (mode.isReadUpdate() && presistentObject != null) {
            return ObjectStoreReader.QuerySingleResult.of((Object)presistentObject, (long)this.registerUnitOfWork(presistentObject));
        }
        return ObjectStoreReader.QuerySingleResult.of((Object)presistentObject);
    }

    private long registerUnitOfWork(Object presistentObject) {
        long unitOfWorkId = ++this.updateId;
        this.unitOfWorkRegistry.put(unitOfWorkId, UnitOfWork.acquireFor(unitOfWorkId, presistentObject));
        return unitOfWorkId;
    }

    private long registerUnitOfWork(List<?> presistentObjects) {
        long unitOfWorkId = ++this.updateId;
        this.unitOfWorkRegistry.put(unitOfWorkId, UnitOfWork.acquireFor(unitOfWorkId, presistentObjects));
        return unitOfWorkId;
    }
}

