/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc.jdbi;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.common.Completes;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.store.object.ObjectStoreEntryReader;
import io.vlingo.symbio.store.object.QueryExpression;
import io.vlingo.symbio.store.object.StateObjectMapper;
import io.vlingo.symbio.store.object.jdbc.jdbi.JdbiOnDatabase;
import io.vlingo.symbio.store.object.jdbc.jdbi.JdbiPersistMapper;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.Update;

public class JdbiObjectStoreEntryReaderActor
extends Actor
implements ObjectStoreEntryReader<Entry<String>> {
    private final JdbiPersistMapper currentEntryOffsetMapper;
    private final JdbiOnDatabase jdbi;
    private final String name;
    private final QueryExpression queryLastEntryId;
    private final QueryExpression querySize;
    private long offset;

    public JdbiObjectStoreEntryReaderActor(JdbiOnDatabase jdbi, Collection<StateObjectMapper> mappers, String name) {
        this.jdbi = jdbi;
        this.name = name;
        this.offset = 1L;
        this.queryLastEntryId = jdbi.queryLastEntryId();
        this.currentEntryOffsetMapper = jdbi.currentEntryOffsetMapper(new String[]{":name", ":offset"});
        this.querySize = jdbi.querySize();
        mappers.forEach(mapper -> {
            Handle cfr_ignored_0 = (Handle)jdbi.handle.registerRowMapper((RowMapper)mapper.queryMapper());
        });
        this.restoreCurrentOffset();
    }

    public void close() {
        try {
            if (!this.jdbi.configuration().connection.isClosed()) {
                this.jdbi.configuration().connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Completes<String> name() {
        return this.completes().with((Object)this.name);
    }

    public Completes<Entry<String>> readNext() {
        try {
            QueryExpression expression = this.jdbi.queryEntry(this.offset);
            Entry entry = (Entry)this.jdbi.handle().createQuery(expression.query).mapTo(Entry.class).one();
            ++this.offset;
            this.updateCurrentOffset();
            return this.completes().with((Object)entry);
        }
        catch (Exception e) {
            this.logger().info("vlingo/symbio-jdbc: " + ((Object)((Object)this)).getClass().getSimpleName() + " Could not read next entry because: " + e.getMessage(), (Throwable)e);
            return this.completes().with(null);
        }
    }

    public Completes<Entry<String>> readNext(String fromId) {
        this.seekTo(fromId);
        return this.readNext();
    }

    public Completes<List<Entry<String>>> readNext(int maximumEntries) {
        try {
            QueryExpression expression = this.jdbi.queryEntries(this.offset, maximumEntries);
            List entries = this.jdbi.handle().createQuery(expression.query).mapTo(expression.type).list();
            this.offset += (long)entries.size();
            this.updateCurrentOffset();
            return this.completes().with((Object)entries);
        }
        catch (Exception e) {
            this.logger().info("vlingo/symbio-jdbc: " + ((Object)((Object)this)).getClass().getSimpleName() + " Could not read next entry because: " + e.getMessage(), (Throwable)e);
            return this.completes().with(null);
        }
    }

    public Completes<List<Entry<String>>> readNext(String fromId, int maximumEntries) {
        this.seekTo(fromId);
        return this.readNext(maximumEntries);
    }

    public void rewind() {
        this.offset = 1L;
        this.updateCurrentOffset();
    }

    public Completes<String> seekTo(String id) {
        switch (id) {
            case "<": {
                this.offset = 1L;
                this.updateCurrentOffset();
                break;
            }
            case ">": {
                this.offset = this.retrieveLatestOffset() + 1L;
                this.updateCurrentOffset();
                break;
            }
            case "=": {
                break;
            }
            default: {
                this.offset = Long.parseLong(id);
                this.updateCurrentOffset();
            }
        }
        return this.completes().with((Object)String.valueOf(this.offset));
    }

    public Completes<Long> size() {
        try {
            return this.completes().with(this.jdbi.handle().createQuery(this.querySize.query).mapTo(Long.class).one());
        }
        catch (Exception e) {
            this.logger().info("vlingo/symbio-jdbc: " + ((Object)((Object)this)).getClass().getSimpleName() + " Could not retrieve size, using -1L.");
            return this.completes().with((Object)-1L);
        }
    }

    private void restoreCurrentOffset() {
        this.offset = this.retrieveLatestOffset();
    }

    private long retrieveLatestOffset() {
        try {
            return (Long)this.jdbi.handle().createQuery(this.queryLastEntryId.query).mapTo(Long.class).one();
        }
        catch (Exception e) {
            this.logger().info("vlingo/symbio-jdbc: " + ((Object)((Object)this)).getClass().getSimpleName() + " Could not retrieve latest offset, using current.");
            return this.offset;
        }
    }

    private void updateCurrentOffset() {
        ((Update)((Update)this.jdbi.handle().createUpdate(this.currentEntryOffsetMapper.insertStatement).bind("name", this.name)).bind("offset", this.offset)).execute();
    }

    public static class JdbiObjectStoreEntryReaderInstantiator
    implements ActorInstantiator<JdbiObjectStoreEntryReaderActor> {
        private final JdbiOnDatabase jdbi;
        final Collection<StateObjectMapper> mappers;
        final String name;

        public JdbiObjectStoreEntryReaderInstantiator(JdbiOnDatabase jdbi, Collection<StateObjectMapper> mappers, String name) {
            this.jdbi = jdbi;
            this.mappers = mappers;
            this.name = name;
        }

        public JdbiObjectStoreEntryReaderActor instantiate() {
            return new JdbiObjectStoreEntryReaderActor(this.jdbi, this.mappers, this.name);
        }

        public Class<JdbiObjectStoreEntryReaderActor> type() {
            return JdbiObjectStoreEntryReaderActor.class;
        }
    }
}

