/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc.jdbi;

import io.vlingo.actors.World;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapterProvider;
import io.vlingo.symbio.store.common.jdbc.Configuration;
import io.vlingo.symbio.store.common.jdbc.DatabaseType;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.object.ListQueryExpression;
import io.vlingo.symbio.store.object.ObjectStore;
import io.vlingo.symbio.store.object.QueryExpression;
import io.vlingo.symbio.store.object.StateObjectMapper;
import io.vlingo.symbio.store.object.jdbc.JDBCObjectStoreActor;
import io.vlingo.symbio.store.object.jdbc.JDBCObjectStoreEntryJournalQueries;
import io.vlingo.symbio.store.object.jdbc.jdbi.JdbiObjectStoreDelegate;
import io.vlingo.symbio.store.object.jdbc.jdbi.JdbiOnHSQLDB;
import io.vlingo.symbio.store.object.jdbc.jdbi.JdbiOnMySQL;
import io.vlingo.symbio.store.object.jdbc.jdbi.JdbiOnPostgres;
import io.vlingo.symbio.store.object.jdbc.jdbi.JdbiOnYugaByte;
import io.vlingo.symbio.store.object.jdbc.jdbi.JdbiPersistMapper;
import io.vlingo.symbio.store.object.jdbc.jdbi.TextDispatchablesMapper;
import io.vlingo.symbio.store.object.jdbc.jdbi.TextEntryMapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.Update;

public abstract class JdbiOnDatabase {
    public final Configuration configuration;
    public final Handle handle;
    private final JDBCObjectStoreEntryJournalQueries queries;
    private ObjectStore objectStore;

    public static JdbiOnDatabase openUsing(Configuration configuration) {
        DatabaseType databaseType = DatabaseType.databaseType(configuration.connection);
        switch (databaseType) {
            case HSQLDB: {
                return JdbiOnHSQLDB.openUsing(configuration);
            }
            case MySQL: 
            case MariaDB: {
                return JdbiOnMySQL.openUsing(configuration);
            }
            case SQLServer: {
                break;
            }
            case Vitess: {
                break;
            }
            case Oracle: {
                break;
            }
            case Postgres: {
                return JdbiOnPostgres.openUsing(configuration);
            }
            case YugaByte: {
                return JdbiOnYugaByte.openUsing(configuration);
            }
        }
        throw new IllegalArgumentException("Database currently not supported: " + databaseType.name());
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public void createCommonTables() throws SQLException {
        this.queries.createCommonTables();
    }

    public void createDispatchableTable() throws SQLException {
        this.queries.createDispatchableTable();
    }

    public void createTextEntryJournalTable() throws SQLException {
        this.queries.createTextEntryJournalTable();
    }

    public void createTextEntryJournalReaderOffsetsTable() throws SQLException {
        this.queries.createTextEntryJournalReaderOffsetsTable();
    }

    public abstract JdbiPersistMapper currentEntryOffsetMapper(String[] var1);

    public DatabaseType databaseType() {
        return DatabaseType.databaseType(this.configuration.connection);
    }

    public Handle handle() {
        return this.handle;
    }

    public ObjectStore objectStore(World world, Dispatcher<Dispatchable<BaseEntry.TextEntry, State.TextState>> dispatcher, Collection<StateObjectMapper> mappers) {
        if (this.objectStore == null) {
            ArrayList<StateObjectMapper> objectMappers = new ArrayList<StateObjectMapper>(mappers);
            objectMappers.add(this.textEntryPersistentObjectMapper());
            objectMappers.add(this.dispatchableMapping());
            StateAdapterProvider stateAdapterProvider = StateAdapterProvider.instance((World)world);
            JdbiObjectStoreDelegate delegate = new JdbiObjectStoreDelegate(this.configuration, stateAdapterProvider, this.unconfirmedDispatchablesQueryExpression(), objectMappers, world.defaultLogger());
            this.objectStore = (ObjectStore)world.actorFor(ObjectStore.class, JDBCObjectStoreActor.class, new Object[]{delegate, dispatcher});
        }
        return this.objectStore;
    }

    public ObjectStore objectStore() {
        return this.objectStore;
    }

    public QueryExpression queryEntry(long id) {
        return QueryExpression.using(Entry.class, (String)this.queries.entryQuery(id));
    }

    public QueryExpression queryEntries(long id, int count) {
        return ListQueryExpression.using(Entry.class, (String)this.queries.entriesQuery(id, count));
    }

    public QueryExpression queryLastEntryId() {
        return QueryExpression.using(Long.class, (String)this.queries.lastEntryIdQuery());
    }

    public QueryExpression querySize() {
        return QueryExpression.using(Long.class, (String)this.queries.sizeQuery());
    }

    public TextDispatchablesMapper textDispatchablesMapper() {
        return new TextDispatchablesMapper();
    }

    public TextEntryMapper textEntryMapper() {
        return new TextEntryMapper();
    }

    public StateObjectMapper textEntryPersistentObjectMapper() {
        StateObjectMapper persistentObjectMapper = StateObjectMapper.with(Entry.class, (Object)JdbiPersistMapper.with(this.queries.insertEntriesQuery(new String[]{":entry.type", ":entry.typeVersion", ":entry.entryData", ":entry.metadata.value", ":entry.metadata.operation"}), "(unused)", (update, object) -> (Update)update.bindMethods(object)), (Object)this.textEntryMapper());
        return persistentObjectMapper;
    }

    protected JdbiOnDatabase(Configuration configuration) {
        this.configuration = configuration;
        this.handle = Jdbi.open((Connection)configuration.connection);
        this.queries = JDBCObjectStoreEntryJournalQueries.using(DatabaseType.databaseType(configuration.connection), configuration.connection);
    }

    private StateObjectMapper dispatchableMapping() {
        return StateObjectMapper.with(Dispatchable.class, (Object)JdbiPersistMapper.with(this.queries.insertDispatchableQuery(new String[]{":createdOn", ":originatorId", ":id", ":state.id", ":state.type", ":state.typeVersion", ":state.data", ":state.dataVersion", ":state.metadata", ":entries"}), this.queries.deleteDispatchableQuery(":id"), SqlStatement::bindMethods), (Object)this.textDispatchablesMapper());
    }

    private QueryExpression unconfirmedDispatchablesQueryExpression() {
        return new QueryExpression(Dispatchable.class, this.queries.unconfirmedDispatchablesQuery(this.configuration.originatorId));
    }
}

