/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc.jdbi;

import io.vlingo.common.serialization.JsonSerialization;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import java.time.LocalDateTime;
import java.util.List;
import org.jdbi.v3.core.mapper.Nested;

public final class PersistentDispatchable {
    private final String originatorId;
    private final Dispatchable<Entry<?>, State<?>> dispatchable;

    public PersistentDispatchable(String originatorId, Dispatchable<Entry<?>, State<?>> dispatchable) {
        this.originatorId = originatorId;
        this.dispatchable = dispatchable;
    }

    public String originatorId() {
        return this.originatorId;
    }

    public String id() {
        return this.dispatchable.id();
    }

    public LocalDateTime createdOn() {
        return this.dispatchable.createdOn();
    }

    @Nested
    public PersistentState state() {
        return this.dispatchable.state().map(PersistentState::new).orElse(null);
    }

    public String entries() {
        if (this.dispatchable.entries() != null && !this.dispatchable.entries().isEmpty()) {
            return JsonSerialization.serialized((List)this.dispatchable.entries());
        }
        return null;
    }

    public static class PersistentState {
        private final State<?> state;

        public PersistentState(State<?> state) {
            this.state = state;
        }

        public String id() {
            return this.state.id;
        }

        public String data() {
            return JsonSerialization.serialized((Object)this.state.data);
        }

        public int dataVersion() {
            return this.state.dataVersion;
        }

        public String type() {
            return this.state.type;
        }

        public int typeVersion() {
            return this.state.typeVersion;
        }

        public String metadata() {
            return JsonSerialization.serialized((Object)this.state.metadata);
        }
    }
}

