/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc.jdbi;

import io.vlingo.symbio.store.object.StateObject;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class StateObjectCopy {
    private static final ByteArrayOutputStream byteStream;
    private static final ObjectOutputStream serializer;
    private final byte[] image;

    static Map<Long, StateObjectCopy> all(List<?> persistentObjects) {
        HashMap<Long, StateObjectCopy> all = new HashMap<Long, StateObjectCopy>(persistentObjects.size());
        for (Object persistentObject : persistentObjects) {
            StateObject typed = StateObject.from(persistentObject);
            all.put(typed.persistenceId(), new StateObjectCopy(typed));
        }
        return all;
    }

    static Map<Long, StateObjectCopy> of(StateObject persistentObject) {
        return Collections.singletonMap(persistentObject.persistenceId(), new StateObjectCopy(persistentObject));
    }

    static String readable(byte[] data) {
        StringBuilder builder = new StringBuilder();
        for (int idx = 0; idx < data.length; ++idx) {
            builder.append("[").append(data[idx]).append("]");
        }
        return builder.toString();
    }

    StateObjectCopy(StateObject persistentObject) {
        this.image = this.toBytes(persistentObject);
    }

    boolean differsFrom(StateObject persistentObject) {
        byte[] other = this.toBytes(persistentObject);
        return !Arrays.equals(this.image, other);
    }

    byte[] image() {
        return this.image;
    }

    public String toString() {
        return "StateObjectCopy[image=" + StateObjectCopy.readable(this.image) + "]";
    }

    private byte[] toBytes(StateObject persistentObject) {
        try {
            byteStream.reset();
            serializer.reset();
            serializer.writeObject(persistentObject);
            return byteStream.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize StateObjectCopy.");
        }
    }

    static {
        try {
            byteStream = new ByteArrayOutputStream();
            serializer = new ObjectOutputStream(byteStream);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize StateObjectCopy.");
        }
    }
}

