/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc.jdbi;

import com.google.gson.reflect.TypeToken;
import io.vlingo.common.serialization.JsonSerialization;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class TextDispatchablesMapper
implements RowMapper<Dispatchable<Entry<?>, State<?>>> {
    public Dispatchable<Entry<?>, State<?>> map(ResultSet rs, StatementContext ctx) throws SQLException {
        Class<?> stateType;
        String dispatchId = rs.getString("D_DISPATCH_ID");
        LocalDateTime createdAt = rs.getTimestamp("D_CREATED_AT").toLocalDateTime();
        try {
            stateType = Class.forName(rs.getString("D_STATE_TYPE"));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        int stateTypeVersion = rs.getInt("D_STATE_TYPE_VERSION");
        int stateDataVersion = rs.getInt("D_STATE_DATA_VERSION");
        String stateId = rs.getString("D_STATE_ID");
        String stateData = rs.getString("D_STATE_DATA");
        String metadataValue = rs.getString("D_STATE_METADATA");
        Metadata metadata = (Metadata)JsonSerialization.deserialized((String)metadataValue, Metadata.class);
        String entriesJson = rs.getString("D_ENTRIES");
        List entries = entriesJson != null && !entriesJson.isEmpty() ? JsonSerialization.deserializedList((String)entriesJson, (Type)new TypeToken<List<BaseEntry.TextEntry>>(){}.getType()) : Collections.emptyList();
        State.TextState state = new State.TextState(stateId, stateType, stateTypeVersion, stateData, stateDataVersion, metadata);
        return new Dispatchable(dispatchId, createdAt, (State)state, entries);
    }
}

