/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc.jdbi;

import io.vlingo.symbio.store.object.StateObject;
import io.vlingo.symbio.store.object.jdbc.jdbi.StateObjectCopy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class UnitOfWork {
    public final Map<Long, StateObjectCopy> presistentObjects;
    public final long timestamp;
    public final long unitOfWorkId;

    static UnitOfWork acquireFor(long unitOfWorkId, Object stateObject) {
        return new UnitOfWork(unitOfWorkId, stateObject);
    }

    static UnitOfWork acquireFor(long unitOfWorkId, List<?> persistentObjects) {
        return new UnitOfWork(unitOfWorkId, persistentObjects);
    }

    UnitOfWork(long unitOfWorkId, Object stateObject) {
        this.unitOfWorkId = unitOfWorkId;
        this.presistentObjects = StateObjectCopy.of(StateObject.from((Object)stateObject));
        this.timestamp = System.currentTimeMillis();
    }

    UnitOfWork(long unitOfWorkId, List<?> persistentObjects) {
        this.unitOfWorkId = unitOfWorkId;
        this.presistentObjects = StateObjectCopy.all(persistentObjects);
        this.timestamp = System.currentTimeMillis();
    }

    boolean hasTimedOut(long timeoutTime) {
        return this.timestamp <= timeoutTime;
    }

    boolean isModified(StateObject stateObject) {
        StateObjectCopy original = this.presistentObjects.get(stateObject.persistenceId());
        return original.differsFrom(stateObject);
    }

    public static class AlwaysModifiedUnitOfWork
    extends UnitOfWork {
        AlwaysModifiedUnitOfWork() {
            super(-1L, Arrays.asList(new Object[0]));
        }

        @Override
        boolean isModified(StateObject stateObject) {
            return true;
        }
    }
}

