/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc.jpa;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Logger;
import io.vlingo.actors.World;
import io.vlingo.common.Completes;
import io.vlingo.common.Failure;
import io.vlingo.common.Success;
import io.vlingo.common.identity.IdentityGenerator;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.EntryAdapterProvider;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.EntryReader;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.common.jdbc.ConnectionProvider;
import io.vlingo.symbio.store.common.jdbc.DatabaseType;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.dispatch.DispatcherControl;
import io.vlingo.symbio.store.dispatch.control.DispatcherControlActor;
import io.vlingo.symbio.store.object.ObjectStoreEntryReader;
import io.vlingo.symbio.store.object.ObjectStoreReader;
import io.vlingo.symbio.store.object.ObjectStoreWriter;
import io.vlingo.symbio.store.object.QueryExpression;
import io.vlingo.symbio.store.object.StateObject;
import io.vlingo.symbio.store.object.StateSources;
import io.vlingo.symbio.store.object.jdbc.JDBCObjectStoreEntryReaderActor;
import io.vlingo.symbio.store.object.jdbc.jpa.JPAObjectStore;
import io.vlingo.symbio.store.object.jdbc.jpa.JPAObjectStoreDelegate;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JPAObjectStoreActor
extends Actor
implements JPAObjectStore {
    private final ConnectionProvider connectionProvider;
    private final DispatcherControl dispatcherControl;
    private final Dispatcher<Dispatchable<Entry<String>, State<?>>> dispatcher;
    private boolean closed;
    private final JPAObjectStoreDelegate delegate;
    private final EntryAdapterProvider entryAdapterProvider;
    private final Map<String, ObjectStoreEntryReader<?>> entryReaders;
    private final Logger logger;
    private final IdentityGenerator identityGenerator;

    public JPAObjectStoreActor(JPAObjectStoreDelegate delegate, ConnectionProvider connectionProvider, Dispatcher<Dispatchable<Entry<String>, State<?>>> dispatcher) {
        this(delegate, connectionProvider, dispatcher, 1000L, 1000L);
    }

    public JPAObjectStoreActor(JPAObjectStoreDelegate delegate, ConnectionProvider connectionProvider, Dispatcher<Dispatchable<Entry<String>, State<?>>> dispatcher, long checkConfirmationExpirationInterval, long confirmationExpiration) {
        this.delegate = delegate;
        this.connectionProvider = connectionProvider;
        this.dispatcher = dispatcher;
        this.entryReaders = new HashMap();
        this.closed = false;
        this.entryAdapterProvider = EntryAdapterProvider.instance((World)this.stage().world());
        this.logger = this.stage().world().defaultLogger();
        this.identityGenerator = new IdentityGenerator.RandomIdentityGenerator();
        this.dispatcherControl = (DispatcherControl)this.stage().actorFor(DispatcherControl.class, Definition.has(DispatcherControlActor.class, (ActorInstantiator)new DispatcherControl.DispatcherControlInstantiator(dispatcher, (DispatcherControl.DispatcherControlDelegate)delegate.copy(), checkConfirmationExpirationInterval, confirmationExpiration)));
    }

    public void close() {
        if (!this.closed) {
            this.delegate.close();
            if (this.dispatcherControl != null) {
                this.dispatcherControl.stop();
            }
            this.closed = true;
        }
    }

    public Completes<EntryReader<? extends Entry<?>>> entryReader(String name) {
        ObjectStoreEntryReader reader = this.entryReaders.get(name);
        if (reader == null) {
            Connection connection = this.connectionProvider.connection();
            DatabaseType databaseType = DatabaseType.databaseType(connection);
            reader = (ObjectStoreEntryReader)this.childActorFor(ObjectStoreEntryReader.class, Definition.has(JDBCObjectStoreEntryReaderActor.class, (ActorInstantiator)new JDBCObjectStoreEntryReaderActor.JDBCObjectStoreEntryReaderInstantiator(databaseType, connection, name)));
            this.entryReaders.put(name, reader);
        }
        return this.completes().with(reader);
    }

    public <T extends StateObject, E> void persist(StateSources<T, E> stateSources, Metadata metadata, long updateId, ObjectStoreWriter.PersistResultInterest interest, Object object) {
        List sources = stateSources.sources();
        StateObject persistentObject = stateSources.stateObject();
        try {
            this.delegate.beginTransaction();
            State<?> state = this.delegate.persist(persistentObject, updateId, metadata);
            int entryVersion = (int)stateSources.stateObject().version();
            List entries = this.entryAdapterProvider.asEntries(sources, entryVersion, metadata);
            this.delegate.persistEntries(entries);
            Dispatchable<Entry<String>, State<?>> dispatchable = this.buildDispatchable(state, entries);
            this.delegate.persistDispatchable(dispatchable);
            this.delegate.completeTransaction();
            this.dispatcher.dispatch(dispatchable);
            interest.persistResultedIn(Success.of((Object)Result.Success), (Object)persistentObject, 1, 1, object);
        }
        catch (StorageException e) {
            this.logger.error("Persist of: " + persistentObject + " failed because: " + e.getMessage(), (Throwable)e);
            this.delegate.failTransaction();
            interest.persistResultedIn(Failure.of((Throwable)e), (Object)persistentObject, 1, 0, object);
        }
        catch (Exception e) {
            this.logger.error("Persist of: " + persistentObject + " failed because: " + e.getMessage(), (Throwable)e);
            this.delegate.failTransaction();
            interest.persistResultedIn(Failure.of((Throwable)new StorageException(Result.Failure, e.getMessage(), (Throwable)e)), (Object)persistentObject, 1, 0, object);
        }
    }

    public <T extends StateObject, E> void persistAll(Collection<StateSources<T, E>> allStateSources, Metadata metadata, long updateId, ObjectStoreWriter.PersistResultInterest interest, Object object) {
        ArrayList<StateObject> allPersistentObjects = new ArrayList<StateObject>();
        ArrayList allDispatchables = new ArrayList();
        try {
            this.delegate.beginTransaction();
            for (StateSources<T, E> stateSources : allStateSources) {
                StateObject persistentObject = stateSources.stateObject();
                List sources = stateSources.sources();
                int entryVersion = (int)stateSources.stateObject().version();
                List entries = this.entryAdapterProvider.asEntries(sources, entryVersion, metadata);
                this.delegate.persistEntries(entries);
                State<?> state = this.delegate.persist(persistentObject, updateId, metadata);
                allPersistentObjects.add(persistentObject);
                Dispatchable<Entry<String>, State<?>> dispatchable = this.buildDispatchable(state, entries);
                this.delegate.persistDispatchable(dispatchable);
                allDispatchables.add(dispatchable);
            }
            this.delegate.completeTransaction();
            allDispatchables.forEach(arg_0 -> this.dispatcher.dispatch(arg_0));
            interest.persistResultedIn(Success.of((Object)Result.Success), allPersistentObjects, allPersistentObjects.size(), allPersistentObjects.size(), object);
        }
        catch (StorageException e) {
            this.logger.error("Persist all of: " + allPersistentObjects + " failed because: " + e.getMessage(), (Throwable)e);
            this.delegate.failTransaction();
            interest.persistResultedIn(Failure.of((Throwable)e), allPersistentObjects, allPersistentObjects.size(), 0, object);
        }
        catch (Exception e) {
            this.logger.error("Persist all of: " + allPersistentObjects + " failed because: " + e.getMessage(), (Throwable)e);
            this.delegate.failTransaction();
            interest.persistResultedIn(Failure.of((Throwable)new StorageException(Result.Failure, e.getMessage(), (Throwable)e)), allPersistentObjects, allPersistentObjects.size(), 0, object);
        }
    }

    public void queryAll(QueryExpression expression, ObjectStoreReader.QueryResultInterest interest, Object object) {
        try {
            ObjectStoreReader.QueryMultiResults results = this.delegate.queryAll(expression);
            interest.queryAllResultedIn(Success.of((Object)Result.Success), results, object);
        }
        catch (StorageException e) {
            this.logger.error("Query all failed because: " + e.getMessage(), (Throwable)e);
            interest.queryAllResultedIn(Failure.of((Throwable)e), ObjectStoreReader.QueryMultiResults.of(null), object);
        }
    }

    public void queryObject(QueryExpression expression, ObjectStoreReader.QueryResultInterest interest, Object object) {
        try {
            ObjectStoreReader.QuerySingleResult result = this.delegate.queryObject(expression);
            if (result.stateObject != null) {
                interest.queryObjectResultedIn(Success.of((Object)Result.Success), result, object);
            } else {
                interest.queryObjectResultedIn(Failure.of((Throwable)new StorageException(Result.NotFound, "No object identified by expression: " + expression)), result, object);
            }
        }
        catch (StorageException e) {
            this.logger.error("Query all failed because: " + e.getMessage(), (Throwable)e);
            interest.queryObjectResultedIn(Failure.of((Throwable)e), ObjectStoreReader.QuerySingleResult.of(null), object);
        }
    }

    @Override
    public <T extends StateObject> void remove(T persistentObject, long removeId, ObjectStoreWriter.PersistResultInterest interest, Object object) {
        try {
            int count = this.delegate.remove(persistentObject, removeId);
            interest.persistResultedIn(Success.of((Object)Result.Success), persistentObject, 1, count, object);
        }
        catch (StorageException e) {
            this.logger.error("Remove failed because: " + e.getMessage(), (Throwable)e);
            interest.persistResultedIn(Failure.of((Throwable)e), persistentObject, 1, 0, object);
        }
        catch (Exception e) {
            this.logger.error("Remove failed because: " + e.getMessage(), (Throwable)e);
            interest.persistResultedIn(Failure.of((Throwable)new StorageException(Result.Error, e.getMessage(), (Throwable)e)), persistentObject, 1, 0, object);
        }
    }

    private Dispatchable<Entry<String>, State<?>> buildDispatchable(State<?> state, List<Entry<String>> entries) {
        String id = this.identityGenerator.generate().toString();
        return new Dispatchable(id, LocalDateTime.now(), state, entries);
    }
}

