/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc.jpa;

import io.vlingo.actors.Logger;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapterProvider;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.object.MapQueryExpression;
import io.vlingo.symbio.store.object.ObjectStoreDelegate;
import io.vlingo.symbio.store.object.ObjectStoreReader;
import io.vlingo.symbio.store.object.QueryExpression;
import io.vlingo.symbio.store.object.StateObject;
import io.vlingo.symbio.store.object.StateObjectMapper;
import io.vlingo.symbio.store.object.jdbc.jpa.model.JPADispatchable;
import io.vlingo.symbio.store.object.jdbc.jpa.model.JPAEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;

public class JPAObjectStoreDelegate
implements ObjectStoreDelegate<Entry<String>, State<?>> {
    public static final String JPA_MYSQL_PERSISTENCE_UNIT = "JpaMySqlService";
    public static final String JPA_HSQLDB_PERSISTENCE_UNIT = "JpaHsqldbService";
    public static final String JPA_POSTGRES_PERSISTENCE_UNIT = "JpaPostgresService";
    public static final String JPA_YUGABYTE_PERSISTENCE_UNIT = "JpaYugaByteService";
    private final EntityManagerFactory emf;
    private final EntityManager em;
    private final Logger logger;
    private final String originatorId;
    private final String persistenceUnitName;
    private final StateAdapterProvider stateAdapterProvider;

    public JPAObjectStoreDelegate(String persistenceUnitName, Map<String, Object> properties, String originatorId, StateAdapterProvider stateAdapterProvider, Logger logger) {
        this.persistenceUnitName = persistenceUnitName;
        this.emf = Persistence.createEntityManagerFactory((String)persistenceUnitName, properties);
        this.em = this.emf.createEntityManager();
        this.stateAdapterProvider = stateAdapterProvider;
        this.logger = logger;
        this.originatorId = originatorId;
        FlushModeType flushMode = this.em.getFlushMode();
        if (flushMode.equals((Object)FlushModeType.AUTO)) {
            this.em.setFlushMode(FlushModeType.COMMIT);
        }
        flushMode = this.em.getFlushMode();
        assert (flushMode.equals((Object)FlushModeType.COMMIT));
    }

    public JPAObjectStoreDelegate copy() {
        return new JPAObjectStoreDelegate(this.persistenceUnitName, this.emf.getProperties(), this.originatorId, this.stateAdapterProvider, this.logger);
    }

    public void beginTransaction() {
        this.em.getTransaction().begin();
    }

    public void completeTransaction() {
        this.em.getTransaction().commit();
    }

    public void failTransaction() {
        this.em.getTransaction().rollback();
    }

    public <T extends StateObject> Collection<State<?>> persistAll(Collection<T> persistentObjects, long updateId, Metadata metadata) throws StorageException {
        ArrayList states = new ArrayList();
        for (StateObject detachedEntity : persistentObjects) {
            State<?> state = this.getRawState(metadata, detachedEntity);
            this.createOrUpdate(detachedEntity, detachedEntity.persistenceId());
            states.add(state);
        }
        return states;
    }

    public <T extends StateObject> State<?> persist(T persistentObject, long updateId, Metadata metadata) throws StorageException {
        State<?> state = this.getRawState(metadata, persistentObject);
        this.createOrUpdate(persistentObject, updateId);
        return state;
    }

    private <T extends StateObject> State<?> getRawState(Metadata metadata, T detachedEntity) {
        return this.stateAdapterProvider.asRaw(String.valueOf(detachedEntity.persistenceId()), detachedEntity, 1, metadata);
    }

    public void persistEntries(Collection<Entry<String>> entries) throws StorageException {
        this.appendEntries(entries);
    }

    public void persistDispatchable(Dispatchable<Entry<String>, State<?>> dispatchable) throws StorageException {
        this.em.persist((Object)JPADispatchable.fromDispatchable(this.originatorId, dispatchable));
    }

    public ObjectStoreReader.QueryMultiResults queryAll(QueryExpression expression) throws StorageException {
        Object parameters;
        TypedQuery query = this.em.createNamedQuery(expression.query, expression.type);
        if (expression.isListQueryExpression()) {
            parameters = expression.asListQueryExpression().parameters;
            if (parameters != null) {
                for (int i = 0; i < parameters.size(); ++i) {
                    int parmOrdinal = i + 1;
                    query = query.setParameter(parmOrdinal, parameters.get(i));
                }
            }
        } else if (expression.isMapQueryExpression()) {
            parameters = expression.asMapQueryExpression().parameters;
            for (String key : parameters.keySet()) {
                query = query.setParameter(key, parameters.get(key));
            }
        }
        this.em.getTransaction().begin();
        List results = query.getResultList();
        this.em.getTransaction().commit();
        return new ObjectStoreReader.QueryMultiResults((Collection)results);
    }

    public ObjectStoreReader.QuerySingleResult queryObject(QueryExpression expression) throws StorageException {
        Object obj;
        if (expression.isMapQueryExpression()) {
            MapQueryExpression mapExpression = expression.asMapQueryExpression();
            Object idObj = mapExpression.parameters.get("id");
            obj = this.findEntity(mapExpression.type, idObj);
            if (obj != null) {
                this.em.detach(obj);
            }
        } else {
            throw new StorageException(Result.Error, "Unsupported query expression: " + expression.getClass().getName());
        }
        return ObjectStoreReader.QuerySingleResult.of((Object)obj);
    }

    public void close() {
        try {
            this.em.close();
        }
        catch (Exception e) {
            this.logger.error("Close failed because: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T extends StateObject> int remove(T persistentObject, long removeId) {
        try {
            int count = 0;
            StateObject managedEntity = (StateObject)this.findEntity(persistentObject.getClass(), removeId);
            if (managedEntity == null) {
                throw new StorageException(Result.NotFound, "Could not find " + persistentObject + " with id=" + removeId);
            }
            this.em.getTransaction().begin();
            this.em.remove((Object)managedEntity);
            this.em.getTransaction().commit();
            return ++count;
        }
        catch (Exception e) {
            this.em.getTransaction().rollback();
            String errorMsg = "Removal of: " + persistentObject + " failed because: " + e.getMessage();
            this.logger.error(errorMsg, (Throwable)e);
            throw new StorageException(Result.Error, errorMsg, (Throwable)e);
        }
    }

    public Collection<Dispatchable<Entry<String>, State<?>>> allUnconfirmedDispatchableStates() {
        return this.em.createNamedQuery("Dispatchables.getUnconfirmed", JPADispatchable.class).setParameter("orignatorId", (Object)this.originatorId).getResultStream().map(JPADispatchable::toDispatchable).collect(Collectors.toList());
    }

    public void confirmDispatched(String dispatchId) {
        this.beginTransaction();
        try {
            this.em.createNamedQuery("Dispatchables.deleteByDispatchId").setParameter(1, (Object)dispatchId).executeUpdate();
            this.completeTransaction();
        }
        catch (Exception e) {
            this.logger.error("Failed to confirm dispatch id {}", new Object[]{dispatchId, e});
            this.failTransaction();
        }
    }

    public void stop() {
        this.close();
    }

    public Collection<StateObjectMapper> registeredMappers() {
        throw new UnsupportedOperationException("registeredMappers is unnecessary for JPA.");
    }

    public void registerMapper(StateObjectMapper mapper) {
        throw new UnsupportedOperationException("registerMapper is unnecessary for JPA.");
    }

    private Object findEntity(Class<?> entityClass, Object primaryKey) {
        return this.em.find(entityClass, primaryKey);
    }

    private void createOrUpdate(Object detachedEntity, long updateId) {
        if (ObjectStoreReader.isNoId((long)updateId)) {
            this.em.persist(detachedEntity);
        } else {
            Object managedEntity = this.findEntity(detachedEntity.getClass(), updateId);
            if (managedEntity == null) {
                this.em.persist(detachedEntity);
            } else {
                this.em.merge(detachedEntity);
            }
        }
    }

    private void appendEntries(Collection<Entry<String>> entries) {
        for (Entry<String> entry : entries) {
            JPAEntry jpaEntry;
            if (entry instanceof JPAEntry) {
                jpaEntry = (JPAEntry)entry;
                this.em.persist(entry);
            } else {
                jpaEntry = new JPAEntry(entry);
                this.em.persist((Object)jpaEntry);
                ((BaseEntry)entry).__internal__setId(jpaEntry.id());
                this.logger.debug("BASEENTRY COPY: " + entry);
            }
            this.logger.debug("em.persist(" + jpaEntry + ")");
        }
    }
}

