/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc.jpa.model;

import com.google.gson.reflect.TypeToken;
import io.vlingo.common.serialization.JsonSerialization;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.object.jdbc.jpa.model.converters.LocalDateTimeConverter;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@Entity(name="Dispatchables")
@Table(name="tbl_vlingo_objectstore_dispatchables")
@NamedNativeQueries(value={@NamedNativeQuery(name="Dispatchables.deleteByDispatchId", query="DELETE FROM tbl_vlingo_objectstore_dispatchables WHERE dispatch_id = ?")})
@NamedQueries(value={@NamedQuery(name="Dispatchables.getUnconfirmed", query="SELECT d FROM Dispatchables AS d where d.originatorId = :orignatorId ORDER BY d.createdOn ASC")})
public class JPADispatchable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @Column(name="id", updatable=false, nullable=false)
    private long id;
    @Column(name="dispatch_id", updatable=false, nullable=false)
    private String dispatchId;
    @Column(name="originator_id", updatable=false, nullable=false)
    private String originatorId;
    @Column(name="created_on", updatable=false, nullable=false)
    @Convert(converter=LocalDateTimeConverter.class)
    private LocalDateTime createdOn;
    @Column(name="state_id", updatable=false)
    private String stateId;
    @Column(name="state_type", updatable=false)
    private String stateType;
    @Column(name="state_type_version", updatable=false)
    private Integer stateTypeVersion;
    @Lob
    @Column(name="state_data", updatable=false)
    private String stateData;
    @Column(name="state_data_version", updatable=false)
    private Integer stateDataVersion;
    @Lob
    @Column(name="state_metadata", updatable=false)
    private String stateMetadata;
    @Lob
    @Column(name="entries", updatable=false)
    private String entries;

    public JPADispatchable() {
    }

    public JPADispatchable(long id, String dispatchId, String originatorId, LocalDateTime createdOn, String stateId, String stateType, Integer stateTypeVersion, String stateData, Integer stateDataVersion, String stateMetadata, String entries) {
        this.id = id;
        this.dispatchId = dispatchId;
        this.originatorId = originatorId;
        this.createdOn = createdOn;
        this.stateId = stateId;
        this.stateType = stateType;
        this.stateTypeVersion = stateTypeVersion;
        this.stateData = stateData;
        this.stateDataVersion = stateDataVersion;
        this.stateMetadata = stateMetadata;
        this.entries = entries;
    }

    public long getId() {
        return this.id;
    }

    public String getDispatchId() {
        return this.dispatchId;
    }

    public String getOriginatorId() {
        return this.originatorId;
    }

    public LocalDateTime getCreatedOn() {
        return this.createdOn;
    }

    public String getStateId() {
        return this.stateId;
    }

    public String getStateType() {
        return this.stateType;
    }

    public Integer getStateTypeVersion() {
        return this.stateTypeVersion;
    }

    public String getStateData() {
        return this.stateData;
    }

    public Integer getStateDataVersion() {
        return this.stateDataVersion;
    }

    public String getStateMetadata() {
        return this.stateMetadata;
    }

    public String getEntries() {
        return this.entries;
    }

    public static JPADispatchable fromDispatchable(String originatorId, Dispatchable<Entry<String>, State<?>> dispatchable) {
        JPADispatchable jpaDispatchable = new JPADispatchable();
        jpaDispatchable.dispatchId = dispatchable.id();
        jpaDispatchable.createdOn = dispatchable.createdOn();
        jpaDispatchable.originatorId = originatorId;
        dispatchable.state().ifPresent(state -> {
            jpaDispatchable.stateId = state.id;
            jpaDispatchable.stateType = state.type;
            jpaDispatchable.stateTypeVersion = state.typeVersion;
            jpaDispatchable.stateData = JsonSerialization.serialized((Object)state.data);
            jpaDispatchable.stateDataVersion = state.dataVersion;
            jpaDispatchable.stateMetadata = JsonSerialization.serialized((Object)state.metadata);
        });
        jpaDispatchable.entries = JsonSerialization.serialized((List)dispatchable.entries());
        return jpaDispatchable;
    }

    public static Dispatchable<Entry<String>, State<?>> toDispatchable(JPADispatchable jpaDispatchable) {
        State.TextState state = null;
        if (jpaDispatchable.stateId != null && jpaDispatchable.stateData != null) {
            Class<?> stateType;
            try {
                stateType = Class.forName(jpaDispatchable.stateType);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            state = new State.TextState(Long.toString(jpaDispatchable.id), stateType, jpaDispatchable.stateTypeVersion.intValue(), jpaDispatchable.stateData, jpaDispatchable.stateDataVersion.intValue(), (Metadata)JsonSerialization.deserialized((String)jpaDispatchable.stateMetadata, Metadata.class));
        }
        List entries = null;
        if (jpaDispatchable.entries != null && !jpaDispatchable.entries.isEmpty()) {
            entries = JsonSerialization.deserializedList((String)jpaDispatchable.entries, (Type)new TypeToken<List<BaseEntry.TextEntry>>(){}.getType());
        }
        return new Dispatchable(jpaDispatchable.dispatchId, jpaDispatchable.createdOn, state, entries);
    }
}

