/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.object.jdbc.jpa.model;

import io.vlingo.symbio.Entry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.store.object.jdbc.jpa.model.converters.LocalDateConverter;
import java.time.LocalDate;
import java.util.Comparator;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="tbl_vlingo_objectstore_entry_journal")
public class JPAEntry
implements Entry<String> {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @Column(name="e_id", updatable=false, nullable=false)
    private long id;
    @Column(name="e_data", updatable=false, nullable=false)
    private String entryData;
    @Column(name="e_entry_version", updatable=false, nullable=false)
    private int entryVersion;
    @Column(name="e_metadata_value", updatable=false, nullable=false)
    private String metadataValue;
    @Column(name="e_metadata_op", updatable=false, nullable=false)
    private String metadataOp;
    @Column(name="e_type", updatable=false, nullable=false)
    private String type;
    @Column(name="e_type_version", updatable=false, nullable=false)
    private int typeVersion;
    @Column(name="e_timestamp", updatable=false, nullable=false)
    @Convert(converter=LocalDateConverter.class)
    private LocalDate entryTimestamp;

    public JPAEntry() {
    }

    public JPAEntry(Entry<String> entry) {
        this.entryData = (String)entry.entryData();
        this.entryVersion = entry.entryVersion();
        this.metadataValue = entry.metadata().value;
        this.metadataOp = entry.metadata().operation;
        this.type = entry.typeName();
        this.typeVersion = entry.typeVersion();
        this.entryTimestamp = LocalDate.now();
    }

    public JPAEntry(Class<?> type, int typeVersion, String entryData, Metadata metadata) {
        this(type, typeVersion, entryData, -1, metadata);
    }

    public JPAEntry(Class<?> type, int typeVersion, String entryData, int entryVersion, Metadata metadata) {
        if (type == null) {
            throw new IllegalArgumentException("Entry type must not be null.");
        }
        this.type = type.getName();
        if (typeVersion <= 0) {
            throw new IllegalArgumentException("Entry typeVersion must be greater than 0.");
        }
        this.typeVersion = typeVersion;
        if (entryData == null) {
            throw new IllegalArgumentException("Entry entryData must not be null.");
        }
        this.entryData = entryData;
        this.entryVersion = entryVersion;
        if (metadata == null) {
            throw new IllegalArgumentException("Entry metadata must not be null.");
        }
        this.metadataValue = this.metadata().value;
        this.metadataOp = this.metadata().operation;
        this.entryTimestamp = LocalDate.now();
    }

    public JPAEntry(String id, Class<?> type, int typeVersion, String entryData, Metadata metadata) {
        this(id, type, typeVersion, entryData, -1, metadata);
    }

    public JPAEntry(String id, Class<?> type, int typeVersion, String entryData, int entryVersion, Metadata metadata) {
        if (id == null) {
            throw new IllegalArgumentException("Entry id must not be null.");
        }
        this.id = Long.parseLong(id);
        if (type == null) {
            throw new IllegalArgumentException("Entry type must not be null.");
        }
        this.type = type.getName();
        if (typeVersion <= 0) {
            throw new IllegalArgumentException("Entry typeVersion must be greater than 0.");
        }
        this.typeVersion = typeVersion;
        if (entryData == null) {
            throw new IllegalArgumentException("Entry entryData must not be null.");
        }
        this.entryData = entryData;
        this.entryVersion = entryVersion;
        if (metadata == null) {
            throw new IllegalArgumentException("Entry metadata must not be null.");
        }
        this.metadataValue = this.metadata().value;
        this.metadataOp = this.metadata().operation;
        this.entryTimestamp = LocalDate.now();
    }

    public String id() {
        return String.valueOf(this.id);
    }

    public LocalDate entryTimestamp() {
        return this.entryTimestamp;
    }

    public String entryData() {
        return this.entryData;
    }

    public Metadata metadata() {
        return Metadata.with((String)this.metadataValue, (String)this.metadataOp);
    }

    public String typeName() {
        return this.type;
    }

    public int typeVersion() {
        return this.typeVersion;
    }

    public boolean hasMetadata() {
        return !this.metadataValue.isEmpty();
    }

    public boolean isEmpty() {
        return this.entryData.isEmpty();
    }

    public boolean isNull() {
        return false;
    }

    public <C> Class<C> typed() {
        try {
            return Class.forName(this.type);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get class for type: " + this.type);
        }
    }

    public int compareTo(Entry<String> other) {
        JPAEntry that = (JPAEntry)other;
        return Comparator.comparing(e -> e.id).thenComparing(e -> e.entryTimestamp).thenComparing(e -> e.entryData).thenComparing(e -> e.type).thenComparingInt(e -> e.typeVersion).thenComparing(e -> e.metadataValue).thenComparing(e -> e.metadataOp).compare(this, that);
    }

    public String toString() {
        return "JPAEntry(" + "id=" + this.id + ", entryTimestamp=" + this.entryTimestamp + ", entryData=" + this.entryData + ", metadata=" + this.metadataValue + "," + this.metadataOp + ", type=" + this.type + ", typeVersion=" + this.typeVersion + ")";
    }

    public Entry<String> withId(String id) {
        return new JPAEntry(id, this.typed(), this.typeVersion, this.entryData, Metadata.with((String)this.metadataValue, (String)this.metadataOp));
    }

    public void __internal__setId(String id) {
        this.id = Long.parseLong(id);
    }
}

