/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.jdbc;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.common.Completes;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.store.EntryReader;
import io.vlingo.symbio.store.common.jdbc.Configuration;
import io.vlingo.symbio.store.state.StateStoreEntryReader;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DbStateStoreEntryReaderActor<T extends Entry<?>>
extends Actor
implements StateStoreEntryReader<T> {
    private final EntryReader.Advice advice;
    private final Configuration configuration;
    private long currentId;
    private final String name;
    private final PreparedStatement queryBatch;
    private final PreparedStatement queryCount;
    private final PreparedStatement queryLatestOffset;
    private final PreparedStatement queryOne;
    private final PreparedStatement updateCurrentOffset;

    public DbStateStoreEntryReaderActor(EntryReader.Advice advice, String name) throws Exception {
        this.advice = advice;
        this.name = name;
        this.configuration = (Configuration)advice.specificConfiguration();
        this.currentId = 0L;
        this.queryBatch = this.configuration.connection.prepareStatement(this.advice.queryEntryBatchExpression);
        this.queryCount = this.configuration.connection.prepareStatement(this.advice.queryCount);
        this.queryLatestOffset = this.configuration.connection.prepareStatement(this.advice.queryLatestOffset);
        this.queryOne = this.configuration.connection.prepareStatement(this.advice.queryEntryExpression);
        this.updateCurrentOffset = this.configuration.connection.prepareStatement(this.advice.queryUpdateCurrentOffset);
    }

    public void close() {
        try {
            this.queryBatch.close();
            this.queryOne.close();
            this.configuration.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Completes<String> name() {
        return this.completes().with((Object)this.name);
    }

    public Completes<T> readNext() {
        return this.completes().with(this.queryNext());
    }

    public Completes<T> readNext(String fromId) {
        this.seekTo(fromId);
        return this.readNext();
    }

    public Completes<List<T>> readNext(int maximumEntries) {
        return this.completes().with(this.queryNext(maximumEntries));
    }

    public Completes<List<T>> readNext(String fromId, int maximumEntries) {
        this.seekTo(fromId);
        return this.readNext(maximumEntries);
    }

    public void rewind() {
        this.currentId = 0L;
    }

    public Completes<String> seekTo(String id) {
        switch (id) {
            case "<": {
                this.currentId = 1L;
                this.updateCurrentOffset();
                break;
            }
            case ">": {
                this.currentId = this.retrieveLatestOffset() + 1L;
                this.updateCurrentOffset();
                break;
            }
            case "=": {
                break;
            }
            default: {
                this.currentId = Integer.parseInt(id);
                this.updateCurrentOffset();
            }
        }
        return this.completes().with((Object)String.valueOf(this.currentId));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Completes<Long> size() {
        try (ResultSet resultSet = this.queryCount.executeQuery();){
            if (!resultSet.next()) return this.completes().with((Object)-1L);
            long count = resultSet.getLong(1);
            Completes completes = this.completes().with((Object)count);
            return completes;
        }
        catch (Exception e) {
            this.logger().error("vlingo/symbio-postgres: " + e.getMessage(), (Throwable)e);
            this.logger().error("vlingo/symbio-postgres: Rewinding the offset");
        }
        return this.completes().with((Object)-1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Entry<?> queryNext() {
        try {
            this.queryOne.clearParameters();
            this.queryOne.setLong(1, this.currentId);
            try (ResultSet result = this.queryOne.executeQuery();){
                if (!result.first()) return null;
                long id = result.getLong(1);
                Entry<?> entry2 = this.entryFrom(result, id);
                this.currentId = id + 1L;
                Entry<?> entry = entry2;
                return entry;
            }
        }
        catch (Exception e) {
            this.logger().error("Unable to read next entry for " + this.name + " because: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Entry<?>> queryNext(int maximumEntries) {
        try {
            this.queryBatch.clearParameters();
            this.queryBatch.setLong(1, this.currentId);
            this.queryBatch.setInt(2, maximumEntries);
            try (ResultSet result = this.queryBatch.executeQuery();){
                ArrayList entries = new ArrayList(maximumEntries);
                while (result.next()) {
                    long id = result.getLong(1);
                    Entry<?> entry = this.entryFrom(result, id);
                    this.currentId = id + 1L;
                    entries.add(entry);
                }
                ArrayList arrayList = entries;
                return arrayList;
            }
        }
        catch (Exception e) {
            this.logger().error("Unable to read next " + maximumEntries + " entries for " + this.name + " because: " + e.getMessage(), (Throwable)e);
            return new ArrayList(0);
        }
    }

    private Entry<?> entryFrom(ResultSet result, long id) throws Exception {
        String type = result.getString(2);
        int typeVersion = result.getInt(3);
        String metadataValue = result.getString(5);
        String metadataOperation = result.getString(6);
        Metadata metadata = Metadata.with((String)metadataValue, (String)metadataOperation);
        if (this.configuration.format.isBinary()) {
            return new BaseEntry.BinaryEntry(String.valueOf(id), this.typed(type), typeVersion, this.binaryDataFrom(result, 4), metadata);
        }
        return new BaseEntry.TextEntry(String.valueOf(id), this.typed(type), typeVersion, this.textDataFrom(result, 4), metadata);
    }

    private byte[] binaryDataFrom(ResultSet resultSet, int columnIndex) throws Exception {
        Blob blob = resultSet.getBlob(columnIndex);
        byte[] data = blob.getBytes(1L, (int)blob.length());
        return data;
    }

    private String textDataFrom(ResultSet resultSet, int columnIndex) throws Exception {
        String data = resultSet.getString(columnIndex);
        return data;
    }

    private Class<?> typed(String typeName) throws Exception {
        return Class.forName(typeName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long retrieveLatestOffset() {
        try {
            this.queryBatch.clearParameters();
            this.queryLatestOffset.setString(1, this.name);
            try (ResultSet resultSet = this.queryLatestOffset.executeQuery();){
                if (!resultSet.next()) return 0L;
                long l = resultSet.getLong(1);
                return l;
            }
        }
        catch (Exception e) {
            this.logger().error("vlingo/symbio-postgres: Could not retrieve latest offset, using current.");
        }
        return 0L;
    }

    private void updateCurrentOffset() {
        try {
            this.updateCurrentOffset.clearParameters();
            this.updateCurrentOffset.setLong(1, this.currentId);
            this.updateCurrentOffset.setString(2, this.name);
            this.updateCurrentOffset.setLong(3, this.currentId);
            this.updateCurrentOffset.executeUpdate();
            this.configuration.connection.commit();
        }
        catch (Exception e) {
            this.logger().error("vlingo/symbio-postgres: Could not persist the offset. Will retry on next read.");
            this.logger().error("vlingo/symbio-postgres: " + e.getMessage(), (Throwable)e);
        }
    }

    public static class DbStateStoreEntryReaderInstantiator<T extends Entry<?>>
    implements ActorInstantiator<DbStateStoreEntryReaderActor<T>> {
        private EntryReader.Advice advice;
        private String name;

        public DbStateStoreEntryReaderActor<T> instantiate() {
            try {
                return new DbStateStoreEntryReaderActor(this.advice, this.name);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to instantiate " + this.getClass() + " because: " + e.getMessage(), e);
            }
        }

        public Class<DbStateStoreEntryReaderActor<T>> type() {
            return DbStateStoreEntryReaderActor.class;
        }

        public void set(String name, Object value) {
            switch (name) {
                case "advice": {
                    this.advice = (EntryReader.Advice)value;
                    break;
                }
                case "name": {
                    this.name = (String)value;
                }
            }
        }
    }
}

