/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.jdbc;

import io.vlingo.actors.Logger;
import io.vlingo.symbio.store.DataFormat;
import io.vlingo.symbio.store.common.jdbc.CachedStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;

public abstract class JDBCDispatchableCachedStatements<T> {
    private final CachedStatement<T> appendDispatchable;
    private final CachedStatement<T> queryEntry;
    private final CachedStatement<T> appendEntry;
    private final CachedStatement<T> appendEntryIdentity;
    private final CachedStatement<T> deleteDispatchable;
    private final CachedStatement<T> queryAllDispatchables;

    protected JDBCDispatchableCachedStatements(String originatorId, Connection connection, DataFormat format, T appendDataObject, Logger logger) {
        this.queryEntry = this.createStatement(this.queryEntryExpression(), appendDataObject, connection, logger);
        this.appendEntry = this.createStatement(this.appendEntryExpression(), appendDataObject, connection, logger);
        this.appendEntryIdentity = this.createStatement(this.appendEntryIdentityExpression(), null, connection, logger);
        this.appendDispatchable = this.createStatement(this.appendDispatchableExpression(), appendDataObject, connection, logger);
        this.deleteDispatchable = this.createStatement(this.deleteDispatchableExpression(), null, connection, logger);
        this.queryAllDispatchables = this.prepareQuery(this.createStatement(this.selectDispatchableExpression(), null, connection, logger), originatorId, logger);
    }

    public final CachedStatement<T> appendDispatchableStatement() {
        return this.appendDispatchable;
    }

    public final CachedStatement<T> appendEntryStatement() {
        return this.appendEntry;
    }

    public final CachedStatement<T> appendEntryIdentityStatement() {
        return this.appendEntryIdentity;
    }

    public final CachedStatement<T> deleteStatement() {
        return this.deleteDispatchable;
    }

    public final CachedStatement<T> queryAllStatement() {
        return this.queryAllDispatchables;
    }

    public CachedStatement<T> getQueryEntry() {
        return this.queryEntry;
    }

    protected abstract String appendEntryExpression();

    protected abstract String queryEntryExpression();

    protected abstract String appendDispatchableExpression();

    protected abstract String appendEntryIdentityExpression();

    protected abstract String deleteDispatchableExpression();

    protected abstract String selectDispatchableExpression();

    private CachedStatement<T> createStatement(String sql, T data, Connection connection, Logger logger) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            return new CachedStatement<T>(preparedStatement, data);
        }
        catch (Exception e) {
            String message = this.getClass().getSimpleName() + ": Failed to create dispatchable statement: \n" + sql + "\nbecause: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new IllegalStateException(message);
        }
    }

    private CachedStatement<T> prepareQuery(CachedStatement<T> cached, String originatorId, Logger logger) {
        try {
            cached.preparedStatement.setString(1, originatorId);
            return cached;
        }
        catch (Exception e) {
            String message = this.getClass().getSimpleName() + ": Failed to prepare query=all because: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new IllegalStateException(message);
        }
    }
}

