/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.jdbc;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Definition;
import io.vlingo.actors.World;
import io.vlingo.common.Completes;
import io.vlingo.common.Failure;
import io.vlingo.common.Success;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.EntryAdapterProvider;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapterProvider;
import io.vlingo.symbio.store.EntryReader;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.dispatch.DispatcherControl;
import io.vlingo.symbio.store.dispatch.control.DispatcherControlActor;
import io.vlingo.symbio.store.state.StateStore;
import io.vlingo.symbio.store.state.StateStoreEntryReader;
import io.vlingo.symbio.store.state.StateTypeStateStoreMap;
import io.vlingo.symbio.store.state.jdbc.JDBCStorageDelegate;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JDBCStateStoreActor
extends Actor
implements StateStore {
    private final JDBCStorageDelegate<State.TextState> delegate;
    private final Dispatcher<Dispatchable<Entry<?>, State<String>>> dispatcher;
    private final DispatcherControl dispatcherControl;
    private final Map<String, StateStoreEntryReader<?>> entryReaders;
    private final EntryAdapterProvider entryAdapterProvider;
    private final StateAdapterProvider stateAdapterProvider;

    public JDBCStateStoreActor(JDBCStorageDelegate<State.TextState> delegate) {
        this(null, delegate, 0L, 0L);
    }

    public JDBCStateStoreActor(Dispatcher<Dispatchable<Entry<?>, State<String>>> dispatcher, JDBCStorageDelegate<State.TextState> delegate) {
        this(dispatcher, delegate, 1000L, 1000L);
    }

    public JDBCStateStoreActor(Dispatcher<Dispatchable<Entry<?>, State<String>>> dispatcher, JDBCStorageDelegate<State.TextState> delegate, long checkConfirmationExpirationInterval, long confirmationExpiration) {
        this.delegate = delegate;
        this.entryReaders = new HashMap();
        this.entryAdapterProvider = EntryAdapterProvider.instance((World)this.stage().world());
        this.stateAdapterProvider = StateAdapterProvider.instance((World)this.stage().world());
        if (dispatcher != null) {
            this.dispatcher = dispatcher;
            this.dispatcherControl = (DispatcherControl)this.stage().actorFor(DispatcherControl.class, Definition.has(DispatcherControlActor.class, (ActorInstantiator)new DispatcherControl.DispatcherControlInstantiator(dispatcher, (DispatcherControl.DispatcherControlDelegate)((JDBCStorageDelegate)delegate.copy()), checkConfirmationExpirationInterval, confirmationExpiration)));
        } else {
            this.dispatcher = null;
            this.dispatcherControl = null;
        }
    }

    public void stop() {
        for (StateStoreEntryReader<?> reader : this.entryReaders.values()) {
            reader.close();
        }
        this.delegate.close();
        if (this.dispatcherControl != null) {
            this.dispatcherControl.stop();
        }
        super.stop();
    }

    public <ET extends Entry<?>> Completes<StateStoreEntryReader<ET>> entryReader(String name) {
        StateStoreEntryReader reader = this.entryReaders.get(name);
        if (reader == null) {
            EntryReader.Advice advice = this.delegate.entryReaderAdvice();
            ActorInstantiator instantiator = this.delegate.instantiator();
            instantiator.set("advice", (Object)advice);
            instantiator.set("name", (Object)name);
            reader = (StateStoreEntryReader)this.childActorFor(StateStoreEntryReader.class, Definition.has((Class)advice.entryReaderClass, (ActorInstantiator)instantiator));
            this.entryReaders.put(name, reader);
        }
        return this.completes().with(reader);
    }

    public void read(String id, Class<?> type, StateStore.ReadResultInterest interest, Object object) {
        if (interest != null) {
            if (id == null || type == null) {
                interest.readResultedIn(Failure.of((Throwable)new StorageException(Result.Error, id == null ? "The id is null." : "The type is null.")), id, null, -1, null, object);
                return;
            }
            String storeName = StateTypeStateStoreMap.storeNameFrom(type);
            if (storeName == null) {
                interest.readResultedIn(Failure.of((Throwable)new StorageException(Result.NoTypeStore, "No type store.")), id, null, -1, null, object);
                return;
            }
            try {
                this.delegate.beginRead();
                PreparedStatement readStatement = (PreparedStatement)this.delegate.readExpressionFor(storeName, id);
                try (ResultSet result = readStatement.executeQuery();){
                    if (result.first()) {
                        State.TextState raw = (State.TextState)this.delegate.stateFrom(result, id);
                        Object state = this.stateAdapterProvider.fromRaw((State)raw);
                        interest.readResultedIn(Success.of((Object)Result.Success), id, state, raw.dataVersion, raw.metadata, object);
                    } else {
                        interest.readResultedIn(Failure.of((Throwable)new StorageException(Result.NotFound, "Not found for: " + id)), id, null, -1, null, object);
                    }
                }
                this.delegate.complete();
            }
            catch (Exception e) {
                this.delegate.fail();
                interest.readResultedIn(Failure.of((Throwable)new StorageException(Result.Failure, e.getMessage(), (Throwable)e)), id, null, -1, null, object);
                this.logger().error(((Object)((Object)this)).getClass().getSimpleName() + " readText() failed because: " + e.getMessage() + " for: " + (id == null ? "unknown id" : id), (Throwable)e);
            }
        } else {
            this.logger().warn(((Object)((Object)this)).getClass().getSimpleName() + " readText() missing ResultInterest for: " + (id == null ? "unknown id" : id));
        }
    }

    public <S, C> void write(String id, S state, int stateVersion, List<Source<C>> sources, Metadata metadata, StateStore.WriteResultInterest interest, Object object) {
        if (interest != null) {
            if (state == null) {
                interest.writeResultedIn(Failure.of((Throwable)new StorageException(Result.Error, "The state is null.")), id, null, stateVersion, sources, object);
            } else {
                try {
                    String storeName = StateTypeStateStoreMap.storeNameFrom(state.getClass());
                    if (storeName == null) {
                        interest.writeResultedIn(Failure.of((Throwable)new StorageException(Result.NoTypeStore, "No type store.")), id, state, stateVersion, sources, object);
                        return;
                    }
                    State.TextState raw = metadata == null ? (State.TextState)this.stateAdapterProvider.asRaw(id, state, stateVersion) : (State.TextState)this.stateAdapterProvider.asRaw(id, state, stateVersion, metadata);
                    this.delegate.beginWrite();
                    PreparedStatement writeStatement = (PreparedStatement)this.delegate.writeExpressionFor(storeName, raw);
                    writeStatement.execute();
                    String dispatchId = storeName + ":" + id;
                    List<Entry<?>> entries = this.appendEntries(sources, stateVersion, metadata);
                    Dispatchable<Entry<?>, State<String>> dispatchable = this.buildDispatchable(dispatchId, (State<String>)raw, entries);
                    PreparedStatement dispatchableStatement = (PreparedStatement)this.delegate.dispatchableWriteExpressionFor(dispatchable);
                    dispatchableStatement.execute();
                    this.delegate.complete();
                    this.dispatch(dispatchable);
                    interest.writeResultedIn(Success.of((Object)Result.Success), id, state, stateVersion, sources, object);
                }
                catch (Exception e) {
                    this.logger().error(((Object)((Object)this)).getClass().getSimpleName() + " writeText() error because: " + e.getMessage(), (Throwable)e);
                    this.delegate.fail();
                    interest.writeResultedIn(Failure.of((Throwable)new StorageException(Result.Error, e.getMessage(), (Throwable)e)), id, state, stateVersion, sources, object);
                }
            }
        } else {
            this.logger().warn(((Object)((Object)this)).getClass().getSimpleName() + " writeText() missing ResultInterest for: " + (state == null ? "unknown id" : id));
        }
    }

    private <C> List<Entry<?>> appendEntries(List<Source<C>> sources, int stateVersion, Metadata metadata) {
        if (sources.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List adapted = this.entryAdapterProvider.asEntries(sources, stateVersion, metadata);
            for (Entry entry : adapted) {
                long id = -1L;
                PreparedStatement appendStatement = (PreparedStatement)this.delegate.appendExpressionFor(entry);
                int count = appendStatement.executeUpdate();
                if (count == 1) {
                    PreparedStatement queryLastIdentityStatement = (PreparedStatement)this.delegate.appendIdentityExpression();
                    try (ResultSet result = queryLastIdentityStatement.executeQuery();){
                        if (result.next()) {
                            id = result.getLong(1);
                            ((BaseEntry)entry).__internal__setId(Long.toString(id));
                        }
                    }
                }
                if (id != -1L) continue;
                String message = "Could not retrieve entry id.";
                this.logger().error("Could not retrieve entry id.");
                throw new IllegalStateException("Could not retrieve entry id.");
            }
            return adapted;
        }
        catch (Exception e) {
            String message = "Failed to append entry because: " + e.getMessage();
            this.logger().error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    private void dispatch(Dispatchable<Entry<?>, State<String>> dispatchable) {
        if (this.dispatcher != null) {
            this.dispatcher.dispatch(dispatchable);
        }
    }

    private Dispatchable<Entry<?>, State<String>> buildDispatchable(String dispatchId, State<String> state, List<Entry<?>> entries) {
        return new Dispatchable(dispatchId, LocalDateTime.now(), (State)state.asTextState(), entries);
    }

    public static class JDBCStateStoreInstantiator
    implements ActorInstantiator<JDBCStateStoreActor> {
        private Dispatcher<Dispatchable<Entry<?>, State<String>>> dispatcher;
        private JDBCStorageDelegate<State.TextState> delegate;

        public JDBCStateStoreInstantiator(Dispatcher<Dispatchable<Entry<?>, State<String>>> dispatcher, JDBCStorageDelegate<State.TextState> delegate) {
            this.dispatcher = dispatcher;
            this.delegate = delegate;
        }

        public JDBCStateStoreInstantiator() {
        }

        public JDBCStateStoreActor instantiate() {
            return new JDBCStateStoreActor(this.dispatcher, this.delegate);
        }

        public Class<JDBCStateStoreActor> type() {
            return JDBCStateStoreActor.class;
        }

        public void set(String name, Object value) {
            switch (name) {
                case "dispatcher": {
                    this.dispatcher = (Dispatcher)value;
                    break;
                }
                case "delegate": {
                    this.delegate = (JDBCStorageDelegate)value;
                }
            }
        }
    }
}

