/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.jdbc;

import io.vlingo.actors.Logger;
import io.vlingo.common.Tuple2;
import io.vlingo.common.serialization.JsonSerialization;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.DataFormat;
import io.vlingo.symbio.store.common.jdbc.CachedStatement;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.DispatcherControl;
import io.vlingo.symbio.store.state.StateStore;
import io.vlingo.symbio.store.state.StateTypeStateStoreMap;
import io.vlingo.symbio.store.state.jdbc.JDBCDispatchableCachedStatements;
import io.vlingo.symbio.store.state.jdbc.Mode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class JDBCStorageDelegate<T>
implements StateStore.StorageDelegate,
DispatcherControl.DispatcherControlDelegate<Entry<?>, State<?>> {
    private static final String DISPATCHEABLE_ENTRIES_DELIMITER = "|";
    protected final Connection connection;
    protected final JDBCDispatchableCachedStatements<T> dispatchableCachedStatements;
    protected final DataFormat format;
    protected final Logger logger;
    protected Mode mode;
    protected final String originatorId;
    protected final Map<String, CachedStatement<T>> readStatements;
    protected final Map<String, CachedStatement<T>> writeStatements;

    protected JDBCStorageDelegate(Connection connection, DataFormat format, String originatorId, boolean createTables, Logger logger) {
        this.connection = connection;
        this.format = format;
        this.originatorId = originatorId;
        this.logger = logger;
        this.mode = Mode.None;
        if (createTables) {
            this.createTables();
        }
        this.dispatchableCachedStatements = this.dispatchableCachedStatements();
        this.readStatements = new HashMap<String, CachedStatement<T>>();
        this.writeStatements = new HashMap<String, CachedStatement<T>>();
    }

    public <A, E> A appendExpressionFor(Entry<E> entry) throws Exception {
        CachedStatement<T> cachedStatement = this.dispatchableCachedStatements.appendEntryStatement();
        this.prepareForAppend(cachedStatement, entry);
        return (A)cachedStatement.preparedStatement;
    }

    public <A> A appendIdentityExpression() {
        CachedStatement<T> cachedStatement = this.dispatchableCachedStatements.appendEntryIdentityStatement();
        return (A)cachedStatement.preparedStatement;
    }

    public Collection<Dispatchable<Entry<?>, State<?>>> allUnconfirmedDispatchableStates() throws Exception {
        ArrayList dispatchables = new ArrayList();
        try (ResultSet result = this.dispatchableCachedStatements.queryAllStatement().preparedStatement.executeQuery();){
            while (result.next()) {
                Dispatchable dispatchable = this.dispatchableFrom(result);
                dispatchables.add(dispatchable);
            }
        }
        return dispatchables;
    }

    public void beginRead() {
        if (this.mode != Mode.None) {
            this.logger.warn(this.getClass().getSimpleName() + ": Cannot begin read because currently: " + this.mode.name());
        } else {
            this.mode = Mode.Reading;
        }
    }

    public void beginWrite() throws Exception {
        if (this.mode != Mode.None) {
            this.logger.warn(this.getClass().getSimpleName() + ": Cannot begin write because currently: " + this.mode.name());
        } else {
            this.mode = Mode.Writing;
        }
    }

    public void stop() {
        this.close();
    }

    public void close() {
        try {
            this.mode = Mode.None;
            Connection connection = (Connection)this.connection();
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            this.logger.error(this.getClass().getSimpleName() + ": Could not close because: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isClosed() {
        try {
            return this.connection == null || this.connection.isClosed();
        }
        catch (SQLException ex) {
            return true;
        }
    }

    public void complete() throws Exception {
        this.mode = Mode.None;
        this.connection.commit();
    }

    public <C> C connection() {
        return (C)this.connection;
    }

    public void confirmDispatched(String dispatchId) {
        try {
            this.beginWrite();
            this.dispatchableCachedStatements.deleteStatement().preparedStatement.clearParameters();
            this.dispatchableCachedStatements.deleteStatement().preparedStatement.setString(1, dispatchId);
            this.dispatchableCachedStatements.deleteStatement().preparedStatement.executeUpdate();
            this.complete();
        }
        catch (Exception e) {
            this.fail();
            this.logger.error(this.getClass().getSimpleName() + ": Confirm dispatched for: " + dispatchId + " failed because: " + e.getMessage(), (Throwable)e);
        }
    }

    public <W, S> W dispatchableWriteExpressionFor(Dispatchable<Entry<?>, State<S>> dispatchable) throws Exception {
        PreparedStatement preparedStatement = this.dispatchableCachedStatements.appendDispatchableStatement().preparedStatement;
        State state = dispatchable.typedState();
        preparedStatement.clearParameters();
        preparedStatement.setObject(1, Timestamp.valueOf(dispatchable.createdOn()));
        preparedStatement.setString(2, this.originatorId);
        preparedStatement.setString(3, dispatchable.id());
        preparedStatement.setString(4, state.id);
        preparedStatement.setString(5, state.type);
        preparedStatement.setInt(6, state.typeVersion);
        if (this.format.isBinary()) {
            this.setBinaryObject(this.dispatchableCachedStatements.appendDispatchableStatement(), 7, state);
        } else if (state.isText()) {
            this.setTextObject(this.dispatchableCachedStatements.appendDispatchableStatement(), 7, state);
        }
        preparedStatement.setInt(8, state.dataVersion);
        preparedStatement.setString(9, state.metadata.value);
        preparedStatement.setString(10, state.metadata.operation);
        Tuple2<String, String> metadataObject = this.serialized(state.metadata.object);
        preparedStatement.setString(11, (String)metadataObject._1);
        preparedStatement.setString(12, (String)metadataObject._2);
        if (dispatchable.entries() != null && !dispatchable.entries().isEmpty()) {
            preparedStatement.setString(13, dispatchable.entries().stream().map(Entry::id).collect(Collectors.joining(DISPATCHEABLE_ENTRIES_DELIMITER)));
        } else {
            preparedStatement.setString(13, "");
        }
        return (W)preparedStatement;
    }

    private <S extends State<?>> Dispatchable<Entry<?>, S> dispatchableFrom(ResultSet resultSet) throws Exception {
        State.BinaryState state;
        Object data;
        LocalDateTime createdAt = resultSet.getTimestamp(1).toLocalDateTime();
        String dispatchId = resultSet.getString(2);
        String id = resultSet.getString(3);
        Class<?> type = Class.forName(resultSet.getString(4));
        int typeVersion = resultSet.getInt(5);
        int dataVersion = resultSet.getInt(7);
        String metadataValue = resultSet.getString(8);
        String metadataOperation = resultSet.getString(9);
        String metadataObject = resultSet.getString(10);
        String metadataObjectType = resultSet.getString(11);
        Object object = metadataObject != null ? JsonSerialization.deserialized((String)metadataObject, Class.forName(metadataObjectType)) : null;
        Metadata metadata = Metadata.with((Object)object, (String)metadataValue, (String)metadataOperation);
        if (this.format.isBinary()) {
            data = this.binaryDataFrom(resultSet, 6);
            state = new State.BinaryState(id, type, typeVersion, data, dataVersion, metadata);
        } else {
            data = this.textDataFrom(resultSet, 6);
            state = new State.TextState(id, type, typeVersion, (String)data, dataVersion, metadata);
        }
        String entriesIds = resultSet.getString(12);
        ArrayList entries = new ArrayList();
        if (entriesIds != null && !entriesIds.isEmpty()) {
            String[] ids;
            for (String entryId : ids = entriesIds.split("\\|")) {
                PreparedStatement queryEntryStatement = this.dispatchableCachedStatements.getQueryEntry().preparedStatement;
                queryEntryStatement.clearParameters();
                queryEntryStatement.setObject(1, Long.valueOf(entryId));
                queryEntryStatement.executeQuery();
                try (ResultSet result = queryEntryStatement.executeQuery();){
                    if (result.next()) {
                        entries.add(this.entryFrom(result, entryId));
                    }
                }
                this.dispatchableCachedStatements.getQueryEntry().preparedStatement.clearParameters();
            }
        }
        return new Dispatchable(dispatchId, createdAt, (State)state, entries);
    }

    private Entry<?> entryFrom(ResultSet result, String id) throws Exception {
        String type = result.getString(2);
        int typeVersion = result.getInt(3);
        String metadataValue = result.getString(5);
        String metadataOperation = result.getString(6);
        Metadata metadata = Metadata.with((String)metadataValue, (String)metadataOperation);
        if (this.format.isBinary()) {
            return new BaseEntry.BinaryEntry(id, Entry.typed((String)type), typeVersion, this.binaryDataFrom(result, 4), metadata);
        }
        return new BaseEntry.TextEntry(id, Entry.typed((String)type), typeVersion, this.textDataFrom(result, 4), metadata);
    }

    public void fail() {
        try {
            this.mode = Mode.None;
            this.connection.rollback();
        }
        catch (Exception e) {
            this.logger.error(this.getClass().getSimpleName() + ": Rollback failed because: " + e.getMessage(), (Throwable)e);
        }
    }

    public String originatorId() {
        return this.originatorId;
    }

    public <R> R readExpressionFor(String storeName, String id) throws Exception {
        CachedStatement<T> maybeCached = this.readStatements.get(storeName);
        if (maybeCached == null) {
            String select = this.readExpression(storeName, id);
            PreparedStatement preparedStatement = this.connection.prepareStatement(select);
            CachedStatement<Object> cached = new CachedStatement<Object>(preparedStatement, null);
            this.readStatements.put(storeName, cached);
            this.prepareForRead(cached, id);
            return (R)preparedStatement;
        }
        this.prepareForRead(maybeCached, id);
        return (R)maybeCached.preparedStatement;
    }

    public <S> S session() throws Exception {
        return null;
    }

    public <S, R> S stateFrom(R result, String id) throws Exception {
        ResultSet resultSet = (ResultSet)result;
        if (!resultSet.next()) {
            return (S)(this.format.isBinary() ? new State.BinaryState() : new State.TextState());
        }
        Class<?> type = Class.forName(resultSet.getString(1));
        int typeVersion = resultSet.getInt(2);
        int dataVersion = resultSet.getInt(4);
        String metadataValue = resultSet.getString(5);
        String metadataOperation = resultSet.getString(6);
        Metadata metadata = Metadata.with((String)metadataValue, (String)metadataOperation);
        if (this.format.isBinary()) {
            byte[] data = this.binaryDataFrom(resultSet, 3);
            return (S)new State.BinaryState(id, type, typeVersion, data, dataVersion, metadata);
        }
        String data = this.textDataFrom(resultSet, 3);
        return (S)new State.TextState(id, type, typeVersion, data, dataVersion, metadata);
    }

    public <W, S> W writeExpressionFor(String storeName, State<S> state) throws Exception {
        CachedStatement<T> maybeCached = this.writeStatements.get(storeName);
        if (maybeCached == null) {
            String upsert = this.writeExpression(storeName);
            PreparedStatement preparedStatement = this.connection.prepareStatement(upsert);
            CachedStatement cached = new CachedStatement(preparedStatement, this.binaryDataTypeObject());
            this.writeStatements.put(storeName, cached);
            this.prepareForWrite(cached, state);
            return (W)cached.preparedStatement;
        }
        this.prepareForWrite(maybeCached, state);
        return (W)maybeCached.preparedStatement;
    }

    protected abstract byte[] binaryDataFrom(ResultSet var1, int var2) throws Exception;

    protected abstract <D> D binaryDataTypeObject() throws Exception;

    protected abstract JDBCDispatchableCachedStatements<T> dispatchableCachedStatements();

    protected abstract String dispatchableIdIndexCreateExpression();

    protected abstract String dispatchableOriginatorIdIndexCreateExpression();

    protected abstract String dispatchableTableCreateExpression();

    protected abstract String dispatchableTableName();

    protected abstract String entryTableCreateExpression();

    protected abstract String entryTableName();

    protected abstract String entryOffsetsTableName();

    protected abstract String entryOffsetsTableCreateExpression();

    protected abstract String readExpression(String var1, String var2);

    protected abstract <S> void setBinaryObject(CachedStatement<T> var1, int var2, State<S> var3) throws Exception;

    protected abstract <E> void setBinaryObject(CachedStatement<T> var1, int var2, Entry<E> var3) throws Exception;

    protected abstract <S> void setTextObject(CachedStatement<T> var1, int var2, State<S> var3) throws Exception;

    protected abstract <E> void setTextObject(CachedStatement<T> var1, int var2, Entry<E> var3) throws Exception;

    protected abstract String stateStoreTableCreateExpression(String var1);

    protected abstract String tableNameFor(String var1);

    protected abstract String textDataFrom(ResultSet var1, int var2) throws Exception;

    protected abstract String writeExpression(String var1);

    private void createDispatchablesTable() throws Exception {
        String tableName = this.dispatchableTableName();
        if (!this.tableExists(tableName)) {
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate(this.dispatchableTableCreateExpression());
                statement.executeUpdate(this.dispatchableIdIndexCreateExpression());
                statement.executeUpdate(this.dispatchableOriginatorIdIndexCreateExpression());
                this.connection.commit();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot create table " + tableName + " because: " + e, e);
            }
        }
    }

    private void createEntryTable() throws Exception {
        String tableName = this.entryTableName();
        if (!this.tableExists(tableName)) {
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate(this.entryTableCreateExpression());
                this.connection.commit();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot create table " + tableName + " because: " + e, e);
            }
        }
    }

    private void createEntryOffsetsTable() throws Exception {
        String tableName = this.entryOffsetsTableName();
        if (!this.tableExists(tableName)) {
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate(this.entryOffsetsTableCreateExpression());
                this.connection.commit();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot create table " + tableName + " because: " + e, e);
            }
        }
    }

    private void createStateStoreTable(String tableName) throws Exception {
        String sql = this.stateStoreTableCreateExpression(tableName);
        try (Statement statement = this.connection.createStatement();){
            statement.executeUpdate(sql);
            this.connection.commit();
        }
    }

    private void createTables() {
        try {
            this.createDispatchablesTable();
        }
        catch (Exception e) {
            this.logger.error("Could not create dispatchables table because: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.createEntryTable();
        }
        catch (Exception e) {
            this.logger.error("Could not create entry table because: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.createEntryOffsetsTable();
        }
        catch (Exception e) {
            this.logger.error("Could not create entry table because: " + e.getMessage(), (Throwable)e);
        }
        for (String storeName : StateTypeStateStoreMap.allStoreNames()) {
            String tableName = this.tableNameFor(storeName);
            try {
                if (this.tableExists(tableName)) continue;
                this.createStateStoreTable(tableName);
            }
            catch (Exception e) {
                this.logger.error("Could not create " + tableName + " table because: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void prepareForRead(CachedStatement<T> cached, String id) throws Exception {
        cached.preparedStatement.clearParameters();
        cached.preparedStatement.setString(1, id);
    }

    private <E> void prepareForAppend(CachedStatement<T> cached, Entry<E> entry) throws Exception {
        cached.preparedStatement.clearParameters();
        cached.preparedStatement.setString(1, entry.typeName());
        cached.preparedStatement.setInt(2, entry.typeVersion());
        if (this.format.isBinary()) {
            this.setBinaryObject(cached, 3, entry);
        } else if (this.format.isText()) {
            this.setTextObject(cached, 3, entry);
        }
        cached.preparedStatement.setString(4, entry.metadata().value);
        cached.preparedStatement.setString(5, entry.metadata().operation);
    }

    private <S> void prepareForWrite(CachedStatement<T> cached, State<S> state) throws Exception {
        cached.preparedStatement.clearParameters();
        cached.preparedStatement.setString(1, state.id);
        cached.preparedStatement.setString(2, state.type);
        cached.preparedStatement.setInt(3, state.typeVersion);
        if (this.format.isBinary()) {
            this.setBinaryObject(cached, 4, state);
        } else if (state.isText()) {
            this.setTextObject(cached, 4, state);
        }
        cached.preparedStatement.setInt(5, state.dataVersion);
        cached.preparedStatement.setString(6, state.metadata.value);
        cached.preparedStatement.setString(7, state.metadata.operation);
    }

    private Tuple2<String, String> serialized(Object object) {
        if (object != null) {
            return Tuple2.from((Object)JsonSerialization.serialized((Object)object), (Object)object.getClass().getName());
        }
        return Tuple2.from(null, null);
    }

    private boolean tableExists(String tableName) throws Exception {
        DatabaseMetaData metadata = this.connection.getMetaData();
        try (ResultSet resultSet = metadata.getTables(null, null, tableName, null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }
}

