/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.jdbc.hsqldb;

public interface HSQLDBQueries {
    public static final String SQL_STATE_READ = "SELECT TBL_{0}.S_TYPE, TBL_{0}.S_TYPE_VERSION, TBL_{0}.S_DATA, TBL_{0}.S_DATA_VERSION, TBL_{0}.S_METADATA_VALUE, TBL_{0}.S_METADATA_OP FROM TBL_{0} WHERE TBL_{0}.S_ID = ?";
    public static final String SQL_STATE_WRITE = "MERGE INTO TBL_{0} \nUSING (VALUES ?, ?, ?, {1}, ?, ?, ?) \nS (S_ID, S_TYPE, S_TYPE_VERSION, S_DATA, S_DATA_VERSION, S_METADATA_OP, S_METADATA_VALUE) \nON (TBL_{0}.S_ID = S.S_ID) \nWHEN MATCHED THEN UPDATE \nSET TBL_{0}.S_TYPE = S.S_TYPE, \n    TBL_{0}.S_TYPE_VERSION = S.S_TYPE_VERSION, \n    TBL_{0}.S_DATA = S.S_DATA, \n    TBL_{0}.S_DATA_VERSION = S.S_DATA_VERSION, \n    TBL_{0}.S_METADATA_OP = S.S_METADATA_OP, \n    TBL_{0}.S_METADATA_VALUE = S.S_METADATA_VALUE \nWHEN NOT MATCHED THEN INSERT \n(S_ID, S_TYPE, S_TYPE_VERSION, S_DATA, S_DATA_VERSION, S_METADATA_OP, S_METADATA_VALUE) \nVALUES (S.S_ID, S.S_TYPE, S.S_TYPE_VERSION, S.S_DATA, S.S_DATA_VERSION, S.S_METADATA_VALUE, S.S_METADATA_OP)";
    public static final String SQL_FORMAT_BINARY_CAST = "CAST(? AS VARBINARY(65535))";
    public static final String SQL_FORMAT_TEXT_CAST = "CAST(? AS LONGVARCHAR(65535))";
    public static final String TBL_VLINGO_SYMBIO_DISPATCHABLES = "TBL_VLINGO_SYMBIO_DISPATCHABLES";
    public static final String SQL_CREATE_DISPATCHABLES_STORE = "CREATE TABLE {0} (\n   D_ID BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,   D_CREATED_AT TIMESTAMP NOT NULL,   D_ORIGINATOR_ID VARCHAR(32) NOT NULL,   D_DISPATCH_ID VARCHAR(128) NOT NULL,\n   D_STATE_ID VARCHAR(128) NOT NULL, \n   D_STATE_TYPE VARCHAR(256) NOT NULL,\n   D_STATE_TYPE_VERSION INT NOT NULL,\n   D_STATE_DATA {1} NOT NULL,\n   D_STATE_DATA_VERSION INT NOT NULL,\n   D_STATE_METADATA_VALUE VARCHAR(4000) NOT NULL,\n   D_STATE_METADATA_OP VARCHAR(128) NOT NULL,\n   D_STATE_METADATA_OBJECT LONGVARCHAR(65535),\n   D_STATE_METADATA_OBJECT_TYPE VARCHAR(256),\n   D_ENTRIES LONGVARCHAR(65535)\n);";
    public static final String SQL_DISPATCH_ID_INDEX = "CREATE INDEX IDX_DISPATCHABLES_DISPATCH_ID \nON {0} (D_DISPATCH_ID);";
    public static final String SQL_ORIGINATOR_ID_INDEX = "CREATE INDEX IDX_DISPATCHABLES_ORIGINATOR_ID \nON {0} (D_ORIGINATOR_ID);";
    public static final String SQL_CREATE_STATE_STORE = "CREATE TABLE {0} (\n   S_ID VARCHAR(128) NOT NULL,\n   S_TYPE VARCHAR(256) NOT NULL,\n   S_TYPE_VERSION INT NOT NULL,\n   S_DATA {1} NOT NULL,\n   S_DATA_VERSION INT NOT NULL,\n   S_METADATA_VALUE VARCHAR(4000) NOT NULL,\n   S_METADATA_OP VARCHAR(128) NOT NULL,\n   PRIMARY KEY (S_ID) \n);";
    public static final String SQL_FORMAT_TEXT = "LONGVARCHAR(65535)";
    public static final String SQL_FORMAT_BINARY = "VARBINARY(65535)";
    public static final String SQL_DISPATCHABLE_APPEND = "INSERT INTO {0} \n(D_ID, D_CREATED_AT, D_ORIGINATOR_ID, D_DISPATCH_ID, \n D_STATE_ID, D_STATE_TYPE, D_STATE_TYPE_VERSION, \n D_STATE_DATA, D_STATE_DATA_VERSION, \n D_STATE_METADATA_VALUE, D_STATE_METADATA_OP, D_STATE_METADATA_OBJECT, D_STATE_METADATA_OBJECT_TYPE, D_ENTRIES) \nVALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String SQL_DISPATCHABLE_DELETE = "DELETE FROM {0} WHERE D_DISPATCH_ID = ?";
    public static final String SQL_DISPATCHABLE_SELECT = "SELECT D_CREATED_AT, D_DISPATCH_ID, D_STATE_ID, D_STATE_TYPE, D_STATE_TYPE_VERSION, D_STATE_DATA, D_STATE_DATA_VERSION, \n       D_STATE_METADATA_VALUE, D_STATE_METADATA_OP, D_STATE_METADATA_OBJECT, D_STATE_METADATA_OBJECT_TYPE, D_ENTRIES\nFROM {0} \nWHERE D_ORIGINATOR_ID = ? ORDER BY D_CREATED_AT ASC";
    public static final String SQL_CREATE_ENTRY_STORE = "CREATE TABLE {0} (\n   E_ID BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,   E_TYPE VARCHAR(256) NOT NULL,\n   E_TYPE_VERSION INT NOT NULL,\n   E_DATA {1} NOT NULL,\n   E_METADATA_VALUE VARCHAR(4000) NULL,\n   E_METADATA_OP VARCHAR(128) NULL\n);";
    public static final String TBL_VLINGO_SYMBIO_STATE_ENTRY = "TBL_VLINGO_SYMBIO_STATE_ENTRY";
    public static final String SQL_CREATE_ENTRY_STORE_OFFSETS = "CREATE TABLE {0} (\n   O_READER_NAME VARCHAR(128) PRIMARY KEY,   O_READER_OFFSET BIGINT NOT NULL\n);";
    public static final String TBL_VLINGO_SYMBIO_STATE_ENTRY_OFFSETS = "TBL_VLINGO_SYMBIO_STATE_ENTRY_OFFSETS";
    public static final String SQL_APPEND_ENTRY = "INSERT INTO {0} \n(E_TYPE, E_TYPE_VERSION, E_DATA, E_METADATA_VALUE, E_METADATA_OP) \nVALUES (?, ?, ?, ?, ?)";
    public static final String SQL_APPEND_ENTRY_IDENTITY = "CALL IDENTITY()";
    public static final String SQL_QUERY_ENTRY_BATCH = "SELECT E_ID, E_TYPE, E_TYPE_VERSION, E_DATA, E_METADATA_VALUE, E_METADATA_OP FROM  {0} WHERE E_ID >= ? ORDER BY E_ID LIMIT ?";
    public static final String SQL_QUERY_ENTRY = "SELECT E_ID, E_TYPE, E_TYPE_VERSION, E_DATA, E_METADATA_VALUE, E_METADATA_OP FROM  {0} WHERE E_ID = ?";
    public static final String QUERY_LATEST_OFFSET = "SELECT O_READER_OFFSET FROM {0} WHERE O_READER_NAME = ?";
    public static final String QUERY_COUNT = "SELECT COUNT(*) FROM {0}";
    public static final String UPDATE_CURRENT_OFFSET = "MERGE INTO {0} \nUSING (VALUES ?, ?) \n O (O_READER_NAME, O_READER_OFFSET) \nON ({0}.O_READER_NAME = O.O_READER_NAME) \nWHEN MATCHED THEN UPDATE \nSET {0}.O_READER_OFFSET = O.O_READER_OFFSET \nWHEN NOT MATCHED THEN INSERT \n(O_READER_NAME, O_READER_OFFSET) \nVALUES (O.O_READER_NAME, O.O_READER_OFFSET)";
}

