/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.jdbc.hsqldb;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Logger;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.DataFormat;
import io.vlingo.symbio.store.EntryReader;
import io.vlingo.symbio.store.common.jdbc.CachedStatement;
import io.vlingo.symbio.store.common.jdbc.Configuration;
import io.vlingo.symbio.store.state.StateStore;
import io.vlingo.symbio.store.state.jdbc.JDBCDispatchableCachedStatements;
import io.vlingo.symbio.store.state.jdbc.JDBCStorageDelegate;
import io.vlingo.symbio.store.state.jdbc.hsqldb.HSQLDBQueries;
import io.vlingo.symbio.store.state.jdbc.hsqldb.HSQLDBStateStoreEntryReaderActor;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;

public class HSQLDBStorageDelegate
extends JDBCStorageDelegate<Blob>
implements StateStore.StorageDelegate,
HSQLDBQueries {
    private final Configuration configuration;

    public HSQLDBStorageDelegate(Configuration configuration, Logger logger) {
        super(configuration.connection, configuration.format, configuration.originatorId, configuration.createTables, logger);
        this.configuration = configuration;
    }

    public StateStore.StorageDelegate copy() {
        try {
            return new HSQLDBStorageDelegate(Configuration.cloneOf(this.configuration), this.logger);
        }
        catch (Exception e) {
            String message = "Copy of PostgresStorageDelegate failed because: " + e.getMessage();
            this.logger.error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public EntryReader.Advice entryReaderAdvice() {
        try {
            return new EntryReader.Advice((Object)Configuration.cloneOf(this.configuration), HSQLDBStateStoreEntryReaderActor.class, this.namedEntry("SELECT E_ID, E_TYPE, E_TYPE_VERSION, E_DATA, E_METADATA_VALUE, E_METADATA_OP FROM  {0} WHERE E_ID >= ? ORDER BY E_ID LIMIT ?"), this.namedEntry("SELECT E_ID, E_TYPE, E_TYPE_VERSION, E_DATA, E_METADATA_VALUE, E_METADATA_OP FROM  {0} WHERE E_ID = ?"), this.namedEntry("SELECT COUNT(*) FROM {0}"), this.namedEntryOffsets("SELECT O_READER_OFFSET FROM {0} WHERE O_READER_NAME = ?"), this.namedEntryOffsets("MERGE INTO {0} \nUSING (VALUES ?, ?) \n O (O_READER_NAME, O_READER_OFFSET) \nON ({0}.O_READER_NAME = O.O_READER_NAME) \nWHEN MATCHED THEN UPDATE \nSET {0}.O_READER_OFFSET = O.O_READER_OFFSET \nWHEN NOT MATCHED THEN INSERT \n(O_READER_NAME, O_READER_OFFSET) \nVALUES (O.O_READER_NAME, O.O_READER_OFFSET)"));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create EntryReader.Advice because: " + e.getMessage(), e);
        }
    }

    public <A extends Actor> ActorInstantiator<A> instantiator() {
        return new HSQLDBStateStoreEntryReaderActor.HSQLDBStateStoreEntryReaderInstantiator();
    }

    @Override
    protected byte[] binaryDataFrom(ResultSet resultSet, int columnIndex) throws Exception {
        Blob blob = resultSet.getBlob(columnIndex);
        byte[] data = blob.getBytes(1L, (int)blob.length());
        return data;
    }

    @Override
    protected <D> D binaryDataTypeObject() throws Exception {
        return (D)this.connection.createBlob();
    }

    @Override
    protected JDBCDispatchableCachedStatements<Blob> dispatchableCachedStatements() {
        return new HSQLDBDispatchableCachedStatements(this.originatorId, this.connection, this.format, this.logger);
    }

    @Override
    protected String dispatchableIdIndexCreateExpression() {
        return this.namedDispatchable("CREATE INDEX IDX_DISPATCHABLES_DISPATCH_ID \nON {0} (D_DISPATCH_ID);");
    }

    @Override
    protected String dispatchableOriginatorIdIndexCreateExpression() {
        return this.namedDispatchable("CREATE INDEX IDX_DISPATCHABLES_ORIGINATOR_ID \nON {0} (D_ORIGINATOR_ID);");
    }

    @Override
    protected String dispatchableTableCreateExpression() {
        return MessageFormat.format("CREATE TABLE {0} (\n   D_ID BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,   D_CREATED_AT TIMESTAMP NOT NULL,   D_ORIGINATOR_ID VARCHAR(32) NOT NULL,   D_DISPATCH_ID VARCHAR(128) NOT NULL,\n   D_STATE_ID VARCHAR(128) NOT NULL, \n   D_STATE_TYPE VARCHAR(256) NOT NULL,\n   D_STATE_TYPE_VERSION INT NOT NULL,\n   D_STATE_DATA {1} NOT NULL,\n   D_STATE_DATA_VERSION INT NOT NULL,\n   D_STATE_METADATA_VALUE VARCHAR(4000) NOT NULL,\n   D_STATE_METADATA_OP VARCHAR(128) NOT NULL,\n   D_STATE_METADATA_OBJECT LONGVARCHAR(65535),\n   D_STATE_METADATA_OBJECT_TYPE VARCHAR(256),\n   D_ENTRIES LONGVARCHAR(65535)\n);", this.dispatchableTableName(), this.format.isBinary() ? "VARBINARY(65535)" : "LONGVARCHAR(65535)");
    }

    @Override
    protected String dispatchableTableName() {
        return "TBL_VLINGO_SYMBIO_DISPATCHABLES";
    }

    @Override
    protected String entryTableCreateExpression() {
        return MessageFormat.format("CREATE TABLE {0} (\n   E_ID BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,   E_TYPE VARCHAR(256) NOT NULL,\n   E_TYPE_VERSION INT NOT NULL,\n   E_DATA {1} NOT NULL,\n   E_METADATA_VALUE VARCHAR(4000) NULL,\n   E_METADATA_OP VARCHAR(128) NULL\n);", this.entryTableName(), this.format.isBinary() ? "VARBINARY(65535)" : "LONGVARCHAR(65535)");
    }

    @Override
    protected String entryOffsetsTableCreateExpression() {
        return MessageFormat.format("CREATE TABLE {0} (\n   O_READER_NAME VARCHAR(128) PRIMARY KEY,   O_READER_OFFSET BIGINT NOT NULL\n);", this.entryOffsetsTableName(), this.format.isBinary() ? "VARBINARY(65535)" : "LONGVARCHAR(65535)");
    }

    @Override
    protected String entryTableName() {
        return "TBL_VLINGO_SYMBIO_STATE_ENTRY";
    }

    @Override
    protected String entryOffsetsTableName() {
        return "TBL_VLINGO_SYMBIO_STATE_ENTRY_OFFSETS";
    }

    @Override
    protected String readExpression(String storeName, String id) {
        return MessageFormat.format("SELECT TBL_{0}.S_TYPE, TBL_{0}.S_TYPE_VERSION, TBL_{0}.S_DATA, TBL_{0}.S_DATA_VERSION, TBL_{0}.S_METADATA_VALUE, TBL_{0}.S_METADATA_OP FROM TBL_{0} WHERE TBL_{0}.S_ID = ?", storeName.toUpperCase());
    }

    @Override
    protected <S> void setBinaryObject(CachedStatement<Blob> cached, int columnIndex, State<S> state) throws Exception {
        byte[] data = (byte[])state.data;
        ((Blob)cached.data).setBytes(1L, data);
        cached.preparedStatement.setBlob(columnIndex, (Blob)cached.data);
    }

    @Override
    protected <E> void setBinaryObject(CachedStatement<Blob> cached, int columnIndex, Entry<E> entry) throws Exception {
        byte[] data = (byte[])entry.entryData();
        ((Blob)cached.data).setBytes(1L, data);
        cached.preparedStatement.setBlob(columnIndex, (Blob)cached.data);
    }

    @Override
    protected <S> void setTextObject(CachedStatement<Blob> cached, int columnIndex, State<S> state) throws Exception {
        cached.preparedStatement.setString(columnIndex, (String)state.data);
    }

    @Override
    protected <E> void setTextObject(CachedStatement<Blob> cached, int columnIndex, Entry<E> entry) throws Exception {
        cached.preparedStatement.setString(columnIndex, (String)entry.entryData());
    }

    @Override
    protected String stateStoreTableCreateExpression(String tableName) {
        return MessageFormat.format("CREATE TABLE {0} (\n   S_ID VARCHAR(128) NOT NULL,\n   S_TYPE VARCHAR(256) NOT NULL,\n   S_TYPE_VERSION INT NOT NULL,\n   S_DATA {1} NOT NULL,\n   S_DATA_VERSION INT NOT NULL,\n   S_METADATA_VALUE VARCHAR(4000) NOT NULL,\n   S_METADATA_OP VARCHAR(128) NOT NULL,\n   PRIMARY KEY (S_ID) \n);", tableName, this.format.isBinary() ? "VARBINARY(65535)" : "LONGVARCHAR(65535)");
    }

    @Override
    protected String tableNameFor(String storeName) {
        return "TBL_" + storeName.toUpperCase();
    }

    @Override
    protected String textDataFrom(ResultSet resultSet, int columnIndex) throws Exception {
        String data = resultSet.getString(columnIndex);
        return data;
    }

    @Override
    protected String writeExpression(String storeName) {
        return MessageFormat.format("MERGE INTO TBL_{0} \nUSING (VALUES ?, ?, ?, {1}, ?, ?, ?) \nS (S_ID, S_TYPE, S_TYPE_VERSION, S_DATA, S_DATA_VERSION, S_METADATA_OP, S_METADATA_VALUE) \nON (TBL_{0}.S_ID = S.S_ID) \nWHEN MATCHED THEN UPDATE \nSET TBL_{0}.S_TYPE = S.S_TYPE, \n    TBL_{0}.S_TYPE_VERSION = S.S_TYPE_VERSION, \n    TBL_{0}.S_DATA = S.S_DATA, \n    TBL_{0}.S_DATA_VERSION = S.S_DATA_VERSION, \n    TBL_{0}.S_METADATA_OP = S.S_METADATA_OP, \n    TBL_{0}.S_METADATA_VALUE = S.S_METADATA_VALUE \nWHEN NOT MATCHED THEN INSERT \n(S_ID, S_TYPE, S_TYPE_VERSION, S_DATA, S_DATA_VERSION, S_METADATA_OP, S_METADATA_VALUE) \nVALUES (S.S_ID, S.S_TYPE, S.S_TYPE_VERSION, S.S_DATA, S.S_DATA_VERSION, S.S_METADATA_VALUE, S.S_METADATA_OP)", storeName.toUpperCase(), this.format.isBinary() ? "CAST(? AS VARBINARY(65535))" : "CAST(? AS LONGVARCHAR(65535))");
    }

    private String namedDispatchable(String sql) {
        return MessageFormat.format(sql, this.dispatchableTableName());
    }

    private String namedEntry(String sql) {
        return MessageFormat.format(sql, this.entryTableName());
    }

    private String namedEntryOffsets(String sql) {
        String formatted = MessageFormat.format(sql, this.entryOffsetsTableName());
        return formatted;
    }

    private static Blob blobIfBinary(Connection connection, DataFormat format, Logger logger) {
        try {
            return format.isBinary() ? connection.createBlob() : null;
        }
        catch (SQLException e) {
            String message = HSQLDBDispatchableCachedStatements.class.getSimpleName() + ": Failed to create blob because: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new IllegalStateException(message);
        }
    }

    class HSQLDBDispatchableCachedStatements
    extends JDBCDispatchableCachedStatements<Blob> {
        HSQLDBDispatchableCachedStatements(String originatorId, Connection connection, DataFormat format, Logger logger) {
            super(originatorId, connection, format, HSQLDBStorageDelegate.blobIfBinary(connection, format, logger), logger);
        }

        @Override
        protected String appendDispatchableExpression() {
            return HSQLDBStorageDelegate.this.namedDispatchable("INSERT INTO {0} \n(D_ID, D_CREATED_AT, D_ORIGINATOR_ID, D_DISPATCH_ID, \n D_STATE_ID, D_STATE_TYPE, D_STATE_TYPE_VERSION, \n D_STATE_DATA, D_STATE_DATA_VERSION, \n D_STATE_METADATA_VALUE, D_STATE_METADATA_OP, D_STATE_METADATA_OBJECT, D_STATE_METADATA_OBJECT_TYPE, D_ENTRIES) \nVALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }

        @Override
        protected String appendEntryExpression() {
            return HSQLDBStorageDelegate.this.namedEntry("INSERT INTO {0} \n(E_TYPE, E_TYPE_VERSION, E_DATA, E_METADATA_VALUE, E_METADATA_OP) \nVALUES (?, ?, ?, ?, ?)");
        }

        @Override
        protected String queryEntryExpression() {
            return HSQLDBStorageDelegate.this.namedEntry("SELECT E_ID, E_TYPE, E_TYPE_VERSION, E_DATA, E_METADATA_VALUE, E_METADATA_OP FROM  {0} WHERE E_ID = ?");
        }

        @Override
        protected String appendEntryIdentityExpression() {
            return "CALL IDENTITY()";
        }

        @Override
        protected String deleteDispatchableExpression() {
            return HSQLDBStorageDelegate.this.namedDispatchable("DELETE FROM {0} WHERE D_DISPATCH_ID = ?");
        }

        @Override
        protected String selectDispatchableExpression() {
            return HSQLDBStorageDelegate.this.namedDispatchable("SELECT D_CREATED_AT, D_DISPATCH_ID, D_STATE_ID, D_STATE_TYPE, D_STATE_TYPE_VERSION, D_STATE_DATA, D_STATE_DATA_VERSION, \n       D_STATE_METADATA_VALUE, D_STATE_METADATA_OP, D_STATE_METADATA_OBJECT, D_STATE_METADATA_OBJECT_TYPE, D_ENTRIES\nFROM {0} \nWHERE D_ORIGINATOR_ID = ? ORDER BY D_CREATED_AT ASC");
        }
    }
}

