/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.jdbc.postgres;

public interface PostgresQueries {
    public static final String SQL_STATE_READ = "SELECT tbl_{0}.S_TYPE, TBL_{0}.S_TYPE_VERSION, TBL_{0}.S_DATA, TBL_{0}.S_DATA_VERSION, TBL_{0}.S_METADATA_VALUE, TBL_{0}.S_METADATA_OP FROM tbl_{0} WHERE tbl_{0}.S_ID = ?";
    public static final String SQL_STATE_WRITE = "INSERT INTO tbl_{0} \n(s_id, s_type, s_type_version, s_data, s_data_version, s_metadata_value, s_metadata_op) \nVALUES (?, ?, ?, {1}, ?, ?, ?) \nON CONFLICT (s_id) DO UPDATE SET \ns_type = EXCLUDED.s_type, \ns_type_version = EXCLUDED.s_type_version, \ns_data = EXCLUDED.s_data, \ns_data_version = EXCLUDED.s_data_version, \ns_metadata_value = EXCLUDED.s_metadata_value, \ns_metadata_op = EXCLUDED.s_metadata_op \n";
    public static final String SQL_FORMAT_BINARY_CAST = "?";
    public static final String SQL_FORMAT_TEXT_CAST = "?::JSON";
    public static final String SQL_CREATE_STATE_STORE = "CREATE TABLE {0} (\n   s_id VARCHAR(128) NOT NULL,\n   s_type VARCHAR(256) NOT NULL,\n   s_type_version INT NOT NULL,\n   s_data {1} NOT NULL,\n   s_data_version INT NOT NULL,\n   s_metadata_value TEXT NOT NULL,\n   s_metadata_op VARCHAR(128) NOT NULL,\n   PRIMARY KEY (s_id) \n);";
    public static final String SQL_FORMAT_BINARY = "bytea";
    public static final String SQL_FORMAT_TEXT1 = "json";
    public static final String TBL_VLINGO_SYMBIO_DISPATCHABLES = "tbl_vlingo_symbio_dispatchables";
    public static final String SQL_CREATE_DISPATCHABLES_STORE = "CREATE TABLE {0} (\n   d_id BIGSERIAL PRIMARY KEY,   d_created_at TIMESTAMP NOT NULL,   d_originator_id VARCHAR(32) NOT NULL,   d_dispatch_id VARCHAR(128) NOT NULL,\n   d_state_id VARCHAR(128) NOT NULL, \n   d_state_type VARCHAR(256) NOT NULL,\n   d_state_type_version INT NOT NULL,\n   d_state_data {1} NOT NULL,\n   d_state_data_version INT NOT NULL,\n   d_state_metadata_value TEXT NOT NULL,\n   d_state_metadata_op VARCHAR(128) NOT NULL,\n   d_state_metadata_object TEXT,\n   d_state_metadata_object_type VARCHAR(256),\n   d_entries TEXT\n);";
    public static final String SQL_DISPATCH_ID_INDEX = "CREATE INDEX idx_dispatchables_dispatch_id \nON {0} (d_dispatch_id);";
    public static final String SQL_ORIGINATOR_ID_INDEX = "CREATE INDEX idx_dispatchables_originator_id \nON {0} (d_originator_id);";
    public static final String SQL_DISPATCHABLE_APPEND = "INSERT INTO {0} \n(d_id, d_created_at, d_originator_id, d_dispatch_id, \n d_state_id, d_state_type, d_state_type_version, \n d_state_data, d_state_data_version, \n d_state_metadata_value, d_state_metadata_op, d_state_metadata_object, d_state_metadata_object_type, d_entries) \nVALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String SQL_DISPATCHABLE_DELETE = "DELETE FROM {0} WHERE d_dispatch_id = ?";
    public static final String SQL_DISPATCHABLE_SELECT = "SELECT d_created_at, d_dispatch_id, d_state_id, d_state_type, d_state_type_version, d_state_data, d_state_data_version, \n       d_state_metadata_value, d_state_metadata_op, d_state_metadata_object, d_state_metadata_object_type, d_entries \nFROM {0} \nWHERE d_originator_id = ? ORDER BY d_created_at ASC";
    public static final String SQL_CREATE_ENTRY_STORE = "CREATE TABLE {0} (\n   e_id BIGSERIAL PRIMARY KEY,   e_type VARCHAR(256) NOT NULL,\n   e_type_version INT NOT NULL,\n   e_data {1} NOT NULL,\n   e_metadata_value VARCHAR(4000) NOT NULL,\n   e_metadata_op VARCHAR(128) NOT NULL\n);";
    public static final String TBL_VLINGO_SYMBIO_STATE_ENTRY = "tbl_vlingo_symbio_state_entry";
    public static final String SQL_CREATE_ENTRY_STORE_OFFSETS = "CREATE TABLE {0} (\n   reader_name VARCHAR(128) PRIMARY KEY,   reader_offset BIGINT NOT NULL\n);";
    public static final String TBL_VLINGO_SYMBIO_STATE_ENTRY_OFFSETS = "tbl_vlingo_symbio_state_entry_offsets";
    public static final String SQL_APPEND_ENTRY = "INSERT INTO {0} \n(e_id, e_type, e_type_version, e_data, e_metadata_value, e_metadata_op) \nVALUES (DEFAULT, ?, ?, ?, ?, ?)";
    public static final String SQL_APPEND_ENTRY_IDENTITY = "SELECT lastval()";
    public static final String SQL_QUERY_ENTRY_BATCH = "SELECT e_id, e_type, e_type_version, e_data, e_metadata_value, e_metadata_op FROM  {0} WHERE E_ID >= ? ORDER BY e_id LIMIT ?";
    public static final String SQL_QUERY_ENTRY = "SELECT e_id, e_type, e_type_version, e_data, e_metadata_value, e_metadata_op FROM  {0} WHERE e_id = ? ";
    public static final String QUERY_LATEST_OFFSET = "SELECT reader_offset FROM {0} WHERE reader_name = ?";
    public static final String QUERY_COUNT = "SELECT COUNT(*) FROM {0}";
    public static final String UPDATE_CURRENT_OFFSET = "INSERT INTO {0}(reader_offset, reader_name) VALUES(?, ?) ON CONFLICT (reader_name) DO UPDATE SET reader_offset=?";
}

