/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.state.jdbc.postgres;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Logger;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.DataFormat;
import io.vlingo.symbio.store.EntryReader;
import io.vlingo.symbio.store.common.jdbc.CachedStatement;
import io.vlingo.symbio.store.common.jdbc.Configuration;
import io.vlingo.symbio.store.state.StateStore;
import io.vlingo.symbio.store.state.jdbc.DbStateStoreEntryReaderActor;
import io.vlingo.symbio.store.state.jdbc.JDBCDispatchableCachedStatements;
import io.vlingo.symbio.store.state.jdbc.JDBCStorageDelegate;
import io.vlingo.symbio.store.state.jdbc.postgres.PostgresQueries;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import org.postgresql.util.PGobject;

public class PostgresStorageDelegate
extends JDBCStorageDelegate<Object>
implements StateStore.StorageDelegate,
PostgresQueries {
    private final Configuration configuration;

    public PostgresStorageDelegate(Configuration configuration, Logger logger) {
        super(configuration.connection, configuration.format, configuration.originatorId, configuration.createTables, logger);
        this.configuration = configuration;
    }

    public StateStore.StorageDelegate copy() {
        try {
            return new PostgresStorageDelegate(Configuration.cloneOf(this.configuration), this.logger);
        }
        catch (Exception e) {
            String message = "Copy of StorageDelegate failed because: " + e.getMessage();
            this.logger.error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    public EntryReader.Advice entryReaderAdvice() {
        try {
            return new EntryReader.Advice((Object)Configuration.cloneOf(this.configuration), DbStateStoreEntryReaderActor.class, this.namedEntry("SELECT e_id, e_type, e_type_version, e_data, e_metadata_value, e_metadata_op FROM  {0} WHERE E_ID >= ? ORDER BY e_id LIMIT ?"), this.namedEntry("SELECT e_id, e_type, e_type_version, e_data, e_metadata_value, e_metadata_op FROM  {0} WHERE e_id = ? "), this.namedEntry("SELECT COUNT(*) FROM {0}"), this.namedEntryOffsets("SELECT reader_offset FROM {0} WHERE reader_name = ?"), this.namedEntryOffsets("INSERT INTO {0}(reader_offset, reader_name) VALUES(?, ?) ON CONFLICT (reader_name) DO UPDATE SET reader_offset=?"));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create EntryReader.Advice because: " + e.getMessage(), e);
        }
    }

    public <A extends Actor> ActorInstantiator<A> instantiator() {
        return new DbStateStoreEntryReaderActor.DbStateStoreEntryReaderInstantiator();
    }

    @Override
    protected byte[] binaryDataFrom(ResultSet resultSet, int columnIndex) throws Exception {
        byte[] data = resultSet.getBytes(columnIndex);
        return data;
    }

    @Override
    protected <D> D binaryDataTypeObject() throws Exception {
        return null;
    }

    @Override
    protected JDBCDispatchableCachedStatements<Object> dispatchableCachedStatements() {
        return new PostgresDispatchableCachedStatements<Object>(this.originatorId, this.connection, this.format, this.logger);
    }

    @Override
    protected String dispatchableIdIndexCreateExpression() {
        return this.namedDispatchable("CREATE INDEX idx_dispatchables_dispatch_id \nON {0} (d_dispatch_id);");
    }

    @Override
    protected String dispatchableOriginatorIdIndexCreateExpression() {
        return this.namedDispatchable("CREATE INDEX idx_dispatchables_originator_id \nON {0} (d_originator_id);");
    }

    @Override
    protected String dispatchableTableCreateExpression() {
        return MessageFormat.format("CREATE TABLE {0} (\n   d_id BIGSERIAL PRIMARY KEY,   d_created_at TIMESTAMP NOT NULL,   d_originator_id VARCHAR(32) NOT NULL,   d_dispatch_id VARCHAR(128) NOT NULL,\n   d_state_id VARCHAR(128) NOT NULL, \n   d_state_type VARCHAR(256) NOT NULL,\n   d_state_type_version INT NOT NULL,\n   d_state_data {1} NOT NULL,\n   d_state_data_version INT NOT NULL,\n   d_state_metadata_value TEXT NOT NULL,\n   d_state_metadata_op VARCHAR(128) NOT NULL,\n   d_state_metadata_object TEXT,\n   d_state_metadata_object_type VARCHAR(256),\n   d_entries TEXT\n);", this.dispatchableTableName(), this.format.isBinary() ? "bytea" : "json");
    }

    @Override
    protected String dispatchableTableName() {
        return "tbl_vlingo_symbio_dispatchables";
    }

    @Override
    protected String entryTableCreateExpression() {
        return MessageFormat.format("CREATE TABLE {0} (\n   e_id BIGSERIAL PRIMARY KEY,   e_type VARCHAR(256) NOT NULL,\n   e_type_version INT NOT NULL,\n   e_data {1} NOT NULL,\n   e_metadata_value VARCHAR(4000) NOT NULL,\n   e_metadata_op VARCHAR(128) NOT NULL\n);", this.entryTableName(), this.format.isBinary() ? "bytea" : "json");
    }

    @Override
    protected String entryOffsetsTableCreateExpression() {
        return MessageFormat.format("CREATE TABLE {0} (\n   reader_name VARCHAR(128) PRIMARY KEY,   reader_offset BIGINT NOT NULL\n);", this.entryOffsetsTableName());
    }

    @Override
    protected String entryTableName() {
        return "tbl_vlingo_symbio_state_entry";
    }

    @Override
    protected String entryOffsetsTableName() {
        return "tbl_vlingo_symbio_state_entry_offsets";
    }

    @Override
    protected String readExpression(String storeName, String id) {
        return MessageFormat.format("SELECT tbl_{0}.S_TYPE, TBL_{0}.S_TYPE_VERSION, TBL_{0}.S_DATA, TBL_{0}.S_DATA_VERSION, TBL_{0}.S_METADATA_VALUE, TBL_{0}.S_METADATA_OP FROM tbl_{0} WHERE tbl_{0}.S_ID = ?", storeName.toLowerCase());
    }

    @Override
    protected <E> void setBinaryObject(CachedStatement<Object> cached, int columnIndex, Entry<E> entry) throws Exception {
        cached.preparedStatement.setBytes(columnIndex, (byte[])entry.entryData());
    }

    @Override
    protected <S> void setBinaryObject(CachedStatement<Object> cached, int columnIndex, State<S> state) throws Exception {
        cached.preparedStatement.setBytes(columnIndex, (byte[])state.data);
    }

    @Override
    protected <E> void setTextObject(CachedStatement<Object> cached, int columnIndex, Entry<E> entry) throws Exception {
        PGobject jsonObject = new PGobject();
        jsonObject.setType("json");
        jsonObject.setValue((String)entry.entryData());
        cached.preparedStatement.setObject(columnIndex, jsonObject);
    }

    @Override
    protected <S> void setTextObject(CachedStatement<Object> cached, int columnIndex, State<S> state) throws Exception {
        PGobject jsonObject = new PGobject();
        jsonObject.setType("json");
        jsonObject.setValue((String)state.data);
        cached.preparedStatement.setObject(columnIndex, jsonObject);
    }

    @Override
    protected String stateStoreTableCreateExpression(String stateName) {
        return MessageFormat.format("CREATE TABLE {0} (\n   s_id VARCHAR(128) NOT NULL,\n   s_type VARCHAR(256) NOT NULL,\n   s_type_version INT NOT NULL,\n   s_data {1} NOT NULL,\n   s_data_version INT NOT NULL,\n   s_metadata_value TEXT NOT NULL,\n   s_metadata_op VARCHAR(128) NOT NULL,\n   PRIMARY KEY (s_id) \n);", stateName, this.format.isBinary() ? "bytea" : "json");
    }

    @Override
    protected String tableNameFor(String storeName) {
        return "tbl_" + storeName.toLowerCase();
    }

    @Override
    protected String textDataFrom(ResultSet resultSet, int columnIndex) throws Exception {
        String text = resultSet.getObject(columnIndex).toString();
        return text;
    }

    @Override
    protected String writeExpression(String storeName) {
        return MessageFormat.format("INSERT INTO tbl_{0} \n(s_id, s_type, s_type_version, s_data, s_data_version, s_metadata_value, s_metadata_op) \nVALUES (?, ?, ?, {1}, ?, ?, ?) \nON CONFLICT (s_id) DO UPDATE SET \ns_type = EXCLUDED.s_type, \ns_type_version = EXCLUDED.s_type_version, \ns_data = EXCLUDED.s_data, \ns_data_version = EXCLUDED.s_data_version, \ns_metadata_value = EXCLUDED.s_metadata_value, \ns_metadata_op = EXCLUDED.s_metadata_op \n", storeName.toLowerCase(), this.format.isBinary() ? "?" : "?::JSON");
    }

    private String namedDispatchable(String sql) {
        return MessageFormat.format(sql, this.dispatchableTableName());
    }

    private String namedEntry(String sql) {
        return MessageFormat.format(sql, this.entryTableName());
    }

    private String namedEntryOffsets(String sql) {
        return MessageFormat.format(sql, this.entryOffsetsTableName());
    }

    class PostgresDispatchableCachedStatements<T>
    extends JDBCDispatchableCachedStatements<T> {
        PostgresDispatchableCachedStatements(String originatorId, Connection connection, DataFormat format, Logger logger) {
            super(originatorId, connection, format, null, logger);
        }

        @Override
        protected String appendDispatchableExpression() {
            return PostgresStorageDelegate.this.namedDispatchable("INSERT INTO {0} \n(d_id, d_created_at, d_originator_id, d_dispatch_id, \n d_state_id, d_state_type, d_state_type_version, \n d_state_data, d_state_data_version, \n d_state_metadata_value, d_state_metadata_op, d_state_metadata_object, d_state_metadata_object_type, d_entries) \nVALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }

        @Override
        protected String deleteDispatchableExpression() {
            return PostgresStorageDelegate.this.namedDispatchable("DELETE FROM {0} WHERE d_dispatch_id = ?");
        }

        @Override
        protected String selectDispatchableExpression() {
            return PostgresStorageDelegate.this.namedDispatchable("SELECT d_created_at, d_dispatch_id, d_state_id, d_state_type, d_state_type_version, d_state_data, d_state_data_version, \n       d_state_metadata_value, d_state_metadata_op, d_state_metadata_object, d_state_metadata_object_type, d_entries \nFROM {0} \nWHERE d_originator_id = ? ORDER BY d_created_at ASC");
        }

        @Override
        protected String appendEntryExpression() {
            return PostgresStorageDelegate.this.namedEntry("INSERT INTO {0} \n(e_id, e_type, e_type_version, e_data, e_metadata_value, e_metadata_op) \nVALUES (DEFAULT, ?, ?, ?, ?, ?)");
        }

        @Override
        protected String queryEntryExpression() {
            return PostgresStorageDelegate.this.namedEntry("SELECT e_id, e_type, e_type_version, e_data, e_metadata_value, e_metadata_op FROM  {0} WHERE e_id = ? ");
        }

        @Override
        protected String appendEntryIdentityExpression() {
            return "SELECT lastval()";
        }
    }
}

