/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.lattice.exchange.rabbitmq;

import io.vlingo.xoom.lattice.exchange.ConnectionSettings;
import io.vlingo.xoom.lattice.exchange.Covey;
import io.vlingo.xoom.lattice.exchange.Exchange;
import io.vlingo.xoom.lattice.exchange.Forwarder;
import io.vlingo.xoom.lattice.exchange.rabbitmq.BrokerConnection;
import io.vlingo.xoom.lattice.exchange.rabbitmq.ExchangeListener;

class BrokerExchange
implements Exchange {
    public final String type;
    final BrokerConnection connection;
    private final ExchangeListener listener;
    private final Forwarder forwarder;

    Forwarder forwarder() {
        return this.forwarder;
    }

    public void close() {
        this.listener.close();
        this.connection.close();
    }

    public <T> T channel() {
        return (T)this.connection.channel();
    }

    public <T> T connection() {
        return (T)this.connection;
    }

    public String name() {
        return this.connection.name;
    }

    public <L, E, EX> Exchange register(Covey<L, E, EX> covey) {
        this.forwarder.register(covey);
        return this;
    }

    public <L> void send(L local) {
        this.forwarder.forwardToSender(local);
    }

    BrokerExchange(ConnectionSettings connectionSettings, String name, String type, boolean isDurable) {
        this.connection = new BrokerConnection(connectionSettings, BrokerConnection.Type.Exchange, name, isDurable);
        this.forwarder = new Forwarder();
        this.type = type;
        try {
            this.connection.channel().exchangeDeclare(name, type, isDurable);
            this.listener = new ExchangeListener(this, name + ".self-listening-queue");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create/open the exchange because: " + e.getMessage(), e);
        }
    }
}

