/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.lattice.exchange.rabbitmq;

import io.vlingo.xoom.lattice.exchange.rabbitmq.BrokerConnection;
import io.vlingo.xoom.lattice.exchange.rabbitmq.BrokerExchange;
import io.vlingo.xoom.lattice.exchange.rabbitmq.BrokerQueue;
import io.vlingo.xoom.lattice.exchange.rabbitmq.Message;
import io.vlingo.xoom.lattice.exchange.rabbitmq.MessageConsumer;
import io.vlingo.xoom.lattice.exchange.rabbitmq.MessageListener;

class ExchangeListener
implements MessageListener {
    private final BrokerConnection connection;
    private final BrokerExchange exchange;
    private final MessageConsumer messageConsumer;
    private final BrokerQueue queue;

    @Override
    public void handleMessage(Message message) throws Exception {
        this.exchange.forwarder().forwardToAllReceivers((Object)message);
    }

    ExchangeListener(BrokerExchange exchange, String queueName) {
        this.connection = exchange.connection;
        this.exchange = exchange;
        this.queue = BrokerQueue.using(exchange, queueName);
        this.messageConsumer = MessageConsumer.instance(this.queue, false);
        this.messageConsumer.receiveAll(this);
    }

    void close() {
        this.connection.close();
        this.messageConsumer.close();
    }

    String exchangeName() {
        return this.exchange.name();
    }

    String queueName() {
        return this.exchange.name() + "-queue";
    }
}

