/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.lattice.exchange.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.MessageProperties;
import io.vlingo.xoom.lattice.exchange.MessageParameters;
import java.util.Date;
import java.util.Map;

public class MessageParametersMapper {
    private static AMQP.BasicProperties defaultProperties = MessageProperties.PERSISTENT_BASIC;

    public static AMQP.BasicProperties from(MessageParameters messageParameters) {
        return new AMQP.BasicProperties(MessageParametersMapper.contentType(messageParameters.contentType()), MessageParametersMapper.contentEncoding(messageParameters.contentEncoding()), MessageParametersMapper.headers(messageParameters.headers()), Integer.valueOf(MessageParametersMapper.deliveryModeOf(messageParameters)), Integer.valueOf(MessageParametersMapper.priorityOf(messageParameters)), MessageParametersMapper.correlationId(messageParameters.correlationId()), MessageParametersMapper.replyTo(messageParameters.replyTo()), MessageParametersMapper.timeToLive(messageParameters.timeToLive()), MessageParametersMapper.messageId(messageParameters.messageId()), MessageParametersMapper.timestamp(messageParameters.timestamp()), MessageParametersMapper.typeName(messageParameters.typeName()), MessageParametersMapper.userId(messageParameters.userId()), MessageParametersMapper.applicationId(messageParameters.applicationId()), null);
    }

    private static String applicationId(String applicationId) {
        return applicationId == null ? defaultProperties.getAppId() : applicationId;
    }

    private static String correlationId(String correlationId) {
        return correlationId == null ? defaultProperties.getCorrelationId() : correlationId;
    }

    private static String contentEncoding(String contentEncoding) {
        return contentEncoding == null ? defaultProperties.getContentEncoding() : contentEncoding;
    }

    private static String contentType(String contentType) {
        return contentType == null ? defaultProperties.getContentType() : contentType;
    }

    private static int deliveryModeOf(MessageParameters messageParameters) {
        return messageParameters.isDurableDeliveryMode() ? 2 : 1;
    }

    private static Map<String, Object> headers(Map<String, Object> headers) {
        return headers == null ? defaultProperties.getHeaders() : headers;
    }

    private static String messageId(String messageId) {
        return messageId == null ? defaultProperties.getMessageId() : messageId;
    }

    private static int priorityOf(MessageParameters messageParameters) {
        if (messageParameters.priority() != null) {
            switch (messageParameters.priority()) {
                case Low: 
                case P0: {
                    return 0;
                }
                case P1: {
                    return 1;
                }
                case P2: {
                    return 2;
                }
                case P3: {
                    return 3;
                }
                case Medium: 
                case Normal: 
                case P4: {
                    return 4;
                }
                case P5: {
                    return 5;
                }
                case P6: {
                    return 6;
                }
                case P7: {
                    return 7;
                }
                case P8: {
                    return 8;
                }
                case High: 
                case P9: {
                    return 9;
                }
            }
        }
        return 4;
    }

    private static String replyTo(String replyTo) {
        return replyTo == null ? defaultProperties.getReplyTo() : replyTo;
    }

    private static Date timestamp(long timestamp) {
        return timestamp <= 0L ? defaultProperties.getTimestamp() : new Date(timestamp);
    }

    private static String timeToLive(long timeToLive) {
        return timeToLive <= 0L ? defaultProperties.getExpiration() : Long.toString(timeToLive);
    }

    private static String typeName(String typeName) {
        return typeName == null ? defaultProperties.getType() : typeName;
    }

    private static String userId(String userId) {
        return userId == null ? defaultProperties.getUserId() : userId;
    }
}

