/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.lattice.exchange.rabbitmq;

import io.vlingo.xoom.lattice.exchange.ExchangeException;
import io.vlingo.xoom.lattice.exchange.MessageParameters;
import io.vlingo.xoom.lattice.exchange.rabbitmq.BrokerConnection;
import io.vlingo.xoom.lattice.exchange.rabbitmq.MessageParametersMapper;
import java.io.IOException;

class MessageProducer {
    private final BrokerConnection brokerConnection;

    public static MessageProducer instance(BrokerConnection brokerChannel) {
        return new MessageProducer(brokerChannel);
    }

    public void close() {
        this.brokerConnection.close();
    }

    public MessageProducer send(byte[] binaryMessage, MessageParameters messageParameters) {
        this.check(messageParameters);
        try {
            this.brokerConnection.channel().basicPublish(this.brokerConnection.exchangeName(), this.brokerConnection.queueName(), MessageParametersMapper.from(messageParameters), binaryMessage);
        }
        catch (IOException e) {
            throw new ExchangeException("Failed to send message to channel because: " + e.getMessage(), (Throwable)e);
        }
        return this;
    }

    public MessageProducer send(String routingKey, byte[] binaryMessage, MessageParameters messageParameters) {
        this.check(messageParameters);
        try {
            this.brokerConnection.channel().basicPublish(this.brokerConnection.exchangeName(), routingKey, MessageParametersMapper.from(messageParameters), binaryMessage);
        }
        catch (IOException e) {
            throw new ExchangeException("Failed to send message to channel because: " + e.getMessage(), (Throwable)e);
        }
        return this;
    }

    public MessageProducer send(String exchange, String routingKey, byte[] binaryMessage, MessageParameters messageParameters) {
        this.check(messageParameters);
        try {
            this.brokerConnection.channel().basicPublish(exchange, routingKey, MessageParametersMapper.from(messageParameters), binaryMessage);
        }
        catch (IOException e) {
            throw new ExchangeException("Failed to send message to channel because: " + e.getMessage(), (Throwable)e);
        }
        return this;
    }

    protected MessageProducer(BrokerConnection brokerConnection) {
        this.brokerConnection = brokerConnection;
    }

    private void check(MessageParameters messageParameters) {
        if (this.brokerConnection.durable) {
            if (!messageParameters.isDurableDeliveryMode()) {
                throw new IllegalArgumentException("MessageParameters must be durable.");
            }
        } else if (messageParameters.isDurableDeliveryMode()) {
            throw new IllegalArgumentException("MessageParameters must not be durable.");
        }
    }
}

