/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.lattice.exchange.rabbitmq;

import io.vlingo.xoom.lattice.exchange.ConnectionSettings;
import io.vlingo.xoom.lattice.exchange.Queue;
import io.vlingo.xoom.lattice.exchange.rabbitmq.BrokerExchange;
import io.vlingo.xoom.lattice.exchange.rabbitmq.BrokerQueue;
import java.io.IOException;

public class QueueFactory {
    public static Queue instance(ConnectionSettings connectionSettings, String exchangeName, String queueName) {
        return new BrokerQueue(connectionSettings, exchangeName, queueName, false, false, false);
    }

    public static Queue instance(ConnectionSettings connectionSettings, String exchangeName, String queueName, boolean isDurable, boolean isExclusive, boolean isAutoDeleted) {
        return new BrokerQueue(connectionSettings, exchangeName, queueName, isDurable, isExclusive, isAutoDeleted);
    }

    public static Queue durableInstance(ConnectionSettings connectionSettings, String exchangeName, String queueName) {
        return new BrokerQueue(connectionSettings, exchangeName, queueName, true, false, false);
    }

    public static Queue durableExclsuiveInstance(ConnectionSettings connectionSettings, String exchangeName, String queueName) {
        return new BrokerQueue(connectionSettings, exchangeName, queueName, true, true, false);
    }

    public static Queue exchangeSubscriberInstance(BrokerExchange exchange) {
        BrokerQueue queue = new BrokerQueue(exchange, "", false, true, true);
        try {
            queue.connection.channel().queueBind(queue.name(), exchange.name(), "");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to bind the queue and exchange because: " + e.getMessage(), e);
        }
        return queue;
    }

    public static Queue exchangeSubscriberInstance(BrokerExchange exchange, String[] routingKeys) {
        BrokerQueue queue = new BrokerQueue(exchange, "", false, true, true);
        try {
            for (String routingKey : routingKeys) {
                queue.connection.channel().queueBind(queue.name(), exchange.name(), routingKey);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to bind the queue and exchange because: " + e.getMessage(), e);
        }
        return queue;
    }

    public static Queue exchangeSubscriberInstance(BrokerExchange exchange, String name, String[] routingKeys, boolean isDurable, boolean isExclusive, boolean isAutoDeleted) {
        BrokerQueue queue = new BrokerQueue(exchange, name, isDurable, isExclusive, isAutoDeleted);
        try {
            if (routingKeys.length == 0) {
                queue.connection.channel().queueBind(queue.name(), exchange.name(), "");
            } else {
                for (String routingKey : routingKeys) {
                    queue.connection.channel().queueBind(queue.name(), exchange.name(), routingKey);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to bind the queue and exchange because: " + e.getMessage(), e);
        }
        return queue;
    }

    public static Queue individualExchangeSubscriberInstance(BrokerExchange exchange, String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("An individual subscriber must be named.");
        }
        BrokerQueue queue = new BrokerQueue(exchange, name, true, false, false);
        try {
            queue.connection.channel().queueBind(queue.name(), exchange.name(), "");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to bind the queue and exchange because: " + e.getMessage(), e);
        }
        return queue;
    }

    public static Queue individualExchangeSubscriberInstance(BrokerExchange exchange, String name, String[] routingKeys) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("An individual subscriber must be named.");
        }
        BrokerQueue queue = new BrokerQueue(exchange, name, true, false, false);
        try {
            for (String routingKey : routingKeys) {
                queue.connection.channel().queueBind(queue.connection.name, exchange.connection.name, routingKey);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to bind the queue and exchange because: " + e.getMessage(), e);
        }
        return queue;
    }
}

