/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.lattice.exchange.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import io.vlingo.xoom.lattice.exchange.ConnectionSettings;

public class BrokerConnection {
    final ConnectionSettings connectionSettings;
    final boolean durable;
    final String hostName;
    final String name;
    final Type type;
    private Channel channel;
    private boolean closed;
    private Connection connection;

    BrokerConnection(ConnectionSettings connectionSettings, Type type, String name, boolean isDurable) {
        this.connectionSettings = connectionSettings;
        ConnectionFactory factory = this.configureConnectionFactoryUsing(connectionSettings);
        this.type = type;
        this.name = name != null ? name : "";
        this.hostName = connectionSettings.hostName;
        this.durable = isDurable;
        try {
            this.connection = factory.newConnection();
            this.channel = this.connection.createChannel();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create/open the queue because: " + e.getMessage(), e);
        }
    }

    BrokerConnection(BrokerConnection brokerChannel, Type type) {
        this(brokerChannel, type, null);
    }

    BrokerConnection(BrokerConnection brokerChannel, Type type, String name) {
        this(brokerChannel, type, name, brokerChannel.durable);
    }

    BrokerConnection(BrokerConnection brokerChannel, Type type, String name, boolean isDurable) {
        this.connectionSettings = brokerChannel.connectionSettings;
        this.hostName = brokerChannel.hostName;
        this.type = type;
        this.name = name != null ? name : "";
        this.connection = brokerChannel.connection;
        this.channel = brokerChannel.channel;
        this.durable = isDurable;
    }

    Channel channel() {
        return this.channel;
    }

    void close() {
        try {
            if (!this.closed && this.channel.isOpen()) {
                this.channel.close();
                this.connection.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.connection != null && this.connection.isOpen()) {
                this.connection.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.closed = true;
        this.channel = null;
        this.connection = null;
    }

    boolean isClosed() {
        return this.closed;
    }

    boolean isExchange() {
        return this.type == Type.Exchange;
    }

    String exchangeName() {
        return this.isExchange() ? this.name : "";
    }

    boolean isQueue() {
        return this.type == Type.Queue;
    }

    String queueName() {
        return this.isQueue() ? this.name : "";
    }

    private ConnectionFactory configureConnectionFactoryUsing(ConnectionSettings connectionSettings) {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(connectionSettings.hostName);
        if (connectionSettings.hasPort()) {
            factory.setPort(connectionSettings.port);
        }
        factory.setVirtualHost(connectionSettings.virtualHost);
        if (connectionSettings.hasUserCredentials()) {
            factory.setUsername(connectionSettings.username);
            factory.setPassword(connectionSettings.password);
        }
        return factory;
    }

    static enum Type {
        Exchange,
        Queue;

    }
}

