/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.lattice.exchange.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import io.vlingo.xoom.lattice.exchange.ConnectionSettings;
import io.vlingo.xoom.lattice.exchange.Covey;
import io.vlingo.xoom.lattice.exchange.Exchange;
import io.vlingo.xoom.lattice.exchange.Forwarder;
import io.vlingo.xoom.lattice.exchange.Queue;
import io.vlingo.xoom.lattice.exchange.rabbitmq.BrokerConnection;
import io.vlingo.xoom.lattice.exchange.rabbitmq.BrokerExchange;
import java.io.IOException;

class BrokerQueue
implements Queue {
    final BrokerConnection connection;
    private final String exchangeName;
    private final Forwarder forwarder;
    private final String queueName;

    public void close() {
        this.connection.close();
    }

    public <T> T channel() {
        return (T)this.connection.channel();
    }

    public <T> T connection() {
        return (T)this.connection;
    }

    public String name() {
        return this.queueName;
    }

    public <L, E, EX> Exchange register(Covey<L, E, EX> covey) {
        this.forwarder.register(covey);
        return this;
    }

    public <L> void send(L local) {
        this.forwarder.forwardToSender(local);
    }

    static BrokerQueue using(BrokerExchange exchange, String queueName) {
        return new BrokerQueue(exchange, queueName);
    }

    static BrokerQueue using(BrokerExchange exchange, String queueName, boolean isDurable, boolean isExclusive, boolean isAutoDeleted) {
        return new BrokerQueue(exchange, queueName, isDurable, isExclusive, isAutoDeleted);
    }

    BrokerQueue(ConnectionSettings connectionSettings, String exchangeName, String queueName, boolean isDurable, boolean isExclusive, boolean isAutoDeleted) {
        this.connection = new BrokerConnection(connectionSettings, BrokerConnection.Type.Queue, queueName, isDurable);
        this.exchangeName = exchangeName;
        this.queueName = queueName;
        this.forwarder = new Forwarder();
        try {
            Channel channel = this.connection.channel();
            AMQP.Queue.DeclareOk ok = channel.queueDeclare(queueName, isDurable, isExclusive, isAutoDeleted, null);
            channel.queueBind(ok.getQueue(), exchangeName, "");
            this.connection.channel().queueDeclare(queueName, isDurable, isExclusive, isAutoDeleted, null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to create/open the queue because: " + e.getMessage(), e);
        }
    }

    BrokerQueue(BrokerExchange exchange, String queueName) {
        this(exchange, queueName, true, false, false);
    }

    BrokerQueue(BrokerExchange exchange, String queueName, boolean isDurable, boolean isExclusive, boolean isAutoDeleted) {
        this.connection = exchange.connection;
        this.exchangeName = exchange.name();
        this.queueName = queueName;
        this.forwarder = new Forwarder();
        try {
            Channel channel = exchange.connection.channel();
            channel.queueDeclare(queueName, exchange.connection.durable, false, false, null);
            channel.queueBind(queueName, this.exchangeName, "");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to create/open the queue because: " + e.getMessage(), e);
        }
    }
}

