/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.api;

import com.google.gson.reflect.TypeToken;
import io.voucherify.client.ApiCallback;
import io.voucherify.client.ApiClient;
import io.voucherify.client.ApiException;
import io.voucherify.client.ApiResponse;
import io.voucherify.client.Configuration;
import io.voucherify.client.Pair;
import io.voucherify.client.model.AsyncActionGetResponseBody;
import io.voucherify.client.model.AsyncActionsListResponseBody;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class AsyncActionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AsyncActionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AsyncActionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getAsyncActionCall(String asyncActionId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/async-actions/{asyncActionId}".replace("{asyncActionId}", this.localVarApiClient.escapeString(asyncActionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAsyncActionValidateBeforeCall(String asyncActionId, ApiCallback _callback) throws ApiException {
        if (asyncActionId == null) {
            throw new ApiException("Missing the required parameter 'asyncActionId' when calling getAsyncAction(Async)");
        }
        return this.getAsyncActionCall(asyncActionId, _callback);
    }

    public AsyncActionGetResponseBody getAsyncAction(String asyncActionId) throws ApiException {
        ApiResponse<AsyncActionGetResponseBody> localVarResp = this.getAsyncActionWithHttpInfo(asyncActionId);
        return localVarResp.getData();
    }

    public ApiResponse<AsyncActionGetResponseBody> getAsyncActionWithHttpInfo(String asyncActionId) throws ApiException {
        Call localVarCall = this.getAsyncActionValidateBeforeCall(asyncActionId, null);
        Type localVarReturnType = new TypeToken<AsyncActionGetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAsyncActionAsync(String asyncActionId, ApiCallback<AsyncActionGetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.getAsyncActionValidateBeforeCall(asyncActionId, _callback);
        Type localVarReturnType = new TypeToken<AsyncActionGetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listAsyncActionsCall(Integer limit, OffsetDateTime endDate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/async-actions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_date", endDate));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listAsyncActionsValidateBeforeCall(Integer limit, OffsetDateTime endDate, ApiCallback _callback) throws ApiException {
        return this.listAsyncActionsCall(limit, endDate, _callback);
    }

    public AsyncActionsListResponseBody listAsyncActions(Integer limit, OffsetDateTime endDate) throws ApiException {
        ApiResponse<AsyncActionsListResponseBody> localVarResp = this.listAsyncActionsWithHttpInfo(limit, endDate);
        return localVarResp.getData();
    }

    public ApiResponse<AsyncActionsListResponseBody> listAsyncActionsWithHttpInfo(Integer limit, OffsetDateTime endDate) throws ApiException {
        Call localVarCall = this.listAsyncActionsValidateBeforeCall(limit, endDate, null);
        Type localVarReturnType = new TypeToken<AsyncActionsListResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listAsyncActionsAsync(Integer limit, OffsetDateTime endDate, ApiCallback<AsyncActionsListResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listAsyncActionsValidateBeforeCall(limit, endDate, _callback);
        Type localVarReturnType = new TypeToken<AsyncActionsListResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

