/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.api;

import com.google.gson.reflect.TypeToken;
import io.voucherify.client.ApiCallback;
import io.voucherify.client.ApiClient;
import io.voucherify.client.ApiException;
import io.voucherify.client.ApiResponse;
import io.voucherify.client.Configuration;
import io.voucherify.client.Pair;
import io.voucherify.client.model.CustomersActivityListResponseBody;
import io.voucherify.client.model.CustomersCreateRequestBody;
import io.voucherify.client.model.CustomersCreateResponseBody;
import io.voucherify.client.model.CustomersGetResponseBody;
import io.voucherify.client.model.CustomersImportCsvCreateResponseBody;
import io.voucherify.client.model.CustomersListResponseBody;
import io.voucherify.client.model.CustomersMetadataUpdateInBulkRequestBody;
import io.voucherify.client.model.CustomersMetadataUpdateInBulkResponseBody;
import io.voucherify.client.model.CustomersPermanentDeletionCreateResponseBody;
import io.voucherify.client.model.CustomersRedeemablesListResponseBody;
import io.voucherify.client.model.CustomersSegmentsListResponseBody;
import io.voucherify.client.model.CustomersUpdateInBulkRequestBody;
import io.voucherify.client.model.CustomersUpdateInBulkResponseBody;
import io.voucherify.client.model.CustomersUpdateRequestBody;
import io.voucherify.client.model.CustomersUpdateResponseBody;
import io.voucherify.client.model.ParameterActivityCategory;
import io.voucherify.client.model.ParameterCampaignType;
import io.voucherify.client.model.ParameterFiltersListCustomerRedeemables;
import io.voucherify.client.model.ParameterOrderCreatedAt;
import io.voucherify.client.model.ParameterOrderListCustomers;
import io.voucherify.client.model.ParameterOrderListRedeemables;
import java.io.File;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class CustomersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CustomersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCustomerCall(CustomersCreateRequestBody customersCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CustomersCreateRequestBody localVarPostBody = customersCreateRequestBody;
        String localVarPath = "/v1/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCustomerValidateBeforeCall(CustomersCreateRequestBody customersCreateRequestBody, ApiCallback _callback) throws ApiException {
        return this.createCustomerCall(customersCreateRequestBody, _callback);
    }

    public CustomersCreateResponseBody createCustomer(CustomersCreateRequestBody customersCreateRequestBody) throws ApiException {
        ApiResponse<CustomersCreateResponseBody> localVarResp = this.createCustomerWithHttpInfo(customersCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<CustomersCreateResponseBody> createCustomerWithHttpInfo(CustomersCreateRequestBody customersCreateRequestBody) throws ApiException {
        Call localVarCall = this.createCustomerValidateBeforeCall(customersCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<CustomersCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCustomerAsync(CustomersCreateRequestBody customersCreateRequestBody, ApiCallback<CustomersCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createCustomerValidateBeforeCall(customersCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<CustomersCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call customerPermanentlyDeletionCall(String customerId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/customers/{customerId}/permanent-deletion".replace("{customerId}", this.localVarApiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call customerPermanentlyDeletionValidateBeforeCall(String customerId, ApiCallback _callback) throws ApiException {
        if (customerId == null) {
            throw new ApiException("Missing the required parameter 'customerId' when calling customerPermanentlyDeletion(Async)");
        }
        return this.customerPermanentlyDeletionCall(customerId, _callback);
    }

    public CustomersPermanentDeletionCreateResponseBody customerPermanentlyDeletion(String customerId) throws ApiException {
        ApiResponse<CustomersPermanentDeletionCreateResponseBody> localVarResp = this.customerPermanentlyDeletionWithHttpInfo(customerId);
        return localVarResp.getData();
    }

    public ApiResponse<CustomersPermanentDeletionCreateResponseBody> customerPermanentlyDeletionWithHttpInfo(String customerId) throws ApiException {
        Call localVarCall = this.customerPermanentlyDeletionValidateBeforeCall(customerId, null);
        Type localVarReturnType = new TypeToken<CustomersPermanentDeletionCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call customerPermanentlyDeletionAsync(String customerId, ApiCallback<CustomersPermanentDeletionCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.customerPermanentlyDeletionValidateBeforeCall(customerId, _callback);
        Type localVarReturnType = new TypeToken<CustomersPermanentDeletionCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCustomerCall(String customerId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/customers/{customerId}".replace("{customerId}", this.localVarApiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCustomerValidateBeforeCall(String customerId, ApiCallback _callback) throws ApiException {
        if (customerId == null) {
            throw new ApiException("Missing the required parameter 'customerId' when calling deleteCustomer(Async)");
        }
        return this.deleteCustomerCall(customerId, _callback);
    }

    public void deleteCustomer(String customerId) throws ApiException {
        this.deleteCustomerWithHttpInfo(customerId);
    }

    public ApiResponse<Void> deleteCustomerWithHttpInfo(String customerId) throws ApiException {
        Call localVarCall = this.deleteCustomerValidateBeforeCall(customerId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteCustomerAsync(String customerId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteCustomerValidateBeforeCall(customerId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getCustomerCall(String customerId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/customers/{customerId}".replace("{customerId}", this.localVarApiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCustomerValidateBeforeCall(String customerId, ApiCallback _callback) throws ApiException {
        if (customerId == null) {
            throw new ApiException("Missing the required parameter 'customerId' when calling getCustomer(Async)");
        }
        return this.getCustomerCall(customerId, _callback);
    }

    public CustomersGetResponseBody getCustomer(String customerId) throws ApiException {
        ApiResponse<CustomersGetResponseBody> localVarResp = this.getCustomerWithHttpInfo(customerId);
        return localVarResp.getData();
    }

    public ApiResponse<CustomersGetResponseBody> getCustomerWithHttpInfo(String customerId) throws ApiException {
        Call localVarCall = this.getCustomerValidateBeforeCall(customerId, null);
        Type localVarReturnType = new TypeToken<CustomersGetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCustomerAsync(String customerId, ApiCallback<CustomersGetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.getCustomerValidateBeforeCall(customerId, _callback);
        Type localVarReturnType = new TypeToken<CustomersGetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call importCustomersUsingCsvCall(File _file, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/customers/importCSV";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call importCustomersUsingCsvValidateBeforeCall(File _file, ApiCallback _callback) throws ApiException {
        return this.importCustomersUsingCsvCall(_file, _callback);
    }

    public CustomersImportCsvCreateResponseBody importCustomersUsingCsv(File _file) throws ApiException {
        ApiResponse<CustomersImportCsvCreateResponseBody> localVarResp = this.importCustomersUsingCsvWithHttpInfo(_file);
        return localVarResp.getData();
    }

    public ApiResponse<CustomersImportCsvCreateResponseBody> importCustomersUsingCsvWithHttpInfo(File _file) throws ApiException {
        Call localVarCall = this.importCustomersUsingCsvValidateBeforeCall(_file, null);
        Type localVarReturnType = new TypeToken<CustomersImportCsvCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call importCustomersUsingCsvAsync(File _file, ApiCallback<CustomersImportCsvCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.importCustomersUsingCsvValidateBeforeCall(_file, _callback);
        Type localVarReturnType = new TypeToken<CustomersImportCsvCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCustomerActivityCall(String customerId, Integer limit, ParameterOrderCreatedAt order, String startingAfterId, OffsetDateTime startDate, OffsetDateTime endDate, String campaignId, ParameterCampaignType campaignType, ParameterActivityCategory category, String type, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/customers/{customerId}/activity".replace("{customerId}", this.localVarApiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order", (Object)order));
        }
        if (startingAfterId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("starting_after_id", startingAfterId));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_date", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_date", endDate));
        }
        if (campaignId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("campaign_id", campaignId));
        }
        if (campaignType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("campaign_type", (Object)campaignType));
        }
        if (category != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("category", (Object)category));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCustomerActivityValidateBeforeCall(String customerId, Integer limit, ParameterOrderCreatedAt order, String startingAfterId, OffsetDateTime startDate, OffsetDateTime endDate, String campaignId, ParameterCampaignType campaignType, ParameterActivityCategory category, String type, ApiCallback _callback) throws ApiException {
        if (customerId == null) {
            throw new ApiException("Missing the required parameter 'customerId' when calling listCustomerActivity(Async)");
        }
        return this.listCustomerActivityCall(customerId, limit, order, startingAfterId, startDate, endDate, campaignId, campaignType, category, type, _callback);
    }

    public CustomersActivityListResponseBody listCustomerActivity(String customerId, Integer limit, ParameterOrderCreatedAt order, String startingAfterId, OffsetDateTime startDate, OffsetDateTime endDate, String campaignId, ParameterCampaignType campaignType, ParameterActivityCategory category, String type) throws ApiException {
        ApiResponse<CustomersActivityListResponseBody> localVarResp = this.listCustomerActivityWithHttpInfo(customerId, limit, order, startingAfterId, startDate, endDate, campaignId, campaignType, category, type);
        return localVarResp.getData();
    }

    public ApiResponse<CustomersActivityListResponseBody> listCustomerActivityWithHttpInfo(String customerId, Integer limit, ParameterOrderCreatedAt order, String startingAfterId, OffsetDateTime startDate, OffsetDateTime endDate, String campaignId, ParameterCampaignType campaignType, ParameterActivityCategory category, String type) throws ApiException {
        Call localVarCall = this.listCustomerActivityValidateBeforeCall(customerId, limit, order, startingAfterId, startDate, endDate, campaignId, campaignType, category, type, null);
        Type localVarReturnType = new TypeToken<CustomersActivityListResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCustomerActivityAsync(String customerId, Integer limit, ParameterOrderCreatedAt order, String startingAfterId, OffsetDateTime startDate, OffsetDateTime endDate, String campaignId, ParameterCampaignType campaignType, ParameterActivityCategory category, String type, ApiCallback<CustomersActivityListResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listCustomerActivityValidateBeforeCall(customerId, limit, order, startingAfterId, startDate, endDate, campaignId, campaignType, category, type, _callback);
        Type localVarReturnType = new TypeToken<CustomersActivityListResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCustomerRedeemablesCall(String customerId, Integer limit, ParameterOrderListRedeemables order, String startingAfterId, ParameterFiltersListCustomerRedeemables filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/customers/{customerId}/redeemables".replace("{customerId}", this.localVarApiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order", (Object)order));
        }
        if (startingAfterId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("starting_after_id", startingAfterId));
        }
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCustomerRedeemablesValidateBeforeCall(String customerId, Integer limit, ParameterOrderListRedeemables order, String startingAfterId, ParameterFiltersListCustomerRedeemables filters, ApiCallback _callback) throws ApiException {
        if (customerId == null) {
            throw new ApiException("Missing the required parameter 'customerId' when calling listCustomerRedeemables(Async)");
        }
        return this.listCustomerRedeemablesCall(customerId, limit, order, startingAfterId, filters, _callback);
    }

    public CustomersRedeemablesListResponseBody listCustomerRedeemables(String customerId, Integer limit, ParameterOrderListRedeemables order, String startingAfterId, ParameterFiltersListCustomerRedeemables filters) throws ApiException {
        ApiResponse<CustomersRedeemablesListResponseBody> localVarResp = this.listCustomerRedeemablesWithHttpInfo(customerId, limit, order, startingAfterId, filters);
        return localVarResp.getData();
    }

    public ApiResponse<CustomersRedeemablesListResponseBody> listCustomerRedeemablesWithHttpInfo(String customerId, Integer limit, ParameterOrderListRedeemables order, String startingAfterId, ParameterFiltersListCustomerRedeemables filters) throws ApiException {
        Call localVarCall = this.listCustomerRedeemablesValidateBeforeCall(customerId, limit, order, startingAfterId, filters, null);
        Type localVarReturnType = new TypeToken<CustomersRedeemablesListResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCustomerRedeemablesAsync(String customerId, Integer limit, ParameterOrderListRedeemables order, String startingAfterId, ParameterFiltersListCustomerRedeemables filters, ApiCallback<CustomersRedeemablesListResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listCustomerRedeemablesValidateBeforeCall(customerId, limit, order, startingAfterId, filters, _callback);
        Type localVarReturnType = new TypeToken<CustomersRedeemablesListResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCustomerSegmentsCall(String customerId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/customers/{customerId}/segments".replace("{customerId}", this.localVarApiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCustomerSegmentsValidateBeforeCall(String customerId, ApiCallback _callback) throws ApiException {
        if (customerId == null) {
            throw new ApiException("Missing the required parameter 'customerId' when calling listCustomerSegments(Async)");
        }
        return this.listCustomerSegmentsCall(customerId, _callback);
    }

    public CustomersSegmentsListResponseBody listCustomerSegments(String customerId) throws ApiException {
        ApiResponse<CustomersSegmentsListResponseBody> localVarResp = this.listCustomerSegmentsWithHttpInfo(customerId);
        return localVarResp.getData();
    }

    public ApiResponse<CustomersSegmentsListResponseBody> listCustomerSegmentsWithHttpInfo(String customerId) throws ApiException {
        Call localVarCall = this.listCustomerSegmentsValidateBeforeCall(customerId, null);
        Type localVarReturnType = new TypeToken<CustomersSegmentsListResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCustomerSegmentsAsync(String customerId, ApiCallback<CustomersSegmentsListResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listCustomerSegmentsValidateBeforeCall(customerId, _callback);
        Type localVarReturnType = new TypeToken<CustomersSegmentsListResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCustomersCall(Integer limit, Integer page, String email, String city, String name, String segmentId, OffsetDateTime createdAtBefore, OffsetDateTime createdAtAfter, OffsetDateTime updatedAtBefore, OffsetDateTime updatedAtAfter, ParameterOrderListCustomers order, OffsetDateTime startingAfter, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (email != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("email", email));
        }
        if (city != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("city", city));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (segmentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("segment_id", segmentId));
        }
        if (createdAtBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("created_at[before]", createdAtBefore));
        }
        if (createdAtAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("created_at[after]", createdAtAfter));
        }
        if (updatedAtBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updated_at[before]", updatedAtBefore));
        }
        if (updatedAtAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updated_at[after]", updatedAtAfter));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order", (Object)order));
        }
        if (startingAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("starting_after", startingAfter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCustomersValidateBeforeCall(Integer limit, Integer page, String email, String city, String name, String segmentId, OffsetDateTime createdAtBefore, OffsetDateTime createdAtAfter, OffsetDateTime updatedAtBefore, OffsetDateTime updatedAtAfter, ParameterOrderListCustomers order, OffsetDateTime startingAfter, ApiCallback _callback) throws ApiException {
        return this.listCustomersCall(limit, page, email, city, name, segmentId, createdAtBefore, createdAtAfter, updatedAtBefore, updatedAtAfter, order, startingAfter, _callback);
    }

    public CustomersListResponseBody listCustomers(Integer limit, Integer page, String email, String city, String name, String segmentId, OffsetDateTime createdAtBefore, OffsetDateTime createdAtAfter, OffsetDateTime updatedAtBefore, OffsetDateTime updatedAtAfter, ParameterOrderListCustomers order, OffsetDateTime startingAfter) throws ApiException {
        ApiResponse<CustomersListResponseBody> localVarResp = this.listCustomersWithHttpInfo(limit, page, email, city, name, segmentId, createdAtBefore, createdAtAfter, updatedAtBefore, updatedAtAfter, order, startingAfter);
        return localVarResp.getData();
    }

    public ApiResponse<CustomersListResponseBody> listCustomersWithHttpInfo(Integer limit, Integer page, String email, String city, String name, String segmentId, OffsetDateTime createdAtBefore, OffsetDateTime createdAtAfter, OffsetDateTime updatedAtBefore, OffsetDateTime updatedAtAfter, ParameterOrderListCustomers order, OffsetDateTime startingAfter) throws ApiException {
        Call localVarCall = this.listCustomersValidateBeforeCall(limit, page, email, city, name, segmentId, createdAtBefore, createdAtAfter, updatedAtBefore, updatedAtAfter, order, startingAfter, null);
        Type localVarReturnType = new TypeToken<CustomersListResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCustomersAsync(Integer limit, Integer page, String email, String city, String name, String segmentId, OffsetDateTime createdAtBefore, OffsetDateTime createdAtAfter, OffsetDateTime updatedAtBefore, OffsetDateTime updatedAtAfter, ParameterOrderListCustomers order, OffsetDateTime startingAfter, ApiCallback<CustomersListResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listCustomersValidateBeforeCall(limit, page, email, city, name, segmentId, createdAtBefore, createdAtAfter, updatedAtBefore, updatedAtAfter, order, startingAfter, _callback);
        Type localVarReturnType = new TypeToken<CustomersListResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCustomerCall(String customerId, CustomersUpdateRequestBody customersUpdateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CustomersUpdateRequestBody localVarPostBody = customersUpdateRequestBody;
        String localVarPath = "/v1/customers/{customerId}".replace("{customerId}", this.localVarApiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCustomerValidateBeforeCall(String customerId, CustomersUpdateRequestBody customersUpdateRequestBody, ApiCallback _callback) throws ApiException {
        if (customerId == null) {
            throw new ApiException("Missing the required parameter 'customerId' when calling updateCustomer(Async)");
        }
        return this.updateCustomerCall(customerId, customersUpdateRequestBody, _callback);
    }

    public CustomersUpdateResponseBody updateCustomer(String customerId, CustomersUpdateRequestBody customersUpdateRequestBody) throws ApiException {
        ApiResponse<CustomersUpdateResponseBody> localVarResp = this.updateCustomerWithHttpInfo(customerId, customersUpdateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<CustomersUpdateResponseBody> updateCustomerWithHttpInfo(String customerId, CustomersUpdateRequestBody customersUpdateRequestBody) throws ApiException {
        Call localVarCall = this.updateCustomerValidateBeforeCall(customerId, customersUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<CustomersUpdateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCustomerAsync(String customerId, CustomersUpdateRequestBody customersUpdateRequestBody, ApiCallback<CustomersUpdateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateCustomerValidateBeforeCall(customerId, customersUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<CustomersUpdateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCustomersInBulkCall(List<CustomersUpdateInBulkRequestBody> customersUpdateInBulkRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<CustomersUpdateInBulkRequestBody> localVarPostBody = customersUpdateInBulkRequestBody;
        String localVarPath = "/v1/customers/bulk/async";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCustomersInBulkValidateBeforeCall(List<CustomersUpdateInBulkRequestBody> customersUpdateInBulkRequestBody, ApiCallback _callback) throws ApiException {
        return this.updateCustomersInBulkCall(customersUpdateInBulkRequestBody, _callback);
    }

    public CustomersUpdateInBulkResponseBody updateCustomersInBulk(List<CustomersUpdateInBulkRequestBody> customersUpdateInBulkRequestBody) throws ApiException {
        ApiResponse<CustomersUpdateInBulkResponseBody> localVarResp = this.updateCustomersInBulkWithHttpInfo(customersUpdateInBulkRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<CustomersUpdateInBulkResponseBody> updateCustomersInBulkWithHttpInfo(List<CustomersUpdateInBulkRequestBody> customersUpdateInBulkRequestBody) throws ApiException {
        Call localVarCall = this.updateCustomersInBulkValidateBeforeCall(customersUpdateInBulkRequestBody, null);
        Type localVarReturnType = new TypeToken<CustomersUpdateInBulkResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCustomersInBulkAsync(List<CustomersUpdateInBulkRequestBody> customersUpdateInBulkRequestBody, ApiCallback<CustomersUpdateInBulkResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateCustomersInBulkValidateBeforeCall(customersUpdateInBulkRequestBody, _callback);
        Type localVarReturnType = new TypeToken<CustomersUpdateInBulkResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCustomersMetadataInBulkCall(CustomersMetadataUpdateInBulkRequestBody customersMetadataUpdateInBulkRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CustomersMetadataUpdateInBulkRequestBody localVarPostBody = customersMetadataUpdateInBulkRequestBody;
        String localVarPath = "/v1/customers/metadata/async";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCustomersMetadataInBulkValidateBeforeCall(CustomersMetadataUpdateInBulkRequestBody customersMetadataUpdateInBulkRequestBody, ApiCallback _callback) throws ApiException {
        return this.updateCustomersMetadataInBulkCall(customersMetadataUpdateInBulkRequestBody, _callback);
    }

    public CustomersMetadataUpdateInBulkResponseBody updateCustomersMetadataInBulk(CustomersMetadataUpdateInBulkRequestBody customersMetadataUpdateInBulkRequestBody) throws ApiException {
        ApiResponse<CustomersMetadataUpdateInBulkResponseBody> localVarResp = this.updateCustomersMetadataInBulkWithHttpInfo(customersMetadataUpdateInBulkRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<CustomersMetadataUpdateInBulkResponseBody> updateCustomersMetadataInBulkWithHttpInfo(CustomersMetadataUpdateInBulkRequestBody customersMetadataUpdateInBulkRequestBody) throws ApiException {
        Call localVarCall = this.updateCustomersMetadataInBulkValidateBeforeCall(customersMetadataUpdateInBulkRequestBody, null);
        Type localVarReturnType = new TypeToken<CustomersMetadataUpdateInBulkResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCustomersMetadataInBulkAsync(CustomersMetadataUpdateInBulkRequestBody customersMetadataUpdateInBulkRequestBody, ApiCallback<CustomersMetadataUpdateInBulkResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateCustomersMetadataInBulkValidateBeforeCall(customersMetadataUpdateInBulkRequestBody, _callback);
        Type localVarReturnType = new TypeToken<CustomersMetadataUpdateInBulkResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

