/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.api;

import com.google.gson.reflect.TypeToken;
import io.voucherify.client.ApiCallback;
import io.voucherify.client.ApiClient;
import io.voucherify.client.ApiException;
import io.voucherify.client.ApiResponse;
import io.voucherify.client.Configuration;
import io.voucherify.client.Pair;
import io.voucherify.client.model.ExportsCreateRequestBody;
import io.voucherify.client.model.ExportsCreateResponseBody;
import io.voucherify.client.model.ExportsGetResponseBody;
import io.voucherify.client.model.ExportsListResponseBody;
import io.voucherify.client.model.ParameterOrderListExports;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ExportsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExportsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExportsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createExportCall(ExportsCreateRequestBody exportsCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ExportsCreateRequestBody localVarPostBody = exportsCreateRequestBody;
        String localVarPath = "/v1/exports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createExportValidateBeforeCall(ExportsCreateRequestBody exportsCreateRequestBody, ApiCallback _callback) throws ApiException {
        return this.createExportCall(exportsCreateRequestBody, _callback);
    }

    public ExportsCreateResponseBody createExport(ExportsCreateRequestBody exportsCreateRequestBody) throws ApiException {
        ApiResponse<ExportsCreateResponseBody> localVarResp = this.createExportWithHttpInfo(exportsCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<ExportsCreateResponseBody> createExportWithHttpInfo(ExportsCreateRequestBody exportsCreateRequestBody) throws ApiException {
        Call localVarCall = this.createExportValidateBeforeCall(exportsCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<ExportsCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createExportAsync(ExportsCreateRequestBody exportsCreateRequestBody, ApiCallback<ExportsCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createExportValidateBeforeCall(exportsCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<ExportsCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteExportCall(String exportId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/exports/{exportId}".replace("{exportId}", this.localVarApiClient.escapeString(exportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteExportValidateBeforeCall(String exportId, ApiCallback _callback) throws ApiException {
        if (exportId == null) {
            throw new ApiException("Missing the required parameter 'exportId' when calling deleteExport(Async)");
        }
        return this.deleteExportCall(exportId, _callback);
    }

    public void deleteExport(String exportId) throws ApiException {
        this.deleteExportWithHttpInfo(exportId);
    }

    public ApiResponse<Void> deleteExportWithHttpInfo(String exportId) throws ApiException {
        Call localVarCall = this.deleteExportValidateBeforeCall(exportId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteExportAsync(String exportId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteExportValidateBeforeCall(exportId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call downloadExportCall(String exportId, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/exports/{export_Id}".replace("{export_Id}", this.localVarApiClient.escapeString(exportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"text/plain"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadExportValidateBeforeCall(String exportId, String token, ApiCallback _callback) throws ApiException {
        if (exportId == null) {
            throw new ApiException("Missing the required parameter 'exportId' when calling downloadExport(Async)");
        }
        return this.downloadExportCall(exportId, token, _callback);
    }

    public String downloadExport(String exportId, String token) throws ApiException {
        ApiResponse<String> localVarResp = this.downloadExportWithHttpInfo(exportId, token);
        return localVarResp.getData();
    }

    public ApiResponse<String> downloadExportWithHttpInfo(String exportId, String token) throws ApiException {
        Call localVarCall = this.downloadExportValidateBeforeCall(exportId, token, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call downloadExportAsync(String exportId, String token, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.downloadExportValidateBeforeCall(exportId, token, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExportCall(String exportId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/exports/{exportId}".replace("{exportId}", this.localVarApiClient.escapeString(exportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExportValidateBeforeCall(String exportId, ApiCallback _callback) throws ApiException {
        if (exportId == null) {
            throw new ApiException("Missing the required parameter 'exportId' when calling getExport(Async)");
        }
        return this.getExportCall(exportId, _callback);
    }

    public ExportsGetResponseBody getExport(String exportId) throws ApiException {
        ApiResponse<ExportsGetResponseBody> localVarResp = this.getExportWithHttpInfo(exportId);
        return localVarResp.getData();
    }

    public ApiResponse<ExportsGetResponseBody> getExportWithHttpInfo(String exportId) throws ApiException {
        Call localVarCall = this.getExportValidateBeforeCall(exportId, null);
        Type localVarReturnType = new TypeToken<ExportsGetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExportAsync(String exportId, ApiCallback<ExportsGetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.getExportValidateBeforeCall(exportId, _callback);
        Type localVarReturnType = new TypeToken<ExportsGetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listExportsCall(Integer limit, Integer page, ParameterOrderListExports order, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/exports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order", (Object)order));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listExportsValidateBeforeCall(Integer limit, Integer page, ParameterOrderListExports order, ApiCallback _callback) throws ApiException {
        return this.listExportsCall(limit, page, order, _callback);
    }

    public ExportsListResponseBody listExports(Integer limit, Integer page, ParameterOrderListExports order) throws ApiException {
        ApiResponse<ExportsListResponseBody> localVarResp = this.listExportsWithHttpInfo(limit, page, order);
        return localVarResp.getData();
    }

    public ApiResponse<ExportsListResponseBody> listExportsWithHttpInfo(Integer limit, Integer page, ParameterOrderListExports order) throws ApiException {
        Call localVarCall = this.listExportsValidateBeforeCall(limit, page, order, null);
        Type localVarReturnType = new TypeToken<ExportsListResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listExportsAsync(Integer limit, Integer page, ParameterOrderListExports order, ApiCallback<ExportsListResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listExportsValidateBeforeCall(limit, page, order, _callback);
        Type localVarReturnType = new TypeToken<ExportsListResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

