/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.api;

import com.google.gson.reflect.TypeToken;
import io.voucherify.client.ApiCallback;
import io.voucherify.client.ApiClient;
import io.voucherify.client.ApiException;
import io.voucherify.client.ApiResponse;
import io.voucherify.client.Configuration;
import io.voucherify.client.Pair;
import io.voucherify.client.model.LocationsGetResponseBody;
import io.voucherify.client.model.LocationsListResponseBody;
import io.voucherify.client.model.ParameterFiltersListLocations;
import io.voucherify.client.model.ParameterOrderListLocations;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class LocationsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public LocationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LocationsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getLocationCall(String locationId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/locations/{locationId}".replace("{locationId}", this.localVarApiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLocationValidateBeforeCall(String locationId, ApiCallback _callback) throws ApiException {
        if (locationId == null) {
            throw new ApiException("Missing the required parameter 'locationId' when calling getLocation(Async)");
        }
        return this.getLocationCall(locationId, _callback);
    }

    public LocationsGetResponseBody getLocation(String locationId) throws ApiException {
        ApiResponse<LocationsGetResponseBody> localVarResp = this.getLocationWithHttpInfo(locationId);
        return localVarResp.getData();
    }

    public ApiResponse<LocationsGetResponseBody> getLocationWithHttpInfo(String locationId) throws ApiException {
        Call localVarCall = this.getLocationValidateBeforeCall(locationId, null);
        Type localVarReturnType = new TypeToken<LocationsGetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLocationAsync(String locationId, ApiCallback<LocationsGetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.getLocationValidateBeforeCall(locationId, _callback);
        Type localVarReturnType = new TypeToken<LocationsGetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listLocationsCall(Integer limit, ParameterOrderListLocations order, ParameterFiltersListLocations filters, OffsetDateTime endDate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/locations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order", (Object)order));
        }
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_date", endDate));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listLocationsValidateBeforeCall(Integer limit, ParameterOrderListLocations order, ParameterFiltersListLocations filters, OffsetDateTime endDate, ApiCallback _callback) throws ApiException {
        return this.listLocationsCall(limit, order, filters, endDate, _callback);
    }

    public LocationsListResponseBody listLocations(Integer limit, ParameterOrderListLocations order, ParameterFiltersListLocations filters, OffsetDateTime endDate) throws ApiException {
        ApiResponse<LocationsListResponseBody> localVarResp = this.listLocationsWithHttpInfo(limit, order, filters, endDate);
        return localVarResp.getData();
    }

    public ApiResponse<LocationsListResponseBody> listLocationsWithHttpInfo(Integer limit, ParameterOrderListLocations order, ParameterFiltersListLocations filters, OffsetDateTime endDate) throws ApiException {
        Call localVarCall = this.listLocationsValidateBeforeCall(limit, order, filters, endDate, null);
        Type localVarReturnType = new TypeToken<LocationsListResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listLocationsAsync(Integer limit, ParameterOrderListLocations order, ParameterFiltersListLocations filters, OffsetDateTime endDate, ApiCallback<LocationsListResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listLocationsValidateBeforeCall(limit, order, filters, endDate, _callback);
        Type localVarReturnType = new TypeToken<LocationsListResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

